/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="modules")
public class ModulesReport
extends AbstractProjectInfoReport {
    public void executeReport(Locale locale) {
        new ModulesRenderer(this.getSink(), this.getProject(), this.getI18N(locale), locale, this.siteTool).render();
    }

    public String getOutputName() {
        return "modules";
    }

    protected String getI18Nsection() {
        return "modules";
    }

    public boolean canGenerateReport() {
        return this.getProject().getModel().getModules() != null && !this.getProject().getModel().getModules().isEmpty();
    }

    static class ModulesRenderer
    extends AbstractProjectInfoRenderer {
        protected MavenProject project;
        protected SiteTool siteTool;

        ModulesRenderer(Sink sink, MavenProject project, I18N i18n, Locale locale, SiteTool siteTool) {
            super(sink, i18n, locale);
            this.project = project;
            this.siteTool = siteTool;
        }

        protected String getI18Nsection() {
            return "modules";
        }

        public void renderBody() {
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.startTable();
            String name = this.getI18nString("header.name");
            String description = this.getI18nString("header.description");
            this.tableHeader(new String[]{name, description});
            String baseURL = this.project.getUrl();
            List modules = this.project.getCollectedProjects();
            for (MavenProject moduleProject : modules) {
                Model moduleModel = moduleProject.getModel();
                String moduleName = moduleProject.getName();
                String moduleHref = this.getRelativeLink(baseURL, moduleProject.getUrl(), moduleProject.getArtifactId());
                this.tableRow(new String[]{this.linkedName(moduleName, moduleHref), moduleModel.getDescription()});
            }
            this.endTable();
            this.endSection();
        }

        private String getRelativeLink(String baseUrl, String href, String defaultHref) {
            String selectedHref = href;
            if (selectedHref == null) {
                selectedHref = defaultHref;
            }
            if (baseUrl != null) {
                selectedHref = this.siteTool.getRelativePath(selectedHref, baseUrl);
            }
            selectedHref = selectedHref.endsWith("/") ? selectedHref.concat("index.html") : selectedHref.concat("/index.html");
            return selectedHref;
        }

        private String linkedName(String name, String link) {
            return "{" + name + ", ./" + link + "}";
        }
    }
}

