/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Organization;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;

public class ProjectSummaryReport
extends AbstractProjectInfoReport {
    protected void executeReport(Locale locale) throws MavenReportException {
        new ProjectSummaryRenderer(this.getSink(), locale).render();
    }

    public String getOutputName() {
        return "project-summary";
    }

    protected String getI18Nsection() {
        return "summary";
    }

    private class ProjectSummaryRenderer
    extends AbstractProjectInfoRenderer {
        ProjectSummaryRenderer(Sink sink, Locale locale) {
            super(sink, ProjectSummaryReport.this.i18n, locale);
        }

        protected String getI18Nsection() {
            return "summary";
        }

        protected void renderBody() {
            String homepage;
            String description;
            this.startSection(this.getTitle());
            String name = ProjectSummaryReport.this.project.getName();
            if (name == null) {
                name = "";
            }
            if ((description = ProjectSummaryReport.this.project.getDescription()) == null) {
                description = "";
            }
            if ((homepage = ProjectSummaryReport.this.project.getUrl()) == null) {
                homepage = "";
            }
            this.startSection(this.getI18nString("general.title"));
            this.startTable();
            this.tableHeader(new String[]{this.getI18nString("field"), this.getI18nString("value")});
            this.tableRow(new String[]{this.getI18nString("general.name"), name});
            this.tableRow(new String[]{this.getI18nString("general.description"), description});
            this.tableRowWithLink(new String[]{this.getI18nString("general.homepage"), homepage});
            this.endTable();
            this.endSection();
            this.startSection(this.getI18nString("organization.title"));
            Organization organization = ProjectSummaryReport.this.project.getOrganization();
            if (organization == null) {
                this.paragraph(this.getI18nString("noorganization"));
            } else {
                if (organization.getName() == null) {
                    organization.setName("");
                }
                if (organization.getUrl() == null) {
                    organization.setUrl("");
                }
                this.startTable();
                this.tableHeader(new String[]{this.getI18nString("field"), this.getI18nString("value")});
                this.tableRow(new String[]{this.getI18nString("organization.name"), organization.getName()});
                this.tableRowWithLink(new String[]{this.getI18nString("organization.url"), organization.getUrl()});
                this.endTable();
            }
            this.endSection();
            this.startSection(this.getI18nString("build.title"));
            this.startTable();
            this.tableHeader(new String[]{this.getI18nString("field"), this.getI18nString("value")});
            this.tableRow(new String[]{this.getI18nString("build.groupid"), ProjectSummaryReport.this.project.getGroupId()});
            this.tableRow(new String[]{this.getI18nString("build.artifactid"), ProjectSummaryReport.this.project.getArtifactId()});
            this.tableRow(new String[]{this.getI18nString("build.version"), ProjectSummaryReport.this.project.getVersion()});
            this.tableRow(new String[]{this.getI18nString("build.type"), ProjectSummaryReport.this.project.getPackaging()});
            this.endTable();
            this.endSection();
            this.endSection();
        }

        private void tableRowWithLink(String[] content) {
            this.sink.tableRow();
            for (int ctr = 0; ctr < content.length; ++ctr) {
                String cell = content[ctr];
                this.sink.tableCell();
                if (StringUtils.isEmpty((String)cell)) {
                    this.sink.text("-");
                } else if (ctr == content.length - 1 && cell.length() > 0) {
                    this.sink.link(cell);
                    this.sink.text(cell);
                    this.sink.link_();
                } else {
                    this.sink.text(cell);
                }
                this.sink.tableCell_();
            }
            this.sink.tableRow_();
        }
    }
}

