/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.PmdFileInfo;
import org.apache.maven.plugins.pmd.model.CpdFile;
import org.apache.maven.plugins.pmd.model.Duplication;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class CpdReportRenderer
extends AbstractMavenReportRenderer {
    private final I18N i18n;
    private final Locale locale;
    private final Map<File, PmdFileInfo> files;
    private final Collection<Duplication> duplications;
    private final boolean aggregate;

    public CpdReportRenderer(Sink sink, I18N i18n, Locale locale, Map<File, PmdFileInfo> files, Collection<Duplication> duplications, boolean aggregate) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.files = files;
        this.duplications = duplications;
        this.aggregate = aggregate;
    }

    public String getTitle() {
        return this.getI18nString("title");
    }

    private String getI18nString(String key) {
        return this.i18n.getString("cpd-report", this.locale, "report.cpd." + key);
    }

    protected void renderBody() {
        this.startSection(this.getTitle());
        this.sink.paragraph();
        this.sink.text(this.getI18nString("cpdlink") + " ");
        this.link("https://pmd.github.io/latest/pmd_userdocs_cpd.html", "CPD");
        this.sink.text(" " + AbstractPmdReport.getPmdVersion() + ".");
        this.sink.paragraph_();
        if (!this.duplications.isEmpty()) {
            this.renderDuplications();
        } else {
            this.paragraph(this.getI18nString("noProblems"));
        }
        this.endSection();
    }

    private void generateFileLine(CpdFile duplicationMark) {
        String filename = duplicationMark.getPath();
        File file = new File(filename);
        PmdFileInfo fileInfo = this.files.get(file);
        File sourceDirectory = fileInfo.getSourceDirectory();
        filename = StringUtils.substring((String)filename, (int)(sourceDirectory.getAbsolutePath().length() + 1));
        String xrefLocation = fileInfo.getXrefLocation();
        MavenProject projectFile = fileInfo.getProject();
        int line = duplicationMark.getLine();
        this.sink.tableRow();
        this.tableCell(filename);
        if (this.aggregate) {
            this.tableCell(projectFile.getName());
        }
        this.sink.tableCell();
        if (xrefLocation != null) {
            this.sink.link(xrefLocation + "/" + filename.replaceAll("\\.java$", ".html").replace('\\', '/') + "#L" + line);
        }
        this.sink.text(String.valueOf(line));
        if (xrefLocation != null) {
            this.sink.link_();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void renderDuplications() {
        this.startSection(this.getI18nString("dupes"));
        for (Duplication duplication : this.duplications) {
            String code = duplication.getCodefragment();
            this.startTable();
            this.sink.tableRow();
            this.tableHeaderCell(this.getI18nString("column.file"));
            if (this.aggregate) {
                this.tableHeaderCell(this.getI18nString("column.project"));
            }
            this.tableHeaderCell(this.getI18nString("column.line"));
            this.sink.tableRow_();
            for (CpdFile mark : duplication.getFiles()) {
                this.generateFileLine(mark);
            }
            this.sink.tableRow();
            int colspan = 2;
            if (this.aggregate) {
                colspan = 3;
            }
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttribute((Object)HTML.Attribute.COLSPAN, (Object)colspan);
            this.sink.tableCell((SinkEventAttributes)att);
            this.verbatimText(code);
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.endTable();
        }
        this.endSection();
    }
}

