/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.pmd.ExcludeFromFile;
import org.apache.maven.plugins.pmd.model.CpdFile;
import org.apache.maven.plugins.pmd.model.Duplication;

public class ExcludeDuplicationsFromFile
implements ExcludeFromFile<Duplication> {
    private final List<Set<String>> exclusionList = new ArrayList<Set<String>>();

    @Override
    public boolean isExcludedFromFailure(Duplication errorDetail) {
        HashSet<String> uniquePaths = new HashSet<String>();
        for (CpdFile cpdFile : errorDetail.getFiles()) {
            uniquePaths.add(cpdFile.getPath());
        }
        return this.isExcludedFromFailure((Set<String>)uniquePaths);
    }

    @Override
    public boolean isExcludedFromFailure(Match errorDetail) {
        HashSet<String> uniquePaths = new HashSet<String>();
        for (Mark mark : errorDetail.getMarkSet()) {
            uniquePaths.add(mark.getFilename());
        }
        return this.isExcludedFromFailure((Set<String>)uniquePaths);
    }

    @Override
    private boolean isExcludedFromFailure(Set<String> uniquePaths) {
        for (Set<String> singleExclusionGroup : this.exclusionList) {
            if (uniquePaths.size() != singleExclusionGroup.size() || !this.duplicationExcludedByGroup(uniquePaths, singleExclusionGroup)) continue;
            return true;
        }
        return false;
    }

    private boolean duplicationExcludedByGroup(Set<String> uniquePaths, Set<String> singleExclusionGroup) {
        for (String path : uniquePaths) {
            if (this.fileExcludedByGroup(path, singleExclusionGroup)) continue;
            return false;
        }
        return true;
    }

    private boolean fileExcludedByGroup(String path, Set<String> singleExclusionGroup) {
        String formattedPath = path.replace('\\', '.').replace('/', '.');
        for (String className : singleExclusionGroup) {
            if (!formattedPath.contains(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadExcludeFromFailuresData(String excludeFromFailureFile) throws MojoExecutionException {
        if (excludeFromFailureFile == null || excludeFromFailureFile.isEmpty()) {
            return;
        }
        try (Stream<String> lines = Files.lines(Paths.get(excludeFromFailureFile, new String[0]));){
            this.exclusionList.addAll(lines.filter(line -> !line.startsWith("#")).map(line -> this.createSetFromExclusionLine((String)line)).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load file " + excludeFromFailureFile, (Exception)e);
        }
    }

    private Set<String> createSetFromExclusionLine(String line) {
        HashSet<String> result = new HashSet<String>();
        for (String className : line.split(",")) {
            result.add(className.trim());
        }
        return result;
    }

    @Override
    public int countExclusions() {
        return this.exclusionList.size();
    }
}

