/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.renderers.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.PmdReportRenderer;
import org.apache.maven.plugins.pmd.exec.PmdExecutor;
import org.apache.maven.plugins.pmd.exec.PmdRequest;
import org.apache.maven.plugins.pmd.exec.PmdResult;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.ExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="pmd", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class PmdReport
extends AbstractPmdReport {
    @Parameter(property="targetJdk", defaultValue="${maven.compiler.source}")
    private String targetJdk;
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumPriority", defaultValue="5")
    private int minimumPriority = 5;
    @Parameter(property="pmd.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    String[] rulesets = new String[]{"/rulesets/java/maven-pmd-plugin-default.xml"};
    @Parameter(property="pmd.typeResolution", defaultValue="true")
    private boolean typeResolution;
    @Parameter(property="pmd.benchmark", defaultValue="false")
    private boolean benchmark;
    @Parameter(property="pmd.benchmarkOutputFilename", defaultValue="${project.build.directory}/pmd-benchmark.txt")
    private String benchmarkOutputFilename;
    @Parameter(property="pmd.suppressMarker")
    private String suppressMarker;
    @Parameter(property="pmd.skipPmdError", defaultValue="true")
    private boolean skipPmdError;
    @Parameter(property="pmd.analysisCache", defaultValue="false")
    private boolean analysisCache;
    @Parameter(property="pmd.analysisCacheLocation", defaultValue="${project.build.directory}/pmd/pmd.cache")
    private String analysisCacheLocation;
    @Parameter(property="pmd.renderProcessingErrors", defaultValue="true")
    private boolean renderProcessingErrors = true;
    @Parameter(property="pmd.renderRuleViolationPriority", defaultValue="true")
    private boolean renderRuleViolationPriority = true;
    @Parameter(property="pmd.renderViolationsByPriority", defaultValue="true")
    private boolean renderViolationsByPriority = true;
    @Parameter(property="pmd.renderSuppressedViolations", defaultValue="true")
    private boolean renderSuppressedViolations = true;
    @Parameter(property="pmd.rulesetsTargetDirectory", defaultValue="${project.build.directory}/pmd/rulesets")
    private File rulesetsTargetDirectory;
    @Component
    private ResourceManager locator;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private I18N i18n;
    private PmdResult pmdResult;

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    protected String getI18nString(Locale locale, String key) {
        return this.i18n.getString("pmd-report", locale, "report.pmd." + key);
    }

    public void setRulesets(String[] rulesets) {
        this.rulesets = Arrays.copyOf(rulesets, rulesets.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            PmdReportRenderer r = new PmdReportRenderer(this.getLog(), this.getSink(), this.i18n, locale, this.filesToProcess, this.pmdResult.getViolations(), this.renderRuleViolationPriority, this.renderViolationsByPriority, this.isAggregator());
            if (this.renderSuppressedViolations) {
                r.setSuppressedViolations(this.pmdResult.getSuppressedViolations());
            }
            if (this.renderProcessingErrors) {
                r.setProcessingErrors(this.pmdResult.getErrors());
            }
            r.render();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    @Override
    public boolean canGenerateReport() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping PMD execution");
            return false;
        }
        boolean result = super.canGenerateReport();
        if (result) {
            try {
                this.executePmd();
                if (this.skipEmptyReport && !(result = this.pmdResult.hasViolations())) {
                    this.getLog().debug((CharSequence)"Skipping report since skipEmptyReport is true and there are no PMD violations.");
                }
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void executePmd() throws MavenReportException {
        if (this.pmdResult != null) {
            this.getLog().debug((CharSequence)"PMD has already been run - skipping redundant execution.");
            return;
        }
        try {
            this.filesToProcess = this.getFilesToProcess();
            if (this.filesToProcess.isEmpty() && !"java".equals(this.language)) {
                this.getLog().warn((CharSequence)"No files found to process. Did you add your additional source folders like javascript? (see also build-helper-maven-plugin)");
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Can't get file list", (Exception)e);
        }
        PmdRequest request = new PmdRequest();
        request.setLanguageAndVersion(this.language, this.targetJdk);
        request.setRulesets(this.resolveRulesets());
        request.setAuxClasspath(this.typeResolution ? this.determineAuxClasspath() : null);
        request.setSourceEncoding(this.getInputEncoding());
        request.addFiles(this.filesToProcess.keySet());
        request.setMinimumPriority(this.minimumPriority);
        request.setSuppressMarker(this.suppressMarker);
        request.setBenchmarkOutputLocation(this.benchmark ? this.benchmarkOutputFilename : null);
        request.setAnalysisCacheLocation(this.analysisCache ? this.analysisCacheLocation : null);
        request.setExcludeFromFailureFile(this.excludeFromFailureFile);
        request.setTargetDirectory(this.targetDirectory.getAbsolutePath());
        request.setOutputEncoding(this.getOutputEncoding());
        request.setFormat(this.format);
        request.setShowPmdLog(this.showPmdLog);
        request.setSkipPmdError(this.skipPmdError);
        request.setIncludeXmlInSite(this.includeXmlInSite);
        request.setReportOutputDirectory(this.getReportOutputDirectory().getAbsolutePath());
        request.setLogLevel(this.determineCurrentRootLogLevel());
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in maven-pmd-plugin: " + tc));
            String javaExecutable = tc.findTool("java");
            request.setJavaExecutable(javaExecutable);
        }
        this.getLog().info((CharSequence)("PMD version: " + AbstractPmdReport.getPmdVersion()));
        this.pmdResult = PmdExecutor.execute(request);
    }

    private List<String> resolveRulesets() throws MavenReportException {
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("file", this.project.getBasedir().getAbsolutePath());
        this.locator.addSearchPath("file", this.session.getRequest().getBaseDirectory());
        this.locator.setOutputDirectory(this.rulesetsTargetDirectory);
        String[] sets = new String[this.rulesets.length];
        try {
            for (int idx = 0; idx < this.rulesets.length; ++idx) {
                String set = this.rulesets[idx];
                this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                String rulesetFilename = this.determineRulesetFilename(set);
                File ruleset = this.locator.getResourceAsFile(rulesetFilename, this.getLocationTemp(set));
                if (null == ruleset) {
                    throw new MavenReportException("Could not resolve " + set);
                }
                sets[idx] = ruleset.getAbsolutePath();
            }
        }
        catch (FileResourceCreationException | ResourceNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        return Arrays.asList(sets);
    }

    private String determineRulesetFilename(String ruleset) {
        String rulesetFilename;
        String result = ruleset.trim();
        String lowercase = result.toLowerCase(Locale.ROOT);
        if (lowercase.startsWith("http://") || lowercase.startsWith("https://") || lowercase.endsWith(".xml")) {
            return result;
        }
        if (result.indexOf(47) > -1 && (rulesetFilename = result.substring(0, result.lastIndexOf(47))).toLowerCase(Locale.ROOT).endsWith(".xml")) {
            return rulesetFilename;
        }
        int dashIndex = lowercase.indexOf(45);
        if (dashIndex > -1 && lowercase.indexOf(45, dashIndex + 1) == -1) {
            String language = result.substring(0, dashIndex);
            String rulesetName = result.substring(dashIndex + 1);
            return "rulesets/" + language + "/" + rulesetName + ".xml";
        }
        return result;
    }

    protected String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        if (!(loc = loc.replaceAll("[\\?\\:\\&\\=\\%]", "_")).endsWith(".xml")) {
            loc = loc + ".xml";
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    private String determineAuxClasspath() throws MavenReportException {
        try {
            ArrayList classpath = new ArrayList();
            if (this.isAggregator()) {
                ArrayList<String> dependencies = new ArrayList<String>();
                ArrayList<String> exclusionPatterns = new ArrayList<String>();
                for (MavenProject localProject : this.getAggregatedProjects()) {
                    exclusionPatterns.add(localProject.getGroupId() + ":" + localProject.getArtifactId());
                }
                AndFilter filter = new AndFilter(Arrays.asList(new ExclusionsFilter(exclusionPatterns), this.includeTests ? ScopeFilter.including((String[])new String[]{"compile", "provided", "test"}) : ScopeFilter.including((String[])new String[]{"compile", "provided"})));
                for (MavenProject localProject : this.getAggregatedProjects()) {
                    DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                    buildingRequest.getRemoteRepositories().addAll(localProject.getRemoteArtifactRepositories());
                    Iterable resolvedDependencies = this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, (Collection)localProject.getDependencies(), null, (TransformableFilter)filter);
                    for (ArtifactResult resolvedArtifact : resolvedDependencies) {
                        dependencies.add(resolvedArtifact.getArtifact().getFile().toString());
                    }
                    List projectClasspath = this.includeTests ? localProject.getTestClasspathElements() : localProject.getCompileClasspathElements();
                    classpath.addAll(projectClasspath);
                    if (localProject.isExecutionRoot()) continue;
                    for (String path : projectClasspath) {
                        File pathFile = new File(path);
                        String[] children = pathFile.list();
                        if (pathFile.exists() && (children == null || children.length != 0)) continue;
                        this.getLog().warn((CharSequence)("The project " + localProject.getArtifactId() + " does not seem to be compiled. PMD results might be inaccurate."));
                    }
                }
                classpath.addAll(dependencies);
                this.getLog().debug((CharSequence)("Using aggregated aux classpath: " + classpath));
            } else {
                classpath.addAll(this.includeTests ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements());
                this.getLog().debug((CharSequence)("Using aux classpath: " + classpath));
            }
            String path = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
            return path;
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    public String getOutputName() {
        return "pmd";
    }

    @Deprecated
    public final Renderer createRenderer() throws MavenReportException {
        return PmdExecutor.createRenderer(this.format, this.getOutputEncoding());
    }
}

