/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.benchmark.TextTimingReportRenderer;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimingReport;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.pmd.ExcludeViolationsFromFile;
import org.apache.maven.plugins.pmd.PmdCollectingRenderer;
import org.apache.maven.plugins.pmd.exec.Executor;
import org.apache.maven.plugins.pmd.exec.PmdRequest;
import org.apache.maven.plugins.pmd.exec.PmdResult;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PmdExecutor
extends Executor {
    private static final Logger LOG = LoggerFactory.getLogger(PmdExecutor.class);
    private final PmdRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PmdResult execute(PmdRequest request) throws MavenReportException {
        if (request.getJavaExecutable() != null) {
            return PmdExecutor.fork(request);
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(PmdExecutor.class.getClassLoader());
            PmdExecutor executor = new PmdExecutor(request);
            PmdResult pmdResult = executor.run();
            return pmdResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private static PmdResult fork(PmdRequest request) throws MavenReportException {
        File basePmdDir = new File(request.getTargetDirectory(), "pmd");
        basePmdDir.mkdirs();
        File pmdRequestFile = new File(basePmdDir, "pmdrequest.bin");
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(pmdRequestFile));){
            out.writeObject(request);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        String classpath = PmdExecutor.buildClasspath();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.environment().put("CLASSPATH", classpath);
        pb.command().add(request.getJavaExecutable());
        pb.command().add(PmdExecutor.class.getName());
        pb.command().add(pmdRequestFile.getAbsolutePath());
        LOG.debug("Executing: CLASSPATH={}, command={}", (Object)classpath, pb.command());
        try {
            Process p = pb.start();
            Executor.ProcessStreamHandler.start(p.getInputStream(), System.out);
            Executor.ProcessStreamHandler.start(p.getErrorStream(), System.err);
            int exit = p.waitFor();
            LOG.debug("PmdExecutor exit code: {}", (Object)exit);
            if (exit != 0) {
                throw new MavenReportException("PmdExecutor exited with exit code " + exit);
            }
            return new PmdResult(new File(request.getTargetDirectory(), "pmd.xml"), request.getOutputEncoding());
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
    }

    public static void main(String[] args) {
        File requestFile = new File(args[0]);
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(requestFile));){
            PmdRequest request = (PmdRequest)in.readObject();
            PmdExecutor pmdExecutor = new PmdExecutor(request);
            pmdExecutor.setupLogLevel(request.getLogLevel());
            pmdExecutor.run();
            System.exit(0);
        }
        catch (IOException | ClassNotFoundException | MavenReportException e) {
            LOG.error(e.getMessage(), e);
        }
        System.exit(1);
    }

    public PmdExecutor(PmdRequest request) {
        this.request = Objects.requireNonNull(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PmdResult run() throws MavenReportException {
        this.setupPmdLogging(this.request.isShowPmdLog(), this.request.isColorizedLog(), this.request.getLogLevel());
        PMDConfiguration configuration = new PMDConfiguration();
        LanguageVersion languageVersion = null;
        Language language = LanguageRegistry.findLanguageByTerseName((String)(this.request.getLanguage() != null ? this.request.getLanguage() : "java"));
        if (language == null) {
            throw new MavenReportException("Unsupported language: " + this.request.getLanguage());
        }
        if (this.request.getLanguageVersion() != null) {
            languageVersion = language.getVersion(this.request.getLanguageVersion());
            if (languageVersion == null) {
                throw new MavenReportException("Unsupported targetJdk value '" + this.request.getLanguageVersion() + "'.");
            }
        } else {
            languageVersion = language.getDefaultVersion();
        }
        LOG.debug("Using language " + languageVersion);
        configuration.setDefaultLanguageVersion(languageVersion);
        try {
            configuration.prependClasspath(this.request.getAuxClasspath());
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        if (this.request.getSuppressMarker() != null) {
            configuration.setSuppressMarker(this.request.getSuppressMarker());
        }
        if (this.request.getAnalysisCacheLocation() != null) {
            configuration.setAnalysisCacheLocation(this.request.getAnalysisCacheLocation());
            LOG.debug("Using analysis cache location: " + this.request.getAnalysisCacheLocation());
        } else {
            configuration.setIgnoreIncrementalAnalysis(true);
        }
        configuration.setRuleSets(this.request.getRulesets());
        if (this.request.getBenchmarkOutputLocation() != null) {
            configuration.setBenchmark(true);
        }
        List<File> files = this.request.getFiles();
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>(files.size());
        for (File f : files) {
            dataSources.add((DataSource)new FileDataSource(f));
        }
        PmdCollectingRenderer renderer = new PmdCollectingRenderer();
        if (StringUtils.isBlank((CharSequence)this.request.getRulesets())) {
            LOG.debug("Skipping PMD execution as no rulesets are defined.");
        } else {
            if (this.request.getBenchmarkOutputLocation() != null) {
                TimeTracker.startGlobalTracking();
            }
            try {
                this.processFilesWithPMD(configuration, dataSources, renderer);
            }
            finally {
                ClassLoader classLoader;
                if (this.request.getAuxClasspath() != null && (classLoader = configuration.getClassLoader()) instanceof Closeable) {
                    IOUtils.closeQuietly((Closeable)((Closeable)((Object)classLoader)));
                }
                if (this.request.getBenchmarkOutputLocation() != null) {
                    TimingReport timingReport = TimeTracker.stopGlobalTracking();
                    this.writeBenchmarkReport(timingReport, this.request.getBenchmarkOutputLocation(), this.request.getOutputEncoding());
                }
            }
        }
        if (renderer.hasErrors()) {
            if (!this.request.isSkipPmdError()) {
                LOG.error("PMD processing errors:");
                LOG.error(renderer.getErrorsAsString(this.request.isDebugEnabled()));
                throw new MavenReportException("Found " + renderer.getErrors().size() + " PMD processing errors");
            }
            LOG.warn("There are {} PMD processing errors:", (Object)renderer.getErrors().size());
            LOG.warn(renderer.getErrorsAsString(this.request.isDebugEnabled()));
        }
        this.removeExcludedViolations(renderer.getViolations());
        Report report = renderer.asReport();
        this.writeXmlReport(report);
        String format = this.request.getFormat();
        if (!"html".equals(format) && !"xml".equals(format)) {
            this.writeFormattedReport(report);
        }
        return new PmdResult(new File(this.request.getTargetDirectory(), "pmd.xml"), this.request.getOutputEncoding());
    }

    private void writeBenchmarkReport(TimingReport timingReport, String benchmarkOutputLocation, String encoding) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(benchmarkOutputLocation), encoding);){
            TextTimingReportRenderer renderer = new TextTimingReportRenderer();
            renderer.render(timingReport, (Writer)writer);
        }
        catch (IOException e) {
            LOG.error("Unable to generate benchmark file: {}", (Object)benchmarkOutputLocation, (Object)e);
        }
    }

    private void processFilesWithPMD(PMDConfiguration pmdConfiguration, List<DataSource> dataSources, PmdCollectingRenderer renderer) throws MavenReportException {
        RuleSetFactory ruleSetFactory = RulesetsFactoryUtils.createFactory((RulePriority)RulePriority.valueOf((int)this.request.getMinimumPriority()), (boolean)true, (boolean)true);
        try {
            ruleSetFactory.createRuleSets(pmdConfiguration.getRuleSets());
        }
        catch (RuleSetNotFoundException e1) {
            throw new MavenReportException("The ruleset could not be loaded", (Exception)((Object)e1));
        }
        try {
            LOG.debug("Executing PMD...");
            RuleContext ruleContext = new RuleContext();
            PMD.processFiles((PMDConfiguration)pmdConfiguration, (RuleSetFactory)ruleSetFactory, dataSources, (RuleContext)ruleContext, Arrays.asList(new Renderer[]{renderer}));
            LOG.debug("PMD finished. Found {} violations.", (Object)renderer.getViolations().size());
        }
        catch (Exception e) {
            String message = "Failure executing PMD: " + e.getLocalizedMessage();
            if (!this.request.isSkipPmdError()) {
                throw new MavenReportException(message, e);
            }
            LOG.warn(message, (Throwable)e);
        }
    }

    private void writeXmlReport(Report report) throws MavenReportException {
        File targetFile = this.writeReport(report, (Renderer)new XMLRenderer(this.request.getOutputEncoding()), "xml");
        if (this.request.isIncludeXmlInSite()) {
            File siteDir = new File(this.request.getReportOutputDirectory());
            siteDir.mkdirs();
            try {
                FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "pmd.xml"));
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
        }
    }

    private File writeReport(Report report, Renderer r, String extension) throws MavenReportException {
        if (r == null) {
            return null;
        }
        File targetDir = new File(this.request.getTargetDirectory());
        targetDir.mkdirs();
        File targetFile = new File(targetDir, "pmd." + extension);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.request.getOutputEncoding());){
            r.setWriter((Writer)writer);
            r.start();
            r.renderFileReport(report);
            r.end();
            r.flush();
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
        return targetFile;
    }

    private void writeFormattedReport(Report report) throws MavenReportException {
        Renderer renderer = PmdExecutor.createRenderer(this.request.getFormat(), this.request.getOutputEncoding());
        this.writeReport(report, renderer, this.request.getFormat());
    }

    public static Renderer createRenderer(String format, String outputEncoding) throws MavenReportException {
        XMLRenderer result = null;
        if ("xml".equals(format)) {
            result = new XMLRenderer(outputEncoding);
        } else if ("txt".equals(format)) {
            result = new TextRenderer();
        } else if ("csv".equals(format)) {
            result = new CSVRenderer();
        } else if ("html".equals(format)) {
            result = new HTMLRenderer();
        } else if (!"".equals(format) && !"none".equals(format)) {
            try {
                result = (Renderer)Class.forName(format).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find PMD custom format " + format + ": " + e.getClass().getName(), e);
            }
        }
        return result;
    }

    private void removeExcludedViolations(List<RuleViolation> violations) throws MavenReportException {
        ExcludeViolationsFromFile excludeFromFile = new ExcludeViolationsFromFile();
        try {
            excludeFromFile.loadExcludeFromFailuresData(this.request.getExcludeFromFailureFile());
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Unable to load exclusions", (Exception)((Object)e));
        }
        LOG.debug("Removing excluded violations. Using {} configured exclusions.", (Object)excludeFromFile.countExclusions());
        int violationsBefore = violations.size();
        Iterator<RuleViolation> iterator = violations.iterator();
        while (iterator.hasNext()) {
            RuleViolation rv = iterator.next();
            if (!excludeFromFile.isExcludedFromFailure(rv)) continue;
            iterator.remove();
        }
        int numberOfExcludedViolations = violationsBefore - violations.size();
        LOG.debug("Excluded {} violations.", (Object)numberOfExcludedViolations);
    }
}

