/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-plugin-plugin:2.7", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Plugin Plugin", 0);
        this.append(sb, "The Plugin Plugin is used to create a Maven plugin descriptor for any Mojo's found in the source tree, to include in the JAR. It is also used to generate Xdoc files for the Mojos as well as for updating the plugin registry, the artifact metadata and a generic help goal.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 7 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "addPluginArtifactMetadata".equals(this.goal)) {
            this.append(sb, "plugin:addPluginArtifactMetadata", 0);
            this.append(sb, "Inject any plugin-specific artifact metadata to the project's artifact, for subsequent installation and deployment. The first use-case for this is to add the LATEST metadata (which is plugin-specific) for shipping alongside the plugin's artifact.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "goalPrefix", 2);
                this.append(sb, "The prefix for the plugin goal.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "descriptor".equals(this.goal)) {
            this.append(sb, "plugin:descriptor", 0);
            this.append(sb, "Generate a plugin descriptor.\nNote: Phase is after the 'compilation' of any scripts.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding of the source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extractors", 2);
                this.append(sb, "The role names of mojo extractors to use.\n>If not set, all mojo extractors will be used. If set to an empty extractor name, no mojo extractors will be used.\n\n>Example:\n\n>\n\n\u00a0<!--\u00a0Use\u00a0all\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors/>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0no\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor/>\n\u00a0</extractors>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0only\u00a0bsh\u00a0mojo\u00a0extractor\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor>bsh</extractor>\n\u00a0</extractors>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "goalPrefix", 2);
                this.append(sb, "The goal prefix that will appear before the ':'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory}/META-INF/maven)", 2);
                this.append(sb, "The directory where the generated plugin.xml file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipDescriptor (Default: false)", 2);
                this.append(sb, "A flag to disable generation of the plugin.xml in favor of a hand authored plugin descriptor.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "plugin:help", 0);
            this.append(sb, "Display help information on maven-plugin-plugin.\nCall\n\u00a0\u00a0mvn\u00a0plugin:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "helpmojo".equals(this.goal)) {
            this.append(sb, "plugin:helpmojo", 0);
            this.append(sb, "Generates a HelpMojo class.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding of the source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extractors", 2);
                this.append(sb, "The role names of mojo extractors to use.\n>If not set, all mojo extractors will be used. If set to an empty extractor name, no mojo extractors will be used.\n\n>Example:\n\n>\n\n\u00a0<!--\u00a0Use\u00a0all\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors/>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0no\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor/>\n\u00a0</extractors>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0only\u00a0bsh\u00a0mojo\u00a0extractor\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor>bsh</extractor>\n\u00a0</extractors>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "goalPrefix", 2);
                this.append(sb, "The goal prefix that will appear before the ':'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "helpPackageName", 2);
                this.append(sb, "The name of the package for the generated HelpMojo. By default, the package will be calculated based on the packages of the other plugin goals.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/plugin)", 2);
                this.append(sb, "The directory where the generated HelpMojo file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "plugin:report", 0);
            this.append(sb, "Generates the Plugin's documentation report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding of the source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goalPrefix", 2);
                this.append(sb, "The goal prefix that will appear before the ':'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2);
                this.append(sb, "Report output directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "requirements", 2);
                this.append(sb, "Specify some requirements to execute this plugin. Example:\n<requirements>\n\u00a0\u00a0<maven>2.0</maven>\n\u00a0\u00a0<jdk>1.4</jdk>\n\u00a0\u00a0<memory>256m</memory>\n\u00a0\u00a0<diskSpace>1m</diskSpace>\n\u00a0\u00a0<others>\n\u00a0\u00a0\u00a0\u00a0<property>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<name>SVN</name>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<value>1.4.6</value>\n\u00a0\u00a0\u00a0\u00a0</property>\n\u00a0\u00a0</others>\n</requirements>\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "updateRegistry".equals(this.goal)) {
            this.append(sb, "plugin:updateRegistry", 0);
            this.append(sb, "Update the user plugin registry (if it's in use) to reflect the version we're installing.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xdoc".equals(this.goal)) {
            this.append(sb, "plugin:xdoc", 0);
            this.append(sb, "Generate Xdoc files for the project mojos or goals.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding of the source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extractors", 2);
                this.append(sb, "The role names of mojo extractors to use.\n>If not set, all mojo extractors will be used. If set to an empty extractor name, no mojo extractors will be used.\n\n>Example:\n\n>\n\n\u00a0<!--\u00a0Use\u00a0all\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors/>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0no\u00a0mojo\u00a0extractors\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor/>\n\u00a0</extractors>\n\u00a0\n\u00a0<!--\u00a0Use\u00a0only\u00a0bsh\u00a0mojo\u00a0extractor\u00a0-->\n\u00a0<extractors>\n\u00a0\u00a0\u00a0\u00a0\u00a0<extractor>bsh</extractor>\n\u00a0</extractors>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "goalPrefix", 2);
                this.append(sb, "The goal prefix that will appear before the ':'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-site/xdoc)", 2);
                this.append(sb, "The directory where the generated Xdoc files will be put.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

