/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.metadata;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;

public class AddPluginArtifactMetadataMojo
extends AbstractMojo {
    private MavenProject project;
    private String goalPrefix;

    public void execute() throws MojoExecutionException {
        Artifact projectArtifact = this.project.getArtifact();
        Versioning versioning = new Versioning();
        versioning.setLatest(projectArtifact.getVersion());
        versioning.updateTimestamp();
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(projectArtifact, versioning);
        projectArtifact.addMetadata((ArtifactMetadata)metadata);
        GroupRepositoryMetadata groupMetadata = new GroupRepositoryMetadata(this.project.getGroupId());
        groupMetadata.addPluginMapping(this.getGoalPrefix(), this.project.getArtifactId(), this.project.getName());
        projectArtifact.addMetadata((ArtifactMetadata)groupMetadata);
    }

    private String getGoalPrefix() {
        if (this.goalPrefix == null) {
            this.goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        }
        return this.goalPrefix;
    }
}

