/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.linkcheck;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFile;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFileResult;
import org.apache.maven.doxia.linkcheck.model.LinkcheckModel;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class LinkcheckReportGenerator {
    private final I18N i18n;
    private String httpMethod;
    private boolean offline;
    private String[] excludedLinks;
    private Integer[] excludedHttpStatusErrors;
    private Integer[] excludedHttpStatusWarnings;
    private String[] excludedPages;
    private boolean httpFollowRedirect;

    public LinkcheckReportGenerator(I18N i18n) {
        this.i18n = i18n;
    }

    public void setExcludedHttpStatusErrors(Integer[] excludedHttpStatusErrors) {
        this.excludedHttpStatusErrors = excludedHttpStatusErrors;
    }

    public void setExcludedHttpStatusWarnings(Integer[] excludedHttpStatusWarnings) {
        this.excludedHttpStatusWarnings = excludedHttpStatusWarnings;
    }

    public void setExcludedLinks(String[] excludedLinks) {
        this.excludedLinks = excludedLinks;
    }

    public void setExcludedPages(String[] excludedPages) {
        this.excludedPages = excludedPages;
    }

    public void setHttpFollowRedirect(boolean httpFollowRedirect) {
        this.httpFollowRedirect = httpFollowRedirect;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void generateReport(Locale locale, LinkcheckModel linkcheckModel, Sink sink) {
        String name = this.i18n.getString("linkcheck-report", locale, "report.linkcheck.name");
        sink.head();
        sink.title();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.title"));
        sink.title_();
        sink.head_();
        sink.body();
        if (linkcheckModel == null) {
            sink.section1();
            sink.sectionTitle1();
            sink.text(name);
            sink.sectionTitle1_();
            sink.paragraph();
            sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.empty"));
            sink.paragraph_();
            sink.section1_();
            sink.body_();
            sink.flush();
            sink.close();
            return;
        }
        sink.section1();
        sink.sectionTitle1();
        sink.text(name);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.overview"));
        sink.paragraph_();
        sink.section1_();
        this.generateSummarySection(locale, linkcheckModel, sink);
        if (linkcheckModel.getFiles().size() > 0) {
            this.generateDetailsSection(locale, linkcheckModel, sink);
        }
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void generateSummarySection(Locale locale, LinkcheckModel linkcheckModel, Sink sink) {
        List linkcheckFiles = linkcheckModel.getFiles();
        int totalFiles = linkcheckFiles.size();
        int totalLinks = 0;
        int totalValidLinks = 0;
        int totalErrorLinks = 0;
        int totalWarningLinks = 0;
        Iterator it = linkcheckFiles.iterator();
        while (it.hasNext()) {
            LinkcheckFile linkcheckFile = (LinkcheckFile)it.next();
            totalLinks += linkcheckFile.getNumberOfLinks();
            totalValidLinks += linkcheckFile.getNumberOfLinks(3);
            totalErrorLinks += linkcheckFile.getNumberOfLinks(1);
            totalWarningLinks += linkcheckFile.getNumberOfLinks(2);
        }
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.overview1"));
        sink.paragraph_();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.parameter"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.value"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.httpFollowRedirect"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(String.valueOf(this.httpFollowRedirect));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.httpMethod"));
        sink.tableCell_();
        sink.tableCell();
        if (StringUtils.isEmpty((String)this.httpMethod)) {
            sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            sink.text(this.httpMethod);
        }
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.offline"));
        sink.tableCell_();
        sink.tableCell();
        sink.text(String.valueOf(this.offline));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedPages"));
        sink.tableCell_();
        sink.tableCell();
        if (this.excludedPages == null || this.excludedPages.length == 0) {
            sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            sink.text(StringUtils.join((Object[])this.excludedPages, (String)","));
        }
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedLinks"));
        sink.tableCell_();
        sink.tableCell();
        if (this.excludedLinks == null || this.excludedLinks.length == 0) {
            sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            sink.text(StringUtils.join((Object[])this.excludedLinks, (String)","));
        }
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedHttpStatusErrors"));
        sink.tableCell_();
        sink.tableCell();
        if (this.excludedHttpStatusErrors == null || this.excludedHttpStatusErrors.length == 0) {
            sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            sink.text(LinkcheckReportGenerator.toString(this.excludedHttpStatusErrors));
        }
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedHttpStatusWarnings"));
        sink.tableCell_();
        sink.tableCell();
        if (this.excludedHttpStatusWarnings == null || this.excludedHttpStatusWarnings.length == 0) {
            sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            sink.text(LinkcheckReportGenerator.toString(this.excludedHttpStatusWarnings));
        }
        sink.tableCell_();
        sink.tableRow_();
        sink.table_();
        sink.paragraph();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.overview2"));
        sink.paragraph_();
        sink.table();
        this.generateTableHeader(locale, false, sink);
        sink.tableRow();
        sink.tableCell();
        sink.bold();
        sink.text(totalFiles + "");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text(totalLinks + "");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text(String.valueOf(totalValidLinks));
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text(String.valueOf(totalWarningLinks));
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text(String.valueOf(totalErrorLinks));
        sink.bold_();
        sink.tableCell_();
        sink.tableRow_();
        sink.table_();
        sink.section1_();
    }

    private void generateDetailsSection(Locale locale, LinkcheckModel linkcheckModel, Sink sink) {
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.detail"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.detail.overview"));
        sink.paragraph_();
        sink.table();
        this.generateTableHeader(locale, true, sink);
        List linkcheckFiles = linkcheckModel.getFiles();
        Iterator it = linkcheckFiles.iterator();
        while (it.hasNext()) {
            LinkcheckFile linkcheckFile = (LinkcheckFile)it.next();
            sink.tableRow();
            sink.tableCell();
            if (linkcheckFile.getUnsuccessful() == 0) {
                this.iconValid(locale, sink);
            } else {
                this.iconError(locale, sink);
            }
            sink.tableCell_();
            sink.tableCell();
            sink.link(linkcheckFile.getRelativePath());
            sink.text(linkcheckFile.getRelativePath());
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(linkcheckFile.getNumberOfLinks()));
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(linkcheckFile.getNumberOfLinks(3)));
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(linkcheckFile.getNumberOfLinks(2)));
            sink.tableCell_();
            sink.tableCell();
            sink.text(String.valueOf(linkcheckFile.getNumberOfLinks(1)));
            sink.tableCell_();
            sink.tableRow_();
            if (linkcheckFile.getUnsuccessful() == 0) continue;
            sink.tableRow();
            sink.tableCell();
            sink.text("");
            sink.tableCell_();
            sink.rawText("<td colspan=\"5\">");
            sink.table();
            Iterator it2 = linkcheckFile.getResults().iterator();
            while (it2.hasNext()) {
                LinkcheckFileResult linkcheckFileResult = (LinkcheckFileResult)it2.next();
                if (linkcheckFileResult.getStatusLevel() == 3) continue;
                sink.tableRow();
                sink.tableCell();
                if (linkcheckFileResult.getStatusLevel() == 2) {
                    this.iconWarning(locale, sink);
                } else if (linkcheckFileResult.getStatusLevel() == 1) {
                    this.iconError(locale, sink);
                }
                sink.tableCell_();
                sink.tableCell();
                sink.italic();
                if (linkcheckFileResult.getTarget().startsWith("#")) {
                    sink.link(linkcheckFile.getRelativePath() + linkcheckFileResult.getTarget());
                } else if (linkcheckFileResult.getTarget().startsWith(".")) {
                    String absolutePath = FilenameUtils.getFullPath((String)linkcheckFile.getRelativePath()) + linkcheckFileResult.getTarget();
                    String normalizedPath = FilenameUtils.normalize((String)absolutePath);
                    if (normalizedPath == null) {
                        normalizedPath = absolutePath;
                    }
                    sink.link(normalizedPath);
                } else {
                    sink.link(linkcheckFileResult.getTarget());
                }
                sink.text(linkcheckFileResult.getTarget());
                sink.link_();
                sink.text(": ");
                sink.text(linkcheckFileResult.getErrorMessage());
                sink.italic_();
                sink.tableCell_();
                sink.tableRow_();
            }
            sink.table_();
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.section1_();
    }

    private void generateTableHeader(Locale locale, boolean detail, Sink sink) {
        sink.tableRow();
        if (detail) {
            sink.rawText("<th rowspan=\"2\">");
            sink.text("");
            sink.tableHeaderCell_();
        }
        sink.rawText("<th rowspan=\"2\">");
        sink.text(detail ? this.i18n.getString("linkcheck-report", locale, "report.linkcheck.detail.table.documents") : this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.documents"));
        sink.tableHeaderCell_();
        sink.rawText("<th colspan=\"4\" align=\"center\">");
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.table.links"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.table.totalLinks"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        this.iconValid(locale, sink);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        this.iconWarning(locale, sink);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        this.iconError(locale, sink);
        sink.tableHeaderCell_();
        sink.tableRow_();
    }

    private void iconError(Locale locale, Sink sink) {
        sink.figure();
        sink.figureCaption();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.icon.error"));
        sink.figureCaption_();
        sink.figureGraphics("images/icon_error_sml.gif");
        sink.figure_();
    }

    private void iconValid(Locale locale, Sink sink) {
        sink.figure();
        sink.figureCaption();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.icon.valid"));
        sink.figureCaption_();
        sink.figureGraphics("images/icon_success_sml.gif");
        sink.figure_();
    }

    private void iconWarning(Locale locale, Sink sink) {
        sink.figure();
        sink.figureCaption();
        sink.text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.icon.warning"));
        sink.figureCaption_();
        sink.figureGraphics("images/icon_warning_sml.gif");
        sink.figure_();
    }

    private static String toString(Object[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        return buf.toString();
    }
}

