/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.jxr.AbstractJxrReport;
import org.apache.maven.project.MavenProject;

public class JxrReport
extends AbstractJxrReport {
    private List sourceDirs;
    private String sourcePath;
    private String destDir;
    private File javadocDir;

    protected String getDestinationDirectory() {
        return this.destDir;
    }

    protected List getSourceRoots() {
        String[] sourcePathArray;
        if (this.sourcePath != null && (sourcePathArray = this.sourcePath.split(";")).length > 0) {
            return Arrays.asList(sourcePathArray);
        }
        ArrayList l = new ArrayList();
        if (!"pom".equals(this.getProject().getPackaging().toLowerCase())) {
            l.addAll(this.sourceDirs);
        }
        if (this.getProject().getExecutionProject() != null && !"pom".equals(this.getProject().getExecutionProject().getPackaging().toLowerCase())) {
            l.addAll(this.getProject().getExecutionProject().getCompileSourceRoots());
        }
        return l;
    }

    protected List getSourceRoots(MavenProject project) {
        ArrayList l = new ArrayList();
        if (!"pom".equals(project.getPackaging().toLowerCase())) {
            l.addAll(project.getCompileSourceRoots());
        }
        if (project.getExecutionProject() != null && !"pom".equals(project.getExecutionProject().getPackaging().toLowerCase())) {
            l.addAll(project.getExecutionProject().getCompileSourceRoots());
        }
        return l;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.name");
    }

    public String getOutputName() {
        return "xref/index";
    }

    protected File getJavadocDir() {
        return this.javadocDir;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.destDir = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("xref") ? new File(reportOutputDirectory, "xref").getAbsolutePath() : reportOutputDirectory.getAbsolutePath();
    }
}

