package org.apache.maven.plugins.jarsigner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-jarsigner-plugin.<br/> Call <pre>  mvn jarsigner:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sat Sep 26 17:34:44 CEST 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-jarsigner-plugin:1.2", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Jarsigner Plugin", 0 );
        append( sb, "Signs or verifies a project artifact and attachments using jarsigner.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jarsigner:help", 0 );
            append( sb, "Display help information on maven-jarsigner-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jarsigner:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "sign".equals( goal ) )
        {
            append( sb, "jarsigner:sign", 0 );
            append( sb, "Signs a project artifact and attachments using jarsigner.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "alias", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "Archive to process. If set, neither the project artifact nor any attachments or archive sets are processed.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveDirectory", 2 );
                append( sb, "The base directory to scan for JAR files using Ant-like inclusion/exclusion patterns.", 3 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "List of additional arguments to append to the jarsigner command line.", 3 );
                append( sb, "", 0 );

                append( sb, "attachments", 2 );
                append( sb, "Deprecated. As of version 1.1 in favor of the new parameter processAttachedArtifacts.", 3 );
                append( sb, "", 0 );
                append( sb, "Controls processing of project attachments.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "A set of artifact classifiers describing the project attachments that should not be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, no attachments are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "The Ant-like exclusion patterns used to exclude JAR files from processing. The patterns must be relative to the directory given by the parameter archiveDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "A set of artifact classifiers describing the project attachments that should be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, all attachments are included.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "The Ant-like inclusion patterns used to select JAR files to process. The patterns must be relative to the directory given by the parameter archiveDirectory. By default, the pattern **/*.?ar is used.", 3 );
                append( sb, "", 0 );

                append( sb, "keypass", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "keystore", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "maxMemory", 2 );
                append( sb, "The maximum memory available to the JAR signer, e.g. 256M. See -Xmx for more details.", 3 );
                append( sb, "", 0 );

                append( sb, "processAttachedArtifacts (Default: true)", 2 );
                append( sb, "Controls processing of project attachments. If enabled, attached artifacts that are no JAR/ZIP files will be automatically excluded from processing.", 3 );
                append( sb, "", 0 );

                append( sb, "processMainArtifact (Default: true)", 2 );
                append( sb, "Controls processing of the main artifact produced by the project.", 3 );
                append( sb, "", 0 );

                append( sb, "providerArg", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "providerClass", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "providerName", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "removeExistingSignatures (Default: false)", 2 );
                append( sb, "Indicates whether existing signatures should be removed from the processed JAR files prior to signing them. If enabled, the resulting JAR will appear as being signed only once.", 3 );
                append( sb, "", 0 );

                append( sb, "sigfile", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set to true to disable the plugin.", 3 );
                append( sb, "", 0 );

                append( sb, "storepass", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "storetype", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "verify".equals( goal ) )
        {
            append( sb, "jarsigner:verify", 0 );
            append( sb, "Checks the signatures of a project artifact and attachments using jarsigner.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "Archive to process. If set, neither the project artifact nor any attachments or archive sets are processed.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveDirectory", 2 );
                append( sb, "The base directory to scan for JAR files using Ant-like inclusion/exclusion patterns.", 3 );
                append( sb, "", 0 );

                append( sb, "arguments", 2 );
                append( sb, "List of additional arguments to append to the jarsigner command line.", 3 );
                append( sb, "", 0 );

                append( sb, "attachments", 2 );
                append( sb, "Deprecated. As of version 1.1 in favor of the new parameter processAttachedArtifacts.", 3 );
                append( sb, "", 0 );
                append( sb, "Controls processing of project attachments.", 3 );
                append( sb, "", 0 );

                append( sb, "certs (Default: false)", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "A set of artifact classifiers describing the project attachments that should not be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, no attachments are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "The Ant-like exclusion patterns used to exclude JAR files from processing. The patterns must be relative to the directory given by the parameter archiveDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "A set of artifact classifiers describing the project attachments that should be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, all attachments are included.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "The Ant-like inclusion patterns used to select JAR files to process. The patterns must be relative to the directory given by the parameter archiveDirectory. By default, the pattern **/*.?ar is used.", 3 );
                append( sb, "", 0 );

                append( sb, "maxMemory", 2 );
                append( sb, "The maximum memory available to the JAR signer, e.g. 256M. See -Xmx for more details.", 3 );
                append( sb, "", 0 );

                append( sb, "processAttachedArtifacts (Default: true)", 2 );
                append( sb, "Controls processing of project attachments. If enabled, attached artifacts that are no JAR/ZIP files will be automatically excluded from processing.", 3 );
                append( sb, "", 0 );

                append( sb, "processMainArtifact (Default: true)", 2 );
                append( sb, "Controls processing of the main artifact produced by the project.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set to true to disable the plugin.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "See options.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
