/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.idea;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.idea.AbstractIdeaMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class IdeaProjectMojo
extends AbstractIdeaMojo {
    private String jdkName;
    private String jdkLevel;
    private String wildcardResourcePatterns;
    private String ideaVersion;
    private Set macros;

    public void initParam(MavenProject project, ArtifactFactory artifactFactory, ArtifactRepository localRepo, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, Log log, boolean overwrite, String jdkName, String jdkLevel, String wildcardResourcePatterns, String ideaVersion, Set macros) {
        super.initParam(project, artifactFactory, localRepo, artifactResolver, artifactMetadataSource, log, overwrite);
        this.jdkName = jdkName;
        this.jdkLevel = jdkLevel;
        this.wildcardResourcePatterns = wildcardResourcePatterns;
        this.ideaVersion = ideaVersion;
        this.macros = macros;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.rewriteProject();
    }

    public void rewriteProject() throws MojoExecutionException {
        File projectFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".ipr");
        try {
            Element m;
            Document document = this.readXmlDocument(projectFile, "project.xml");
            Element module = document.getRootElement();
            if (this.jdkName != null) {
                this.setJdkName(module, this.jdkName);
            } else {
                String javaVersion = System.getProperty("java.version");
                String defaultJdkName = this.ideaVersion.startsWith("4") ? "java version &quot;" + javaVersion + "&quot;" : javaVersion.substring(0, 3);
                this.getLog().info((CharSequence)("jdkName is not set, using [java version" + javaVersion + "] as default."));
                this.setJdkName(module, defaultJdkName);
            }
            this.setWildcardResourcePatterns(module, this.wildcardResourcePatterns);
            Element component = this.findComponent(module, "ProjectModuleManager");
            Element modules = this.findElement(component, "modules");
            this.removeOldElements(modules, "module");
            if (this.executedProject.getCollectedProjects().size() > 0) {
                m = this.createElement(modules, "module");
                String projectPath = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iml").getAbsolutePath();
                m.addAttribute("filepath", "$PROJECT_DIR$/" + this.toRelative(this.executedProject.getBasedir().getAbsolutePath(), projectPath));
                Iterator i = this.executedProject.getCollectedProjects().iterator();
                while (i.hasNext()) {
                    MavenProject p = (MavenProject)i.next();
                    m = this.createElement(modules, "module");
                    String modulePath = new File(p.getBasedir(), p.getArtifactId() + ".iml").getAbsolutePath();
                    m.addAttribute("filepath", "$PROJECT_DIR$/" + this.toRelative(this.executedProject.getBasedir().getAbsolutePath(), modulePath));
                }
            } else {
                m = this.createElement(modules, "module");
                String modulePath = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iml").getAbsolutePath();
                m.addAttribute("filepath", "$PROJECT_DIR$/" + this.toRelative(this.executedProject.getBasedir().getAbsolutePath(), modulePath));
            }
            if (this.macros != null && module.elements("UsedPathMacros").size() > 0) {
                Element usedPathMacros = (Element)module.elements("UsedPathMacros").get(0);
                this.removeOldElements(usedPathMacros, "macro");
                Iterator iterator = this.macros.iterator();
                while (iterator.hasNext()) {
                    String macro = (String)iterator.next();
                    Element macroElement = this.createElement(usedPathMacros, "macro");
                    macroElement.addAttribute("name", macro);
                }
            }
            this.writeXmlDocument(projectFile, document);
        }
        catch (DocumentException e) {
            throw new MojoExecutionException("Error parsing existing IPR file: " + projectFile.getAbsolutePath(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error parsing existing IPR file: " + projectFile.getAbsolutePath(), (Exception)e);
        }
    }

    private void setJdkName(Element content, String jdkName) {
        Element component = this.findComponent(content, "ProjectRootManager");
        component.addAttribute("project-jdk-name", jdkName);
        String jdkLevel = this.jdkLevel;
        if (jdkLevel == null) {
            jdkLevel = System.getProperty("java.specification.version");
        }
        if (jdkLevel.startsWith("1.4")) {
            component.addAttribute("assert-keyword", "true");
            component.addAttribute("jdk-15", "false");
        } else if (jdkLevel.compareTo("1.5") >= 0) {
            component.addAttribute("assert-keyword", "true");
            component.addAttribute("jdk-15", "true");
        } else {
            component.addAttribute("assert-keyword", "false");
        }
    }

    private void setWildcardResourcePatterns(Element content, String wildcardResourcePatterns) {
        Element compilerConfigurationElement = this.findComponent(content, "CompilerConfiguration");
        if (!StringUtils.isEmpty((String)wildcardResourcePatterns)) {
            this.removeOldElements(compilerConfigurationElement, "wildcardResourcePatterns");
            Element wildcardResourcePatternsElement = this.createElement(compilerConfigurationElement, "wildcardResourcePatterns");
            StringTokenizer wildcardResourcePatternsTokenizer = new StringTokenizer(wildcardResourcePatterns, ";");
            while (wildcardResourcePatternsTokenizer.hasMoreTokens()) {
                String wildcardResourcePattern = wildcardResourcePatternsTokenizer.nextToken();
                Element entryElement = this.createElement(wildcardResourcePatternsElement, "entry");
                entryElement.addAttribute("name", wildcardResourcePattern);
            }
        }
    }
}

