/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.profiles.DefaultMavenProfilesBuilder;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.ProfilesConversionUtils;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="all-profiles", requiresProject=false)
public class AllProfilesMojo
extends AbstractHelpMojo {
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Component
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder descriptionBuffer = new StringBuilder();
        for (MavenProject project : this.projects) {
            descriptionBuffer.append("Listing Profiles for Project: ").append(project.getId()).append("\n");
            DefaultProfileManager pm = new DefaultProfileManager(this.session.getContainer(), this.session.getExecutionProperties());
            try {
                this.loadProjectExternalProfiles((ProfileManager)pm, project.getBasedir());
            }
            catch (ProfileActivationException e) {
                throw new MojoExecutionException("Error obtaining external Profiles:" + e.getMessage(), (Exception)((Object)e));
            }
            this.loadSettingsProfiles((ProfileManager)pm, this.session.getSettings());
            this.loadProjectPomProfiles((ProfileManager)pm, project);
            if (null == pm.getExplicitlyActivatedIds() || pm.getExplicitlyActivatedIds().size() == 0) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)"No profiles detected!");
                continue;
            }
            Map allProfilesByIds = pm.getProfilesById();
            List activeProfiles = project.getActiveProfiles();
            for (org.apache.maven.model.Profile activeProfile : activeProfiles) {
                allProfilesByIds.remove(activeProfile.getId());
            }
            for (org.apache.maven.model.Profile p : activeProfiles) {
                descriptionBuffer.append("  Profile Id: ").append(p.getId());
                descriptionBuffer.append(" (Active: true , Source: ").append(p.getSource()).append(")\n");
            }
            for (org.apache.maven.model.Profile p : allProfilesByIds.values()) {
                descriptionBuffer.append("  Profile Id: ").append(p.getId());
                descriptionBuffer.append(" (Active: false , Source: ").append(p.getSource()).append(")\n");
            }
        }
        if (this.output != null) {
            try {
                AllProfilesMojo.writeFile(this.output, descriptionBuffer);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write profiles description to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Wrote descriptions to: " + this.output));
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)descriptionBuffer.toString());
        }
    }

    private void loadProjectExternalProfiles(ProfileManager profileManager, File projectDir) throws ProfileActivationException {
        if (projectDir == null) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Attempting to read profiles from external profiles.xml...");
        }
        try {
            DefaultMavenProfilesBuilder profilesBuilder = new DefaultMavenProfilesBuilder();
            ProfilesRoot root = profilesBuilder.buildProfiles(projectDir);
            if (root != null) {
                List profiles = root.getProfiles();
                for (Profile rawProfile : profiles) {
                    org.apache.maven.model.Profile converted = ProfilesConversionUtils.convertFromProfileXmlProfile((Profile)rawProfile);
                    profileManager.addProfile(converted);
                    profileManager.explicitlyActivate(converted.getId());
                }
            } else if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"ProfilesRoot was found to be NULL");
            }
        }
        catch (IOException e) {
            throw new ProfileActivationException("Cannot read profiles.xml resource from directory: " + projectDir, (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new ProfileActivationException("Cannot parse profiles.xml resource from directory: " + projectDir, (Throwable)e);
        }
    }

    private void loadProjectPomProfiles(ProfileManager profilesManager, MavenProject project) {
        if (project == null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"No pom.xml found to read Profiles from.");
            }
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Attempting to read profiles from pom.xml...");
        }
        List profiles = project.getModel().getProfiles();
        for (org.apache.maven.model.Profile profile : profiles) {
            profilesManager.addProfile(profile);
            profilesManager.explicitlyActivate(profile.getId());
        }
        for (MavenProject parent = project.getParent(); parent != null; parent = parent.getParent()) {
            List profiles2 = parent.getModel().getProfiles();
            for (org.apache.maven.model.Profile profile : profiles2) {
                profilesManager.addProfile(profile);
                profilesManager.explicitlyActivate(profile.getId());
            }
        }
    }

    private void loadSettingsProfiles(ProfileManager profileManager, Settings settings) {
        if (settings == null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"No settings.xml detected.");
            }
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Attempting to read profiles from settings.xml...");
        }
        List profiles = settings.getProfiles();
        for (org.apache.maven.settings.Profile rawProfile : profiles) {
            org.apache.maven.model.Profile profile = SettingsUtils.convertFromSettingsProfile((org.apache.maven.settings.Profile)rawProfile);
            profileManager.addProfile(profile);
            profileManager.explicitlyActivate(profile.getId());
        }
    }
}

