/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GpgSigner {
    public static final String SIGNATURE_EXTENSION = ".asc";
    private boolean useAgent;
    private boolean isInteractive = true;
    private String keyname;
    private String passphrase;
    private File outputDir;
    private File buildDir;
    private File baseDir;
    private File homeDir;

    public void setInteractive(boolean b) {
        this.isInteractive = b;
    }

    public void setUseAgent(boolean b) {
        this.useAgent = b;
    }

    public void setKeyName(String s) {
        this.keyname = s;
    }

    public void setPassPhrase(String s) {
        this.passphrase = s;
    }

    public void setOutputDirectory(File out) {
        this.outputDir = out;
    }

    public void setBuildDirectory(File out) {
        this.buildDir = out;
    }

    public void setBaseDirectory(File out) {
        this.baseDir = out;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDir = homeDirectory;
    }

    public File generateSignatureForArtifact(File file) throws MojoExecutionException {
        File parent;
        File signature = new File(file + SIGNATURE_EXTENSION);
        boolean isInBuildDir = false;
        if (this.buildDir != null && this.buildDir.equals(parent = signature.getParentFile())) {
            isInBuildDir = true;
        }
        if (!isInBuildDir && this.outputDir != null) {
            String fileDirectory = "";
            File signatureDirectory = signature;
            while ((signatureDirectory = signatureDirectory.getParentFile()) != null && !signatureDirectory.equals(this.baseDir)) {
                fileDirectory = signatureDirectory.getName() + File.separatorChar + fileDirectory;
            }
            signatureDirectory = new File(this.outputDir, fileDirectory);
            if (!signatureDirectory.exists()) {
                signatureDirectory.mkdirs();
            }
            signature = new File(signatureDirectory, file.getName() + SIGNATURE_EXTENSION);
        }
        if (signature.exists()) {
            signature.delete();
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable("gpg" + (Os.isFamily((String)"windows") ? ".exe" : ""));
        if (this.homeDir != null) {
            cmd.createArg().setValue("--homedir");
            cmd.createArg().setFile(this.homeDir);
        }
        if (this.useAgent) {
            cmd.createArg().setValue("--use-agent");
        } else {
            cmd.createArg().setValue("--no-use-agent");
        }
        ByteArrayInputStream in = null;
        if (null != this.passphrase) {
            cmd.createArg().setValue("--passphrase-fd");
            cmd.createArg().setValue("0");
            in = new ByteArrayInputStream(this.passphrase.getBytes());
        }
        if (null != this.keyname) {
            cmd.createArg().setValue("--local-user");
            cmd.createArg().setValue(this.keyname);
        }
        cmd.createArg().setValue("--armor");
        cmd.createArg().setValue("--detach-sign");
        if (!this.isInteractive) {
            cmd.createArg().setValue("--no-tty");
        }
        cmd.createArg().setValue("--output");
        cmd.createArg().setFile(signature);
        cmd.createArg().setFile(file);
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (InputStream)in, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)new DefaultConsumer());
            if (exitCode != 0) {
                throw new MojoExecutionException("Exit code: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute gpg command", (Exception)((Object)e));
        }
        return signature;
    }

    private MavenProject findReactorProject(MavenProject prj) {
        if (prj.getParent() != null && prj.getParent().getBasedir() != null && prj.getParent().getBasedir().exists()) {
            return this.findReactorProject(prj.getParent());
        }
        return prj;
    }

    public String getPassphrase(MavenProject project) throws IOException {
        String pass = null;
        if (project != null && (pass = project.getProperties().getProperty("gpg.passphrase")) == null) {
            MavenProject prj2 = this.findReactorProject(project);
            pass = prj2.getProperties().getProperty("gpg.passphrase");
        }
        if (pass == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (System.in.available() != 0) {
                System.in.read();
            }
            System.out.print("GPG Passphrase:  ");
            MaskingThread thread = new MaskingThread();
            thread.start();
            pass = in.readLine();
            thread.stopMasking();
        }
        if (project != null) {
            this.findReactorProject(project).getProperties().setProperty("gpg.passphrase", pass);
        }
        return pass;
    }

    class MaskingThread
    extends Thread {
        private volatile boolean stop;

        MaskingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = false;
                while (!this.stop) {
                    System.out.print("\b*");
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

