/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ejb;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class EjbMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/*Bean.class", "**/*CMP.class", "**/*Session.class", "**/package.html"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EJB_JAR_XML = "META-INF/ejb-jar.xml";
    private String basedir;
    private String outputDirectory;
    private String jarName;
    private String classifier;
    private String generateClient = Boolean.FALSE.toString();
    private List clientExcludes;
    private List clientIncludes;
    private MavenProject project;
    private JarArchiver jarArchiver;
    private String ejbVersion;
    private JarArchiver clientJarArchiver;
    private MavenProjectHelper projectHelper;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Building ejb " + this.jarName + " with ejbVersion " + this.ejbVersion));
        }
        File jarFile = EjbMojo.getEJBJarFile(this.basedir, this.jarName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        File deploymentDescriptor = new File(this.outputDirectory, EJB_JAR_XML);
        if (!this.ejbVersion.matches("\\A[2-3]\\.[0-9]\\z")) {
            throw new MojoExecutionException("ejbVersion is not valid: " + this.ejbVersion + ". Must be 2.x or 3.x (where x is a digit)");
        }
        if (this.ejbVersion.matches("\\A2\\.[0-9]\\z") && !deploymentDescriptor.exists()) {
            throw new MojoExecutionException("Error assembling EJB: META-INF/ejb-jar.xml is required for ejbVersion 2.x");
        }
        try {
            archiver.getArchiver().addDirectory(new File(this.outputDirectory), DEFAULT_INCLUDES, new String[]{EJB_JAR_XML, "**/package.html"});
            if (deploymentDescriptor.exists()) {
                archiver.getArchiver().addFile(deploymentDescriptor, EJB_JAR_XML);
            }
            archiver.createArchive(this.project, this.archive);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "ejb", this.classifier, jarFile);
        } else {
            this.project.getArtifact().setFile(jarFile);
        }
        if (new Boolean(this.generateClient).booleanValue()) {
            this.getLog().info((CharSequence)("Building ejb client " + this.jarName + "-client"));
            String[] excludes = DEFAULT_EXCLUDES;
            String[] includes = DEFAULT_INCLUDES;
            if (this.clientIncludes != null && !this.clientIncludes.isEmpty()) {
                includes = this.clientIncludes.toArray(EMPTY_STRING_ARRAY);
            }
            if (this.clientExcludes != null && !this.clientExcludes.isEmpty()) {
                excludes = this.clientExcludes.toArray(EMPTY_STRING_ARRAY);
            }
            File clientJarFile = new File(this.basedir, this.jarName + "-client.jar");
            MavenArchiver clientArchiver = new MavenArchiver();
            clientArchiver.setArchiver(this.clientJarArchiver);
            clientArchiver.setOutputFile(clientJarFile);
            try {
                clientArchiver.getArchiver().addDirectory(new File(this.outputDirectory), includes, excludes);
                clientArchiver.createArchive(this.project, this.archive);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (ManifestException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            this.projectHelper.attachArtifact(this.project, "ejb-client", "client", clientJarFile);
        }
    }

    private static File getEJBJarFile(String basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".jar");
    }
}

