/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import java.util.List;
import org.apache.maven.plugins.ear.EarPluginException;

class JbossConfiguration {
    static final String VERSION_3_2 = "3.2";
    static final String VERSION_4 = "4";
    static final String VERSION_4_2 = "4.2";
    static final String VERSION_5 = "5";
    static final String VERSION = "version";
    static final String SECURITY_DOMAIN = "security-domain";
    static final String UNAUHTHENTICTED_PRINCIPAL = "unauthenticated-principal";
    static final String JMX_NAME = "jmx-name";
    static final String LOADER_REPOSITORY = "loader-repository";
    static final String LOADER_REPOSITORY_CLASS_ATTRIBUTE = "loaderRepositoryClass";
    static final String LOADER_REPOSITORY_CONFIG = "loader-repository-config";
    static final String CONFIG_PARSER_CLASS_ATTRIBUTE = "configParserClass";
    static final String MODULE_ORDER = "module-order";
    static final String DATASOURCES = "data-sources";
    static final String DATASOURCE = "data-source";
    static final String LIBRARY_DIRECTORY = "library-directory";
    private final String version;
    private boolean jbossThreeDotTwo;
    private boolean jbossFour;
    private boolean jbossFourDotTwo;
    private boolean jbossFive;
    private final String securityDomain;
    private final String unauthenticatedPrincipal;
    private final String jmxName;
    private final String loaderRepository;
    private final String loaderRepositoryConfig;
    private final String loaderRepositoryClass;
    private final String configParserClass;
    private final String moduleOrder;
    private final List<String> dataSources;
    private final String libraryDirectory;

    JbossConfiguration(String version, String securityDomain, String unauthenticatedPrincipal, String jmxName, String loaderRepository, String moduleOrder, List<String> dataSources, String libraryDirectory, String loaderRepositoryConfig, String loaderRepositoryClass, String configParserClass) throws EarPluginException {
        if (version == null) {
            throw new EarPluginException("jboss version could not be null.");
        }
        this.version = version;
        if (version.equals(VERSION_3_2)) {
            this.jbossThreeDotTwo = true;
        } else if (version.equals(VERSION_4)) {
            this.jbossFour = true;
        } else if (version.equals(VERSION_4_2)) {
            this.jbossFourDotTwo = true;
        } else if (version.equals(VERSION_5)) {
            this.jbossFive = true;
        } else {
            throw new EarPluginException("Invalid JBoss configuration, version[" + version + "] is not supported.");
        }
        this.securityDomain = securityDomain;
        this.unauthenticatedPrincipal = unauthenticatedPrincipal;
        this.jmxName = jmxName;
        this.loaderRepository = loaderRepository;
        this.moduleOrder = moduleOrder;
        this.dataSources = dataSources;
        this.libraryDirectory = libraryDirectory;
        this.loaderRepositoryConfig = loaderRepositoryConfig;
        this.loaderRepositoryClass = loaderRepositoryClass;
        this.configParserClass = configParserClass;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isJbossThreeDotTwo() {
        return this.jbossThreeDotTwo;
    }

    public boolean isJbossFour() {
        return this.jbossFour;
    }

    public boolean isJbossFourOrHigher() {
        return this.jbossFour || this.jbossFourDotTwo || this.jbossFive;
    }

    public boolean isJbossFourDotTwo() {
        return this.jbossFourDotTwo;
    }

    public boolean isJbossFourDotTwoOrHigher() {
        return this.jbossFourDotTwo || this.jbossFive;
    }

    public boolean isJbossFive() {
        return this.jbossFive;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public String getLoaderRepository() {
        return this.loaderRepository;
    }

    public String getModuleOrder() {
        return this.moduleOrder;
    }

    public List<String> getDataSources() {
        return this.dataSources;
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public String getLoaderRepositoryConfig() {
        return this.loaderRepositoryConfig;
    }

    public String getLoaderRepositoryClass() {
        return this.loaderRepositoryClass;
    }

    public String getConfigParserClass() {
        return this.configParserClass;
    }
}

