/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.utils.DependencySilentLog;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractDependencyMojo
extends AbstractMojo {
    protected final MavenSession session;
    @Deprecated
    @Parameter(property="silent", defaultValue="false")
    private boolean silent;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean skipDuringIncrementalBuild;
    private final BuildContext buildContext;
    private final MavenProject project;

    protected AbstractDependencyMojo(MavenSession session, BuildContext buildContext, MavenProject project) {
        this.session = session;
        this.buildContext = buildContext;
        this.project = project;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isSkip() {
        if (this.skipDuringIncrementalBuild && this.buildContext.isIncremental()) {
            return true;
        }
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Deprecated
    protected final boolean isSilent() {
        return this.silent;
    }

    @Deprecated
    public void setSilent(boolean silent) {
        this.silent = silent;
        if (silent) {
            this.setLog(new DependencySilentLog());
        } else if (this.getLog() instanceof DependencySilentLog) {
            this.setLog((Log)new SystemStreamLog());
        }
    }
}

