/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.treeSerializers.DOTDependencyNodeVisitor;
import org.apache.maven.plugin.dependency.treeSerializers.GraphmlDependencyNodeVisitor;
import org.apache.maven.plugin.dependency.treeSerializers.TGFDependencyNodeVisitor;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.SerializingDependencyNodeVisitor;

@Mojo(name="tree", requiresDependencyResolution=ResolutionScope.TEST)
public class TreeMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(property="output")
    private File output;
    @Parameter(property="outputFile")
    private File outputFile;
    @Parameter(property="outputType", defaultValue="text")
    private String outputType;
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="tokens", defaultValue="standard")
    private String tokens;
    private String includes;
    @Parameter(property="excludes")
    private String excludes;
    private DependencyNode rootNode;
    @Parameter(property="appendOutput", defaultValue="false")
    private boolean appendOutput;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.output != null) {
            this.getLog().warn((CharSequence)"The parameter output is deprecated. Use outputFile instead.");
            this.outputFile = this.output;
        }
        ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
        try {
            this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph(this.project, artifactFilter);
            String dependencyTreeString = this.serializeDependencyTree(this.rootNode);
            if (this.outputFile != null) {
                DependencyUtil.write(dependencyTreeString, this.outputFile, this.appendOutput, this.getLog());
                this.getLog().info((CharSequence)("Wrote dependency tree to: " + this.outputFile));
            } else {
                DependencyUtil.log(dependencyTreeString, this.getLog());
            }
        }
        catch (DependencyGraphBuilderException exception) {
            throw new MojoExecutionException("Cannot build project dependency graph", (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Cannot serialise project dependency graph", (Exception)exception);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public DependencyNode getDependencyGraph() {
        return this.rootNode;
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter;
        if (this.scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + this.scope + "'"));
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    private String serializeDependencyTree(DependencyNode rootNode) {
        StringWriter writer = new StringWriter();
        DependencyNodeVisitor visitor = this.getSerializingDependencyNodeVisitor(writer);
        visitor = new BuildingDependencyNodeVisitor(visitor);
        DependencyNodeFilter filter = this.createDependencyNodeFilter();
        if (filter != null) {
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, filter);
            rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
            AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
            visitor = new FilteringDependencyNodeVisitor(visitor, (DependencyNodeFilter)secondPassFilter);
        }
        rootNode.accept(visitor);
        return writer.toString();
    }

    public DependencyNodeVisitor getSerializingDependencyNodeVisitor(Writer writer) {
        if ("graphml".equals(this.outputType)) {
            return new GraphmlDependencyNodeVisitor(writer);
        }
        if ("tgf".equals(this.outputType)) {
            return new TGFDependencyNodeVisitor(writer);
        }
        if ("dot".equals(this.outputType)) {
            return new DOTDependencyNodeVisitor(writer);
        }
        return new SerializingDependencyNodeVisitor(writer, this.toTreeTokens(this.tokens));
    }

    private SerializingDependencyNodeVisitor.TreeTokens toTreeTokens(String tokens) {
        SerializingDependencyNodeVisitor.TreeTokens treeTokens;
        if ("whitespace".equals(tokens)) {
            this.getLog().debug((CharSequence)"+ Using whitespace tree tokens");
            treeTokens = SerializingDependencyNodeVisitor.WHITESPACE_TOKENS;
        } else if ("extended".equals(tokens)) {
            this.getLog().debug((CharSequence)"+ Using extended tree tokens");
            treeTokens = SerializingDependencyNodeVisitor.EXTENDED_TOKENS;
        } else {
            treeTokens = SerializingDependencyNodeVisitor.STANDARD_TOKENS;
        }
        return treeTokens;
    }

    private DependencyNodeFilter createDependencyNodeFilter() {
        StrictPatternIncludesArtifactFilter artifactFilter;
        List<String> patterns;
        ArrayList<ArtifactDependencyNodeFilter> filters = new ArrayList<ArtifactDependencyNodeFilter>();
        if (this.includes != null) {
            patterns = Arrays.asList(this.includes.split(","));
            this.getLog().debug((CharSequence)("+ Filtering dependency tree by artifact include patterns: " + patterns));
            artifactFilter = new StrictPatternIncludesArtifactFilter(patterns);
            filters.add(new ArtifactDependencyNodeFilter((ArtifactFilter)artifactFilter));
        }
        if (this.excludes != null) {
            patterns = Arrays.asList(this.excludes.split(","));
            this.getLog().debug((CharSequence)("+ Filtering dependency tree by artifact exclude patterns: " + patterns));
            artifactFilter = new StrictPatternExcludesArtifactFilter(patterns);
            filters.add(new ArtifactDependencyNodeFilter((ArtifactFilter)artifactFilter));
        }
        return filters.isEmpty() ? null : new AndDependencyNodeFilter(filters);
    }

    public static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            List restrictions = allowedRange.getRestrictions();
            for (Restriction restriction : restrictions) {
                if (!restriction.containsVersion(theVersion)) continue;
                return true;
            }
        }
        return recommendedVersion.compareTo((Object)theVersion) <= 0;
    }
}

