/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractDependencyFilterMojo;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildClasspathMojo
extends AbstractDependencyFilterMojo
implements Comparator<Artifact> {
    private boolean stripVersion = false;
    private String prefix;
    private File cpFile;
    private File outputFile;
    private boolean regenerateFile;
    private String fileSeparator;
    private String pathSeparator;
    private String localRepoProperty;
    boolean attach;
    boolean outputFilterFile;
    private MavenProjectHelper projectHelper;
    boolean isFileSepSet = true;
    boolean isPathSepSet = true;

    public void execute() throws MojoExecutionException {
        Set<Artifact> artifacts;
        if (this.cpFile != null) {
            this.getLog().warn((CharSequence)"The parameter cpFile is deprecated. Use outputFile instead.");
            this.outputFile = this.cpFile;
        }
        this.isFileSepSet = StringUtils.isNotEmpty((String)this.fileSeparator);
        this.isPathSepSet = StringUtils.isNotEmpty((String)this.pathSeparator);
        if (this.attach && StringUtils.isEmpty((String)this.localRepoProperty)) {
            this.localRepoProperty = "${M2_REPO}";
        }
        if ((artifacts = this.getResolvedDependencies(true)) == null || artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"No dependencies found.");
        }
        ArrayList<Artifact> artList = new ArrayList<Artifact>(artifacts);
        StringBuffer sb = new StringBuffer();
        Iterator i = artList.iterator();
        if (i.hasNext()) {
            this.appendArtifactPath((Artifact)i.next(), sb);
            while (i.hasNext()) {
                sb.append(this.isPathSepSet ? this.pathSeparator : File.pathSeparator);
                this.appendArtifactPath((Artifact)i.next(), sb);
            }
        }
        String cpString = sb.toString();
        if (this.isFileSepSet) {
            String pattern = Pattern.quote(File.separator);
            String replacement = Matcher.quoteReplacement(this.fileSeparator);
            cpString = cpString.replaceAll(pattern, replacement);
        }
        if (this.outputFilterFile) {
            cpString = "classpath=" + cpString;
        }
        if (this.outputFile == null) {
            this.getLog().info((CharSequence)("Dependencies classpath:\n" + cpString));
        } else if (this.regenerateFile || !this.isUpdToDate(cpString)) {
            this.storeClasspathFile(cpString, this.outputFile);
        } else {
            this.getLog().info((CharSequence)("Skipped writing classpath file '" + this.outputFile + "'.  No changes found."));
        }
        if (this.attach) {
            this.attachFile(cpString);
        }
    }

    protected void attachFile(String cpString) throws MojoExecutionException {
        File attachedFile = new File(this.project.getBuild().getDirectory(), "classpath");
        this.storeClasspathFile(cpString, attachedFile);
        this.projectHelper.attachArtifact(this.project, attachedFile, "classpath");
    }

    protected void appendArtifactPath(Artifact art, StringBuffer sb) {
        if (this.prefix == null) {
            String file = art.getFile().getPath();
            if (StringUtils.isNotEmpty((String)this.localRepoProperty)) {
                file = StringUtils.replace((String)file, (String)this.getLocal().getBasedir(), (String)this.localRepoProperty);
            }
            sb.append(file);
        } else {
            sb.append(this.prefix);
            sb.append(File.separator);
            sb.append(DependencyUtil.getFormattedFileName(art, this.stripVersion, this.prependGroupId));
        }
    }

    private boolean isUpdToDate(String cpString) {
        try {
            String oldCp = this.readClasspathFile();
            return cpString == oldCp || cpString != null && cpString.equals(oldCp);
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)("Error while reading old classpath file '" + this.outputFile + "' for up-to-date check: " + ex));
            return false;
        }
    }

    private void storeClasspathFile(String cpString, File out) throws MojoExecutionException {
        out.getParentFile().mkdirs();
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(out));
            w.write(cpString);
            this.getLog().info((CharSequence)("Wrote classpath file '" + out + "'."));
        }
        catch (IOException ex) {
            try {
                throw new MojoExecutionException("Error while writting to classpath file '" + out + "': " + ex.toString(), (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(w);
                throw throwable;
            }
        }
        IOUtil.close((Writer)w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readClasspathFile() throws IOException {
        String string;
        if (this.outputFile == null) {
            throw new IllegalArgumentException("The outputFile parameter cannot be null if the file is intended to be read.");
        }
        if (!this.outputFile.isFile()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader r = null;
        try {
            String l;
            r = new BufferedReader(new FileReader(this.outputFile));
            while ((l = r.readLine()) != null) {
                sb.append(l);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtil.close(r);
            throw throwable;
        }
        IOUtil.close((Reader)r);
        return string;
    }

    @Override
    public int compare(Artifact art1, Artifact art2) {
        if (art1 == art2) {
            return 0;
        }
        if (art1 == null) {
            return -1;
        }
        if (art2 == null) {
            return 1;
        }
        String s1 = art1.getGroupId() + art1.getArtifactId() + art1.getVersion();
        String s2 = art2.getGroupId() + art2.getArtifactId() + art2.getVersion();
        return s1.compareTo(s2);
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }

    public File getCpFile() {
        return this.outputFile;
    }

    public void setCpFile(File theCpFile) {
        this.outputFile = theCpFile;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public void setFileSeparator(String theFileSeparator) {
        this.fileSeparator = theFileSeparator;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public void setPathSeparator(String thePathSeparator) {
        this.pathSeparator = thePathSeparator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String thePrefix) {
        this.prefix = thePrefix;
    }

    public boolean isRegenerateFile() {
        return this.regenerateFile;
    }

    public void setRegenerateFile(boolean theRegenerateFile) {
        this.regenerateFile = theRegenerateFile;
    }

    public boolean isStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean theStripVersion) {
        this.stripVersion = theStripVersion;
    }

    public String getLocalRepoProperty() {
        return this.localRepoProperty;
    }

    public void setLocalRepoProperty(String localRepoProperty) {
        this.localRepoProperty = localRepoProperty;
    }

    public boolean isFileSepSet() {
        return this.isFileSepSet;
    }

    public void setFileSepSet(boolean isFileSepSet) {
        this.isFileSepSet = isFileSepSet;
    }

    public boolean isPathSepSet() {
        return this.isPathSepSet;
    }

    public void setPathSepSet(boolean isPathSepSet) {
        this.isPathSepSet = isPathSepSet;
    }
}

