/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractCompilerMojo;
import org.apache.maven.plugin.CompilationFailureException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;

public class TestCompilerMojo
extends AbstractCompilerMojo {
    private boolean skip;
    private List compileSourceRoots;
    private List classpathElements;
    private File outputDirectory;
    private Set testIncludes = new HashSet();
    private Set testExcludes = new HashSet();
    private String testSource;
    private String testTarget;
    private Map testCompilerArguments;
    private String testCompilerArgument;

    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
        } else {
            super.execute();
        }
    }

    protected List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    protected List getClasspathElements() {
        return this.classpathElements;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            this.testIncludes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, Collections.EMPTY_SET);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    protected String getSource() {
        return this.testSource == null ? this.source : this.testSource;
    }

    protected String getTarget() {
        return this.testTarget == null ? this.target : this.testTarget;
    }

    protected String getCompilerArgument() {
        return this.testCompilerArgument == null ? this.compilerArgument : this.testCompilerArgument;
    }

    protected Map getCompilerArguments() {
        return this.testCompilerArguments == null ? this.compilerArguments : this.testCompilerArguments;
    }
}

