/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clover.internal;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.codehaus.plexus.resource.ResourceManager;

public abstract class AbstractCloverMojo
extends AbstractMojo {
    private String cloverDatabase;
    private String cloverMergeDatabase;
    private String licenseLocation;
    private String flushPolicy;
    private int flushInterval;
    private boolean waitForFlush;
    private String jdk;
    private MavenProject project;
    private ResourceManager resourceManager;

    public void execute() throws MojoExecutionException {
        this.registerLicenseFile();
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected void registerLicenseFile() throws MojoExecutionException {
        AbstractCloverMojo.registerLicenseFile(this.getResourceManager(), this.licenseLocation, this.getLog(), ((Object)((Object)this)).getClass().getClassLoader());
    }

    public static void registerLicenseFile(ResourceManager resourceManager, String licenseLocation, Log logger, ClassLoader classloader) throws MojoExecutionException {
        String license;
        if (licenseLocation != null) {
            try {
                license = resourceManager.getResourceAsFile(licenseLocation).getPath();
                logger.debug((CharSequence)("Loading license from classpath [" + license + "]"));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to load license file [" + licenseLocation + "]", e);
            }
        } else {
            license = classloader.getResource("/clover.license").getFile();
        }
        logger.debug((CharSequence)("Using license file [" + license + "]"));
        System.setProperty("clover.license.path", license);
    }

    public static Project registerCloverAntTasks() {
        Project antProject = new Project();
        antProject.init();
        Taskdef taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setResource("clovertasks");
        taskdef.execute();
        return antProject;
    }

    public static void waitForFlush(boolean waitForFlush, int flushInterval) {
        if (waitForFlush) {
            try {
                Thread.sleep(2 * flushInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean areCloverDatabasesAvailable() {
        boolean shouldRun = false;
        File singleModuleCloverDatabase = new File(this.cloverDatabase);
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            shouldRun = true;
        }
        return shouldRun;
    }

    protected void setLicenseLocation(String licenseLocation) {
        this.licenseLocation = licenseLocation;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected boolean getWaitForFlush() {
        return this.waitForFlush;
    }

    protected String getJdk() {
        return this.jdk;
    }

    protected String getCloverDatabase() {
        return this.cloverDatabase;
    }

    protected String getCloverMergeDatabase() {
        return this.cloverMergeDatabase;
    }

    protected int getFlushInterval() {
        return this.flushInterval;
    }

    protected String getFlushPolicy() {
        return this.flushPolicy;
    }
}

