/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clover;

import com.cenqua.clover.tasks.CloverLogTask;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clover.internal.AbstractCloverMojo;
import org.apache.tools.ant.Project;

public class CloverLogMojo
extends AbstractCloverMojo {
    public void execute() throws MojoExecutionException {
        if (this.areCloverDatabasesAvailable()) {
            super.execute();
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            this.log();
        } else {
            this.getLog().info((CharSequence)"No Clover database found, skipping Clover database logging");
        }
    }

    private void log() {
        if (new File(this.getCloverDatabase()).exists()) {
            this.logDatabase(this.getCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.logDatabase(this.getCloverMergeDatabase());
        }
    }

    private void logDatabase(String database) {
        Project antProject = AbstractCloverMojo.registerCloverAntTasks();
        CloverLogTask cloverLogTask = (CloverLogTask)antProject.createTask("clover-log");
        cloverLogTask.setInitString(database);
        cloverLogTask.setOutputProperty("cloverlogproperty");
        cloverLogTask.execute();
        this.getLog().info((CharSequence)antProject.getProperty("cloverlogproperty"));
    }
}

