/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutor;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorException;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.plugin.checkstyle.CheckstyleReportListener;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultCheckstyleExecutor
extends AbstractLogEnabled
implements CheckstyleExecutor {
    private ResourceManager locator;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];

    public CheckstyleResults executeCheckstyle(CheckstyleExecutorRequest request) throws CheckstyleExecutorException, CheckstyleException {
        File[] files;
        ClassLoader checkstyleClassLoader = PackageNamesLoader.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(checkstyleClassLoader);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executeCheckstyle start headerLocation : " + request.getHeaderLocation());
        }
        this.locator.setOutputDirectory(new File(request.getProject().getBuild().getDirectory()));
        try {
            files = this.getFilesToProcess(request);
        }
        catch (IOException e) {
            throw new CheckstyleExecutorException("Error getting files to process", e);
        }
        FilterSet filterSet = this.getSuppressions(request);
        Checker checker = new Checker();
        List classPathStrings = new ArrayList();
        ArrayList<String> outputDirectories = new ArrayList<String>();
        try {
            classPathStrings = request.getProject().getCompileClasspathElements();
            outputDirectories.add(request.getProject().getBuild().getOutputDirectory());
            if (request.isIncludeTestSourceDirectory() && request.getSourceDirectory() != null && request.getTestSourceDirectory().exists() && request.getTestSourceDirectory().isDirectory()) {
                classPathStrings = request.getProject().getTestClasspathElements();
                outputDirectories.add(request.getProject().getBuild().getTestOutputDirectory());
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new CheckstyleExecutorException(e.getMessage(), e);
        }
        if (classPathStrings == null) {
            classPathStrings = Collections.EMPTY_LIST;
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPathStrings.size());
        for (String path : classPathStrings) {
            try {
                urls.add(new File(path).toURL());
            }
            catch (MalformedURLException e) {
                throw new CheckstyleExecutorException(e.getMessage(), e);
            }
        }
        for (String outputDirectoryString : outputDirectories) {
            try {
                File outputDirectoryFile;
                if (outputDirectoryString == null || !(outputDirectoryFile = new File(outputDirectoryString)).exists()) continue;
                URL outputDirectoryUrl = outputDirectoryFile.toURL();
                request.getLog().debug((CharSequence)("Adding the outputDirectory " + outputDirectoryUrl.toString() + " to the Checkstyle class path"));
                urls.add(outputDirectoryUrl);
            }
            catch (MalformedURLException e) {
                throw new CheckstyleExecutorException(e.getMessage(), e);
            }
        }
        URLClassLoader projectClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        checker.setClassloader((ClassLoader)projectClassLoader);
        checker.setModuleClassLoader(Thread.currentThread().getContextClassLoader());
        if (filterSet != null) {
            checker.addFilter((Filter)filterSet);
        }
        Configuration configuration = this.getConfiguration(request);
        checker.configure(configuration);
        AuditListener listener = request.getListener();
        if (listener != null) {
            checker.addListener(listener);
        }
        if (request.isConsoleOutput()) {
            checker.addListener((AuditListener)request.getConsoleListener());
        }
        CheckstyleReportListener sinkListener = new CheckstyleReportListener(request.getSourceDirectory(), configuration);
        if (request.isIncludeTestSourceDirectory() && request.getTestSourceDirectory() != null && request.getTestSourceDirectory().exists() && request.getTestSourceDirectory().isDirectory()) {
            sinkListener.addSourceDirectory(request.getTestSourceDirectory());
        }
        checker.addListener((AuditListener)sinkListener);
        List<File> filesList = Arrays.asList(files);
        int nbErrors = checker.process(filesList);
        checker.destroy();
        if (request.getStringOutputStream() != null) {
            request.getLog().info((CharSequence)request.getStringOutputStream().toString());
        }
        if (request.isFailsOnError() && nbErrors > 0) {
            throw new CheckstyleExecutorException("There are " + nbErrors + " checkstyle errors.");
        }
        if (nbErrors > 0) {
            request.getLog().info((CharSequence)("There are " + nbErrors + " checkstyle errors."));
        }
        return sinkListener.getResults();
    }

    public Configuration getConfiguration(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        try {
            String effectiveEncoding;
            ClassLoader checkstyleClassLoader = PackageNamesLoader.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(checkstyleClassLoader);
            String configFile = this.getConfigFile(request);
            Properties overridingProperties = this.getOverridingProperties(request);
            Configuration config = ConfigurationLoader.loadConfiguration((String)configFile, (PropertyResolver)new PropertiesExpander(overridingProperties));
            String string = effectiveEncoding = StringUtils.isNotEmpty((String)request.getEncoding()) ? request.getEncoding() : System.getProperty("file.encoding", "UTF-8");
            if (StringUtils.isEmpty((String)request.getEncoding())) {
                request.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + effectiveEncoding + ", i.e. build is platform dependent!"));
            }
            Configuration[] modules = config.getChildren();
            for (int i = 0; i < modules.length; ++i) {
                Configuration module = modules[i];
                if ("Checker".equals(module.getName()) || "com.puppycrawl.tools.checkstyle.Checker".equals(module.getName())) {
                    if (module instanceof DefaultConfiguration) {
                        ((DefaultConfiguration)module).addAttribute("charset", effectiveEncoding);
                    } else {
                        request.getLog().warn((CharSequence)("Failed to configure file encoding on module " + module));
                    }
                }
                if (!"TreeWalker".equals(module.getName()) && !"com.puppycrawl.tools.checkstyle.TreeWalker".equals(module.getName())) continue;
                if (module instanceof DefaultConfiguration) {
                    if (((DefaultConfiguration)module).getAttribute("cacheFile") != null) continue;
                    ((DefaultConfiguration)module).addAttribute("cacheFile", request.getCacheFile());
                    continue;
                }
                request.getLog().warn((CharSequence)("Failed to configure cache file on module " + module));
            }
            return config;
        }
        catch (CheckstyleException e) {
            throw new CheckstyleExecutorException("Failed during checkstyle configuration", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getOverridingProperties(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        String suppresionFile;
        Properties p = new Properties();
        try {
            if (request.getPropertiesLocation() != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("request.getPropertiesLocation() " + request.getPropertiesLocation());
                }
                File propertiesFile = this.locator.getResourceAsFile(request.getPropertiesLocation(), "checkstyle-checker.properties");
                FileInputStream properties = new FileInputStream(propertiesFile);
                try {
                    if (propertiesFile != null) {
                        p.load(properties);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)properties);
                }
            }
            if (StringUtils.isNotEmpty((String)request.getPropertyExpansion())) {
                String propertyExpansion = request.getPropertyExpansion();
                propertyExpansion = StringUtils.replace((String)propertyExpansion, (String)"\\", (String)"\\\\");
                p.load(new ByteArrayInputStream(propertyExpansion.getBytes()));
            }
            String headerLocation = request.getHeaderLocation();
            if ("config/maven_checks.xml".equals(request.getConfigLocation()) && "LICENSE.txt".equals(request.getHeaderLocation())) {
                headerLocation = "config/maven-header.txt";
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("headerLocation " + headerLocation);
            }
            if (StringUtils.isNotEmpty((String)headerLocation)) {
                try {
                    File headerFile = this.locator.getResourceAsFile(headerLocation, "checkstyle-header.txt");
                    if (headerFile != null) {
                        p.setProperty("checkstyle.header.file", headerFile.getAbsolutePath());
                    }
                }
                catch (FileResourceCreationException e) {
                    throw new CheckstyleExecutorException("Unable to process header location: " + headerLocation, e);
                }
                catch (ResourceNotFoundException e) {
                    throw new CheckstyleExecutorException("Unable to process header location: " + headerLocation, e);
                }
            }
            if (request.getCacheFile() != null) {
                p.setProperty("checkstyle.cache.file", request.getCacheFile());
            }
        }
        catch (IOException e) {
            throw new CheckstyleExecutorException("Failed to get overriding properties", e);
        }
        catch (FileResourceCreationException e) {
            throw new CheckstyleExecutorException("Failed to get overriding properties", e);
        }
        catch (ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Failed to get overriding properties", e);
        }
        if (request.getSuppressionsFileExpression() != null && (suppresionFile = request.getSuppressionsLocation()) != null) {
            p.setProperty(request.getSuppressionsFileExpression(), suppresionFile);
        }
        return p;
    }

    private File[] getFilesToProcess(CheckstyleExecutorRequest request) throws IOException {
        StringBuffer excludesStr = new StringBuffer();
        if (StringUtils.isNotEmpty((String)request.getExcludes())) {
            excludesStr.append(request.getExcludes());
        }
        String[] defaultExcludes = FileUtils.getDefaultExcludes();
        for (int i = 0; i < defaultExcludes.length; ++i) {
            if (excludesStr.length() > 0) {
                excludesStr.append(",");
            }
            excludesStr.append(defaultExcludes[i]);
        }
        if (request.getSourceDirectory() == null || !request.getSourceDirectory().exists()) {
            return EMPTY_FILE_ARRAY;
        }
        List files = FileUtils.getFiles((File)request.getSourceDirectory(), (String)request.getIncludes(), (String)excludesStr.toString());
        if (request.isIncludeTestSourceDirectory() && request.getTestSourceDirectory() != null && request.getTestSourceDirectory().exists() && request.getTestSourceDirectory().isDirectory()) {
            files.addAll(FileUtils.getFiles((File)request.getTestSourceDirectory(), (String)request.getIncludes(), (String)excludesStr.toString()));
        }
        return files.toArray(EMPTY_FILE_ARRAY);
    }

    private FilterSet getSuppressions(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        try {
            File suppressionsFile = this.locator.resolveLocation(request.getSuppressionsLocation(), "checkstyle-suppressions.xml");
            if (suppressionsFile == null) {
                return null;
            }
            return SuppressionsLoader.loadSuppressions((String)suppressionsFile.getAbsolutePath());
        }
        catch (CheckstyleException ce) {
            throw new CheckstyleExecutorException("failed to load suppressions location: " + request.getSuppressionsLocation(), ce);
        }
        catch (IOException e) {
            throw new CheckstyleExecutorException("Failed to process supressions location: " + request.getSuppressionsLocation(), e);
        }
    }

    private String getConfigFile(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("request.getConfigLocation() " + request.getConfigLocation());
            }
            for (MavenProject parent = request.getProject(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
                File dir = parent.getFile().getParentFile();
                this.locator.addSearchPath("file", dir.getAbsolutePath());
            }
            this.locator.addSearchPath("url", "");
            File configFile = this.locator.getResourceAsFile(request.getConfigLocation(), "checkstyle-checker.xml");
            if (configFile == null) {
                throw new CheckstyleExecutorException("Unable to process config location: " + request.getConfigLocation());
            }
            return configFile.getAbsolutePath();
        }
        catch (ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Unable to find configuration file at location " + request.getConfigLocation(), e);
        }
        catch (FileResourceCreationException e) {
            throw new CheckstyleExecutorException("Unable to process configuration file location " + request.getConfigLocation(), e);
        }
    }
}

