/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutor;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorException;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CheckstyleViolationCheckMojo
extends AbstractMojo {
    private File outputFile;
    private String outputFileFormat;
    private boolean failOnViolation;
    private int maxAllowedViolations = 0;
    private String violationSeverity = "error";
    private boolean skip;
    private boolean skipExec;
    private boolean logViolationsToConsole;
    private String configLocation;
    private String propertiesLocation;
    private String propertyExpansion;
    private String headerLocation;
    private String cacheFile;
    private String suppressionsFileExpression;
    private String suppressionsLocation;
    private String encoding;
    protected ResourceManager locator;
    protected CheckstyleExecutor checkstyleExecutor;
    private boolean consoleOutput;
    protected MavenProject project;
    private File useFile;
    private String excludes;
    private String includes;
    private boolean failsOnError;
    private File testSourceDirectory;
    private boolean includeTestSourceDirectory;
    private File sourceDirectory;
    private ByteArrayOutputStream stringOutputStream;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            if (!this.skipExec) {
                this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
                this.locator.addSearchPath("url", "");
                this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
                    request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setLog(this.getLog()).setProject(this.project).setSourceDirectory(this.sourceDirectory).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectory(this.testSourceDirectory).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
                    this.checkstyleExecutor.executeCheckstyle(request);
                }
                catch (CheckstyleException e) {
                    throw new MojoExecutionException("Failed during checkstyle configuration", (Exception)((Object)e));
                }
                catch (CheckstyleExecutorException e) {
                    throw new MojoExecutionException("Failed during checkstyle execution", (Exception)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentClassLoader);
                }
            }
            if (!"xml".equals(this.outputFileFormat)) {
                throw new MojoExecutionException("Output format is '" + this.outputFileFormat + "', checkstyle:check requires format to be 'xml'.");
            }
            if (!this.outputFile.exists()) {
                this.getLog().info((CharSequence)"Unable to perform checkstyle:check, unable to find checkstyle:checkstyle outputFile.");
                return;
            }
            try {
                MXParser xpp = new MXParser();
                XmlStreamReader freader = ReaderFactory.newXmlReader((File)this.outputFile);
                BufferedReader breader = new BufferedReader((Reader)freader);
                xpp.setInput((Reader)breader);
                int violations = this.countViolations((XmlPullParser)xpp);
                if (violations > this.maxAllowedViolations) {
                    if (this.failOnViolation) {
                        String msg = "You have " + violations + " Checkstyle violation" + (violations > 1 ? "s" : "") + ".";
                        if (this.maxAllowedViolations > 0) {
                            msg = msg + " The maximum number of allowed violations is " + this.maxAllowedViolations + ".";
                        }
                        throw new MojoFailureException(msg);
                    }
                    this.getLog().warn((CharSequence)"checkstyle:check violations detected but failOnViolation set to false");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)e);
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)((Object)e));
            }
        }
    }

    private int countViolations(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int count = 0;
        int eventType = xpp.getEventType();
        String file = "";
        while (eventType != 1) {
            if (eventType == 2 && "file".equals(xpp.getName())) {
                file = xpp.getAttributeValue("", "name");
                file = file.substring(file.lastIndexOf(File.separatorChar) + 1);
            }
            if (eventType == 2 && "error".equals(xpp.getName()) && this.isViolation(xpp.getAttributeValue("", "severity"))) {
                if (this.logViolationsToConsole) {
                    StringBuffer stb = new StringBuffer();
                    stb.append(file);
                    stb.append('[');
                    stb.append(xpp.getAttributeValue("", "line"));
                    stb.append(':');
                    stb.append(xpp.getAttributeValue("", "column"));
                    stb.append("] ");
                    stb.append(xpp.getAttributeValue("", "message"));
                    this.getLog().error((CharSequence)stb.toString());
                }
                ++count;
            }
            eventType = xpp.next();
        }
        return count;
    }

    private boolean isViolation(String severity) {
        if ("error".equals(severity)) {
            return "error".equals(this.violationSeverity) || "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("warning".equals(severity)) {
            return "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("info".equals(severity)) {
            return "info".equals(this.violationSeverity);
        }
        return false;
    }

    private DefaultLogger getConsoleListener() throws MojoExecutionException {
        DefaultLogger consoleListener;
        if (this.useFile == null) {
            this.stringOutputStream = new ByteArrayOutputStream();
            consoleListener = new DefaultLogger((OutputStream)this.stringOutputStream, false);
        } else {
            OutputStream out = this.getOutputStream(this.useFile);
            consoleListener = new DefaultLogger(out, true);
        }
        return consoleListener;
    }

    private OutputStream getOutputStream(File file) throws MojoExecutionException {
        FileOutputStream fileOutputStream;
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to create output stream: " + file, (Exception)e);
        }
        return fileOutputStream;
    }

    private AuditListener getListener() throws MojoFailureException, MojoExecutionException {
        XMLLogger listener = null;
        if (StringUtils.isNotEmpty((String)this.outputFileFormat)) {
            File resultFile = this.outputFile;
            OutputStream out = this.getOutputStream(resultFile);
            if ("xml".equals(this.outputFileFormat)) {
                listener = new XMLLogger(out, true);
            } else if ("plain".equals(this.outputFileFormat)) {
                listener = new DefaultLogger(out, true);
            } else {
                throw new MojoFailureException("Invalid output file format: (" + this.outputFileFormat + "). Must be 'plain' or 'xml'.");
            }
        }
        return listener;
    }
}

