/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CheckstyleViolationCheckMojo
extends AbstractMojo {
    private File outputFile;
    private String outputFileFormat;
    private boolean failOnViolation;
    private int maxAllowedViolations = 0;
    private String violationSeverity = "error";
    private boolean skip;
    private boolean logViolationsToConsole;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            if (!"xml".equals(this.outputFileFormat)) {
                throw new MojoExecutionException("Output format is '" + this.outputFileFormat + "', checkstyle:check requires format to be 'xml'.");
            }
            if (!this.outputFile.exists()) {
                this.getLog().info((CharSequence)"Unable to perform checkstyle:check, unable to find checkstyle:checkstyle outputFile.");
                return;
            }
            try {
                MXParser xpp = new MXParser();
                XmlStreamReader freader = ReaderFactory.newXmlReader((File)this.outputFile);
                BufferedReader breader = new BufferedReader((Reader)freader);
                xpp.setInput((Reader)breader);
                int violations = this.countViolations((XmlPullParser)xpp);
                if (violations > this.maxAllowedViolations) {
                    if (this.failOnViolation) {
                        String msg = "You have " + violations + " Checkstyle violation" + (violations > 1 ? "s" : "") + ".";
                        if (this.maxAllowedViolations > 0) {
                            msg = msg + " The maximum number of allowed violations is " + this.maxAllowedViolations + ".";
                        }
                        throw new MojoFailureException(msg);
                    }
                    this.getLog().warn((CharSequence)"checkstyle:check violations detected but failOnViolation set to false");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)e);
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Unable to read Checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)((Object)e));
            }
        }
    }

    private int countViolations(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int count = 0;
        int eventType = xpp.getEventType();
        String file = "";
        while (eventType != 1) {
            if (eventType == 2 && "file".equals(xpp.getName())) {
                file = xpp.getAttributeValue("", "name");
                file = file.substring(file.lastIndexOf(File.separatorChar) + 1);
            }
            if (eventType == 2 && "error".equals(xpp.getName()) && this.isViolation(xpp.getAttributeValue("", "severity"))) {
                if (this.logViolationsToConsole) {
                    StringBuffer stb = new StringBuffer();
                    stb.append(file);
                    stb.append('[');
                    stb.append(xpp.getAttributeValue("", "line"));
                    stb.append(':');
                    stb.append(xpp.getAttributeValue("", "column"));
                    stb.append("] ");
                    stb.append(xpp.getAttributeValue("", "message"));
                    this.getLog().error((CharSequence)stb.toString());
                }
                ++count;
            }
            eventType = xpp.next();
        }
        return count;
    }

    private boolean isViolation(String severity) {
        if ("error".equals(severity)) {
            return "error".equals(this.violationSeverity) || "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("warning".equals(severity)) {
            return "warning".equals(this.violationSeverity) || "info".equals(this.violationSeverity);
        }
        if ("info".equals(severity)) {
            return "info".equals(this.violationSeverity);
        }
        return false;
    }
}

