/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractChangesReport
extends AbstractMavenReport {
    @Parameter(defaultValue="${project.reporting.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Component
    protected Renderer siteRenderer;
    @Component
    protected MavenProject project;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected ArtifactFactory factory;
    @Component
    protected I18N i18n;

    private File getSkinArtifactFile() throws MojoExecutionException {
        Artifact artifact;
        Skin skin = Skin.getDefaultSkin();
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.factory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.resolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("The skin version '" + version + "' is not valid: " + e.getMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("The skin does not exist: " + e.getMessage());
        }
        return artifact.getFile();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", this.getOutputEncoding());
            Locale locale = Locale.getDefault();
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(this.getSkinArtifactFile(), attributes, model, this.getName(locale), locale);
            siteContext.setOutputEncoding(this.getOutputEncoding());
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, locale);
            this.outputDirectory.mkdirs();
            File file = new File(this.outputDirectory, this.getOutputName() + ".html");
            fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, this.getOutputEncoding());
            this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            try {
                throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e2);
                }
                catch (MavenReportException e3) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected String getOutputEncoding() {
        return this.outputEncoding != null ? this.outputEncoding : "UTF-8";
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }
}

