/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ProjectUtils;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.issues.IssueUtils;
import org.apache.maven.plugin.issues.IssuesReportGenerator;
import org.apache.maven.plugin.issues.IssuesReportHelper;
import org.apache.maven.plugin.jira.AbstractJiraDownloader;
import org.apache.maven.plugin.jira.JiraDownloader;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;

@Mojo(name="jira-report", threadSafe=true)
public class JiraMojo
extends AbstractChangesReport {
    private static final Map<String, Integer> JIRA_COLUMNS = new HashMap<String, Integer>(16);
    @Parameter(defaultValue="Key,Summary,Status,Resolution,Assignee")
    private String columnNames;
    @Parameter(defaultValue="false")
    private boolean useJql;
    @Parameter(defaultValue="")
    private String component;
    @Parameter(defaultValue="")
    private String filter;
    @Parameter(defaultValue="")
    private String fixVersionIds;
    @Parameter(defaultValue="EEE, d MMM yyyy HH:mm:ss Z")
    private String jiraDatePattern;
    @Parameter(defaultValue="")
    private String jiraPassword;
    @Parameter(defaultValue="")
    private String jiraUser;
    @Parameter(defaultValue="${project.build.directory}/jira-results.xml", required=true, readonly=true)
    private File jiraXmlPath;
    @Parameter(defaultValue="100")
    private int maxEntries;
    @Parameter(defaultValue="false")
    private boolean onlyCurrentVersion;
    @Parameter(defaultValue="")
    private String priorityIds;
    @Parameter(defaultValue="Fixed")
    private String resolutionIds;
    @Component
    private Settings settings;
    @Parameter(property="changes.jira.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="Priority DESC, Created DESC")
    private String sortColumnNames;
    @Parameter(defaultValue="Closed")
    private String statusIds;
    @Parameter(defaultValue="")
    private String typeIds;
    @Parameter(defaultValue="")
    private String versionPrefix;
    @Parameter(defaultValue="")
    private String webPassword;
    @Parameter(defaultValue="")
    private String webUser;
    private AbstractJiraDownloader mockDownloader;

    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        if (this.mockDownloader != null) {
            return true;
        }
        return ProjectUtils.validateIfIssueManagementComplete(this.project, "JIRA", "JIRA Report", this.getLog());
    }

    public void executeReport(Locale locale) throws MavenReportException {
        List<Integer> columnIds = IssuesReportHelper.getColumnIds(this.columnNames, JIRA_COLUMNS);
        if (columnIds.isEmpty()) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + this.columnNames + "' are valid.");
        }
        try {
            AbstractJiraDownloader issueDownloader = this.mockDownloader != null ? this.mockDownloader : new JiraDownloader();
            this.configureIssueDownloader(issueDownloader);
            issueDownloader.doExecute();
            List<Issue> issueList = issueDownloader.getIssueList();
            if (StringUtils.isNotEmpty((String)this.versionPrefix)) {
                int originalNumberOfIssues = issueList.size();
                issueList = IssueUtils.filterIssuesWithVersionPrefix(issueList, this.versionPrefix);
                this.getLog().debug((CharSequence)("Filtered out " + issueList.size() + " issues of " + originalNumberOfIssues + " that matched the versionPrefix '" + this.versionPrefix + "'."));
            }
            if (this.onlyCurrentVersion) {
                String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.project.getVersion();
                issueList = IssueUtils.getIssuesForVersion(issueList, version);
                this.getLog().info((CharSequence)"The JIRA Report will contain issues only for the current version.");
            }
            IssuesReportGenerator report = new IssuesReportGenerator(IssuesReportHelper.toIntArray(columnIds));
            if (issueList.isEmpty()) {
                report.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            } else {
                report.doGenerateReport(this.getBundle(locale), this.getSink(), issueList);
            }
        }
        catch (Exception e) {
            this.getLog().warn((Throwable)e);
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    public String getOutputName() {
        return "jira-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jira-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void configureIssueDownloader(AbstractJiraDownloader issueDownloader) {
        issueDownloader.setLog(this.getLog());
        issueDownloader.setMavenProject(this.project);
        issueDownloader.setOutput(this.jiraXmlPath);
        issueDownloader.setNbEntries(this.maxEntries);
        issueDownloader.setComponent(this.component);
        issueDownloader.setFixVersionIds(this.fixVersionIds);
        issueDownloader.setStatusIds(this.statusIds);
        issueDownloader.setResolutionIds(this.resolutionIds);
        issueDownloader.setPriorityIds(this.priorityIds);
        issueDownloader.setSortColumnNames(this.sortColumnNames);
        issueDownloader.setFilter(this.filter);
        issueDownloader.setJiraDatePattern(this.jiraDatePattern);
        issueDownloader.setJiraUser(this.jiraUser);
        issueDownloader.setJiraPassword(this.jiraPassword);
        issueDownloader.setTypeIds(this.typeIds);
        issueDownloader.setWebUser(this.webUser);
        issueDownloader.setWebPassword(this.webPassword);
        issueDownloader.setSettings(this.settings);
        issueDownloader.setUseJql(this.useJql);
        issueDownloader.setOnlyCurrentVersion(this.onlyCurrentVersion);
        issueDownloader.setVersionPrefix(this.versionPrefix);
    }

    public void setMockDownloader(AbstractJiraDownloader mockDownloader) {
        this.mockDownloader = mockDownloader;
    }

    public AbstractJiraDownloader getMockDownloader() {
        return this.mockDownloader;
    }

    static {
        JIRA_COLUMNS.put("Assignee", new Integer(0));
        JIRA_COLUMNS.put("Component", new Integer(1));
        JIRA_COLUMNS.put("Created", new Integer(2));
        JIRA_COLUMNS.put("Fix Version", new Integer(3));
        JIRA_COLUMNS.put("Id", new Integer(4));
        JIRA_COLUMNS.put("Key", new Integer(5));
        JIRA_COLUMNS.put("Priority", new Integer(6));
        JIRA_COLUMNS.put("Reporter", new Integer(7));
        JIRA_COLUMNS.put("Resolution", new Integer(8));
        JIRA_COLUMNS.put("Status", new Integer(9));
        JIRA_COLUMNS.put("Summary", new Integer(10));
        JIRA_COLUMNS.put("Type", new Integer(11));
        JIRA_COLUMNS.put("Updated", new Integer(12));
        JIRA_COLUMNS.put("Version", new Integer(13));
    }
}

