/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.trac;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.trac.TracReportGenerator;
import org.apache.maven.plugin.trac.TracTicket;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.codehaus.plexus.util.StringUtils;

public class TracMojo
extends AbstractChangesReport {
    private String tracUser;
    private String tracPassword;
    private String query;
    private String columnNames;

    public boolean canGenerateReport() {
        return this.validateIfIssueManagementComplete();
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            throw new MavenReportException("Issue Management is out of order.");
        }
        this.parseTracUrl();
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL(this.project.getIssueManagement().getUrl() + "/login/xmlrpc"));
        }
        catch (MalformedURLException e1) {
            throw new MavenReportException("The Trac URL is incorrect.");
        }
        config.setBasicUserName(this.tracUser);
        config.setBasicPassword(this.tracPassword);
        Object[] queryResult = null;
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)config);
        String qstr = "";
        if (!StringUtils.isEmpty((String)this.query)) {
            qstr = this.query;
        }
        Object[] params = new Object[]{new String(qstr)};
        try {
            queryResult = (Object[])client.execute("ticket.query", params);
        }
        catch (XmlRpcException e) {
            throw new MavenReportException("XmlRpc Error.", (Exception)((Object)e));
        }
        ArrayList<TracTicket> ticketList = new ArrayList<TracTicket>();
        TracReportGenerator report = new TracReportGenerator(this.columnNames);
        if (queryResult.length == 0) {
            report.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            this.getLog().warn((CharSequence)"No ticket has matched.");
        } else {
            for (int i = 0; i < queryResult.length; ++i) {
                params = new Object[]{queryResult[i]};
                try {
                    Object[] ticketresult = null;
                    TracTicket matchTicket = new TracTicket();
                    ticketresult = (Object[])client.execute("ticket.get", params);
                    ticketList.add(this.setQueryResult(ticketresult, matchTicket));
                    continue;
                }
                catch (XmlRpcException e) {
                    throw new MavenReportException("XmlRpc Error.", (Exception)((Object)e));
                }
            }
            try {
                report.doGenerateReport(this.getBundle(locale), this.getSink(), ticketList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getName(Locale locale) {
        return "Trac Report";
    }

    public String getDescription(Locale locale) {
        return "Report on Ticket from the Trac.";
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return "trac-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("trac-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void parseTracUrl() {
        String tracUrl = this.project.getIssueManagement().getUrl();
        if (tracUrl.endsWith("/")) {
            this.project.getIssueManagement().setUrl(tracUrl.substring(0, tracUrl.length() - 1));
        }
    }

    private TracTicket setQueryResult(Object[] ticketObj, TracTicket ticket) {
        ticket.setId(String.valueOf(ticketObj[0]));
        ticket.setLink(this.project.getIssueManagement().getUrl() + "/ticket/" + String.valueOf(ticketObj[0]));
        ticket.setTimeCreated(String.valueOf(ticketObj[1]));
        ticket.setTimeChanged(String.valueOf(ticketObj[2]));
        Map attributes = (Map)ticketObj[3];
        ticket.setType((String)attributes.get("type"));
        ticket.setSummary((String)attributes.get("summary"));
        ticket.setStatus((String)attributes.get("status"));
        ticket.setResolution((String)attributes.get("resolution"));
        ticket.setOwner((String)attributes.get("owner"));
        ticket.setMilestone((String)attributes.get("milestone"));
        ticket.setPriority((String)attributes.get("priority"));
        ticket.setReporter((String)attributes.get("reporter"));
        ticket.setComponent((String)attributes.get("component"));
        return ticket;
    }

    private boolean validateIfIssueManagementComplete() {
        if (this.project.getIssueManagement() == null) {
            this.getLog().error((CharSequence)"No Issue Management set. No Trac Report will be generated.");
            return false;
        }
        if (this.project.getIssueManagement().getUrl() == null || this.project.getIssueManagement().getUrl().trim().equals("")) {
            this.getLog().error((CharSequence)"No URL set in Issue Management. No Trac Report will be generated.");
            return false;
        }
        if (this.project.getIssueManagement().getSystem() != null && !this.project.getIssueManagement().getSystem().equalsIgnoreCase("trac")) {
            this.getLog().error((CharSequence)"The Trac Report only supports Trac.  No Trac Report will be generated.");
            return false;
        }
        return true;
    }
}

