/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseUtils {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private Log log;

    public ReleaseUtils(Log log) {
        this.log = log;
    }

    public Release getLatestRelease(List<Release> releases, String pomVersion) throws MojoExecutionException {
        if (pomVersion != null && pomVersion.endsWith(SNAPSHOT_SUFFIX)) {
            pomVersion = pomVersion.substring(0, pomVersion.length() - SNAPSHOT_SUFFIX.length());
        }
        this.getLog().debug((CharSequence)("Found " + releases.size() + " releases."));
        Release release = this.getRelease(releases, pomVersion);
        if (release == null) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases: " + ReleaseUtils.toString(releases));
        }
        return release;
    }

    private Log getLog() {
        return this.log;
    }

    protected Release getRelease(List<Release> releases, String version) {
        for (Release release : releases) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(version)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        return null;
    }

    protected void logRelease(Release release) {
        Iterator<Action> i$ = release.getActions().iterator();
        while (i$.hasNext()) {
            Action action1;
            Action action = action1 = i$.next();
            this.getLog().debug((CharSequence)("o " + action.getType()));
            this.getLog().debug((CharSequence)("issue : " + action.getIssue()));
            this.getLog().debug((CharSequence)("action : " + action.getAction()));
            this.getLog().debug((CharSequence)("dueTo : " + action.getDueTo()));
        }
    }

    public List<Release> mergeReleases(List<Release> firstReleases, List<Release> secondReleases) {
        if (firstReleases == null && secondReleases == null) {
            return Collections.emptyList();
        }
        if (firstReleases == null) {
            return secondReleases;
        }
        if (secondReleases == null) {
            return firstReleases;
        }
        ArrayList<Release> mergedReleases = new ArrayList<Release>();
        for (Release firstRelease : firstReleases) {
            Release secondRelease = this.getRelease(secondReleases, firstRelease.getVersion());
            if (secondRelease != null && secondRelease.getActions() != null) {
                firstRelease.getActions().addAll(secondRelease.getActions());
            }
            mergedReleases.add(firstRelease);
        }
        for (Release secondRelease : secondReleases) {
            Release mergedRelease = this.getRelease(mergedReleases, secondRelease.getVersion());
            if (mergedRelease != null) continue;
            mergedReleases.add(secondRelease);
        }
        return mergedReleases;
    }

    public List<Release> convertReleaseList(List changesReleases) {
        ArrayList<Release> releases = new ArrayList<Release>();
        for (Object changesRelease : changesReleases) {
            Release release = (Release)changesRelease;
            releases.add(release);
        }
        return releases;
    }

    public List mergeReleases(List releases, String componentName, List componentReleases) {
        Release release;
        if (releases == null && componentReleases == null) {
            return Collections.EMPTY_LIST;
        }
        if (componentReleases == null) {
            return releases;
        }
        ArrayList<Release> mergedReleases = new ArrayList<Release>();
        if (releases != null) {
            for (Object release1 : releases) {
                release = (Release)release1;
                Release componentRelease = this.getRelease(componentReleases, release.getVersion());
                if (componentRelease != null) {
                    release.addComponent(componentName, componentRelease);
                }
                mergedReleases.add(release);
            }
        }
        for (Object componentRelease1 : componentReleases) {
            release = (Release)componentRelease1;
            Release mergedRelease = this.getRelease(mergedReleases, release.getVersion());
            if (mergedRelease != null) continue;
            Release componentRelease = new Release();
            componentRelease.setVersion(release.getVersion());
            componentRelease.setDateRelease(release.getDateRelease());
            componentRelease.addComponent(componentName, release);
            mergedReleases.add(componentRelease);
        }
        return mergedReleases;
    }

    private static String toString(Release release) {
        return release.getClass().getSimpleName() + "[version='" + release.getVersion() + "'" + ", date='" + release.getDateRelease() + "'" + ", description='" + release.getDescription() + "'" + ", actionsSize=" + release.getActions().size() + "]";
    }

    public static String toString(List<Release> releases) {
        ArrayList<String> releaseStrings = new ArrayList<String>(releases.size());
        for (Release release : releases) {
            releaseStrings.add(ReleaseUtils.toString(release));
        }
        return ((Object)releaseStrings).toString();
    }
}

