/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changelog;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.changelog.ChangeLog;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.StringUtils;

public class ChangeLogReport
extends AbstractMavenReport {
    private static final String FILE_TOKEN = "%FILE%";
    private static final int DEFAULT_RANGE = 30;
    private String headingDateFormat = "yyyy-MM-dd";
    private String type;
    private int range;
    private List dates;
    private List tags;
    private String dateFormat;
    private File basedir;
    private File outputXML;
    private int outputXMLExpiration;
    private String commentFormat;
    private String outputEncoding;
    private String username;
    private String password;
    private String privateKey;
    private String passphrase;
    private String tagBase;
    protected String scmUrl;
    private MavenProject project;
    private File outputDirectory;
    private SiteRenderer siteRenderer;
    private boolean offline;
    private ScmManager manager;
    private Settings settings;
    private String connectionType;
    protected String displayFileDetailUrl;
    private String rptRepository;
    private String rptOneRepoParam;
    private String rptMultiRepoParam;
    private String connection;
    private Properties systemProperties;

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.basedir.exists()) {
            this.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            return;
        }
        this.verifySCMTypeParams();
        if (this.systemProperties != null) {
            Iterator iter = ((Hashtable)this.systemProperties).keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = this.systemProperties.getProperty(key);
                System.setProperty(key, value);
                this.getLog().debug((CharSequence)("Setting system property: " + key + "=" + value));
            }
        }
        this.doGenerateReport(this.getChangedSets(), this.getBundle(locale), this.getSink());
    }

    protected List getChangedSets() throws MavenReportException {
        List changelogList = null;
        if (!this.outputXML.isAbsolute()) {
            this.outputXML = new File(this.project.getBasedir(), this.outputXML.getPath());
        }
        if (this.outputXML.exists() && this.outputXMLExpiration > 0 && (long)(this.outputXMLExpiration * 60000) > System.currentTimeMillis() - this.outputXML.lastModified()) {
            try {
                FileInputStream fIn = new FileInputStream(this.outputXML);
                this.getLog().info((CharSequence)"Using existing changelog.xml...");
                changelogList = ChangeLog.loadChangedSets(fIn);
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                throw new MavenReportException("An error occurred while parsing " + this.outputXML.getAbsolutePath(), e);
            }
        }
        if (changelogList == null) {
            if (this.offline) {
                throw new MavenReportException("This report requires online mode.");
            }
            this.getLog().info((CharSequence)("Generating changed sets xml to: " + this.outputXML.getAbsolutePath()));
            changelogList = this.generateChangeSetsFromSCM();
            try {
                this.writeChangelogXml(changelogList);
            }
            catch (FileNotFoundException e) {
                throw new MavenReportException("Can't create " + this.outputXML.getAbsolutePath(), (Exception)e);
            }
        }
        return changelogList;
    }

    private void writeChangelogXml(List changelogList) throws FileNotFoundException {
        StringBuffer changelogXml = new StringBuffer();
        changelogXml.append("<?xml version=\"1.0\" encoding=\"").append(this.outputEncoding).append("\"?>\n");
        changelogXml.append("<changelog>");
        Iterator sets = changelogList.iterator();
        while (sets.hasNext()) {
            changelogXml.append("\n  ");
            ChangeLogSet changelogSet = (ChangeLogSet)sets.next();
            String changeset = changelogSet.toXML(this.outputEncoding);
            if (changeset.startsWith("<?xml")) {
                int idx = changeset.indexOf("?>") + 2;
                changeset = changeset.substring(idx);
            }
            changelogXml.append(changeset);
        }
        changelogXml.append("\n</changelog>");
        this.outputXML.getParentFile().mkdirs();
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.outputXML)));
        pw.write(changelogXml.toString());
        pw.flush();
        pw.close();
    }

    protected List generateChangeSetsFromSCM() throws MavenReportException {
        try {
            ArrayList<ChangeLogSet> changeSets = new ArrayList<ChangeLogSet>();
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.manager.getProviderByRepository(repository);
            if ("range".equals(this.type)) {
                ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), null, null, this.range, (ScmBranch)null, this.dateFormat);
                this.checkResult((ScmResult)result);
                changeSets.add(result.getChangeLog());
            } else if ("tag".equals(this.type)) {
                if (repository.getProvider().equals("svn")) {
                    throw new MavenReportException("The type '" + this.type + "' isn't supported for svn.");
                }
                Iterator tagsIter = this.tags.iterator();
                String startTag = (String)tagsIter.next();
                String endTag = null;
                if (tagsIter.hasNext()) {
                    while (tagsIter.hasNext()) {
                        endTag = (String)tagsIter.next();
                        ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), (ScmVersion)new ScmRevision(startTag), (ScmVersion)new ScmRevision(endTag));
                        this.checkResult((ScmResult)result);
                        changeSets.add(result.getChangeLog());
                        startTag = endTag;
                    }
                } else {
                    ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), (ScmVersion)new ScmRevision(startTag), (ScmVersion)new ScmRevision(endTag));
                    this.checkResult((ScmResult)result);
                    changeSets.add(result.getChangeLog());
                }
            } else if ("date".equals(this.type)) {
                Iterator dateIter = this.dates.iterator();
                String startDate = (String)dateIter.next();
                String endDate = null;
                if (dateIter.hasNext()) {
                    while (dateIter.hasNext()) {
                        endDate = (String)dateIter.next();
                        ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), this.parseDate(startDate), this.parseDate(endDate), 0, (ScmBranch)null);
                        this.checkResult((ScmResult)result);
                        changeSets.add(result.getChangeLog());
                        startDate = endDate;
                    }
                } else {
                    ChangeLogScmResult result = provider.changeLog(repository, new ScmFileSet(this.basedir), this.parseDate(startDate), this.parseDate(endDate), 0, (ScmBranch)null);
                    this.checkResult((ScmResult)result);
                    changeSets.add(result.getChangeLog());
                }
            } else {
                throw new MavenReportException("The type '" + this.type + "' isn't supported.");
            }
            return changeSets;
        }
        catch (ScmException e) {
            throw new MavenReportException("Cannot run changelog command : ", (Exception)((Object)e));
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("An error has occurred during changelog command : ", (Exception)((Object)e));
        }
    }

    private Date parseDate(String date) throws MojoExecutionException {
        if (date == null || date.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Please use this date pattern: " + formatter.toLocalizedPattern(), (Exception)e);
        }
    }

    public ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.manager.makeScmRepository(this.getConnection());
            ScmProviderRepository providerRepo = repository.getProviderRepository();
            if (!StringUtils.isEmpty((String)this.username)) {
                providerRepo.setUser(this.username);
            }
            if (!StringUtils.isEmpty((String)this.password)) {
                providerRepo.setPassword(this.password);
            }
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                this.loadInfosFromSettings(repo);
                if (!StringUtils.isEmpty((String)this.username)) {
                    repo.setUser(this.username);
                }
                if (!StringUtils.isEmpty((String)this.password)) {
                    repo.setPassword(this.password);
                }
                if (!StringUtils.isEmpty((String)this.privateKey)) {
                    repo.setPrivateKey(this.privateKey);
                }
                if (!StringUtils.isEmpty((String)this.passphrase)) {
                    repo.setPassphrase(this.passphrase);
                }
            }
            if (!StringUtils.isEmpty((String)this.tagBase) && repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                svnRepo.setTagBase(this.tagBase);
            }
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private void loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        if (this.username == null || this.password == null) {
            Server server;
            String host = repo.getHost();
            int port = repo.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
            if ((server = this.settings.getServer(host)) != null) {
                if (this.username == null) {
                    this.username = this.settings.getServer(host).getUsername();
                }
                if (this.password == null) {
                    this.password = this.settings.getServer(host).getPassword();
                }
                if (this.privateKey == null) {
                    this.privateKey = this.settings.getServer(host).getPrivateKey();
                }
                if (this.passphrase == null) {
                    this.passphrase = this.settings.getServer(host).getPassphrase();
                }
            }
        }
    }

    public void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed.");
        }
    }

    protected String getConnection() throws MavenReportException {
        String scmDeveloper;
        if (this.connection != null) {
            return this.connection;
        }
        if (this.project.getScm() == null) {
            throw new MavenReportException("SCM Connection is not set.");
        }
        String scmConnection = this.project.getScm().getConnection();
        if (StringUtils.isNotEmpty((String)scmConnection) && "connection".equals(this.connectionType.toLowerCase())) {
            this.connection = scmConnection;
        }
        if (StringUtils.isNotEmpty((String)(scmDeveloper = this.project.getScm().getDeveloperConnection())) && "developerconnection".equals(this.connectionType.toLowerCase())) {
            this.connection = scmDeveloper;
        }
        if (StringUtils.isEmpty((String)this.connection)) {
            throw new MavenReportException("SCM Connection is not set.");
        }
        return this.connection;
    }

    private void verifySCMTypeParams() throws MavenReportException {
        if ("range".equals(this.type)) {
            if (this.range == -1) {
                this.range = 30;
            }
        } else if ("date".equals(this.type)) {
            if (this.dates == null) {
                throw new MavenReportException("The dates parameter is required when type=\"date\". The value should be the absolute date for the start of the log.");
            }
        } else if ("tag".equals(this.type)) {
            if (this.tags == null) {
                throw new MavenReportException("The tags parameter is required when type=\"tag\".");
            }
        } else {
            throw new MavenReportException("The type parameter has an invalid value: " + this.type + ".  The value should be \"range\", \"date\", or \"tag\".");
        }
    }

    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.changelog.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.changelog.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void doGenerateReport(List changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.changelog.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.changelog.mainTitle"));
        sink.sectionTitle1_();
        this.doSummarySection(changeLogSets, bundle, sink);
        Iterator sets = changeLogSets.iterator();
        while (sets.hasNext()) {
            ChangeLogSet changeLogSet = (ChangeLogSet)sets.next();
            this.doChangedSet(changeLogSet, bundle, sink);
        }
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void doSummarySection(List changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.paragraph();
        sink.text(bundle.getString("report.changelog.ChangedSetsTotal"));
        sink.text(": " + changeLogSets.size());
        sink.paragraph_();
    }

    private void doChangedSet(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section1();
        this.doChangeSetTitle(set, bundle, sink);
        this.doSummary(set, bundle, sink);
        this.doChangedSetTable(set.getChangeSets(), bundle, sink);
        sink.section1_();
    }

    protected void doChangeSetTitle(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.sectionTitle2();
        SimpleDateFormat headingDateFormater = new SimpleDateFormat(this.headingDateFormat);
        if ("tag".equals(this.type)) {
            if (set.getStartVersion() == null || set.getStartVersion().getName() == null) {
                sink.text(bundle.getString("report.SetTagCreation"));
            } else if (set.getEndVersion() == null || set.getEndVersion().getName() == null) {
                sink.text(bundle.getString("report.SetTagSince"));
                sink.text(" '" + set.getStartVersion() + "'");
            } else {
                sink.text(bundle.getString("report.SetTagBetween"));
                sink.text(" '" + set.getStartVersion() + "' " + bundle.getString("report.And") + " '" + set.getEndVersion() + "'");
            }
        } else if (set.getStartDate() == null) {
            sink.text(bundle.getString("report.SetRangeUnknown"));
        } else if (set.getEndDate() == null) {
            sink.text(bundle.getString("report.SetRangeSince"));
            sink.text(" " + headingDateFormater.format(set.getStartDate()));
        } else {
            sink.text(bundle.getString("report.SetRangeBetween"));
            sink.text(" " + headingDateFormater.format(set.getStartDate()) + " " + bundle.getString("report.And") + " " + headingDateFormater.format(set.getEndDate()));
        }
        sink.sectionTitle2_();
    }

    protected void doSummary(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.paragraph();
        sink.text(bundle.getString("report.TotalCommits"));
        sink.text(": " + set.getChangeSets().size());
        sink.lineBreak();
        sink.text(bundle.getString("report.changelog.FilesChanged"));
        sink.text(": " + this.countFilesChanged(set.getChangeSets()));
        sink.paragraph_();
    }

    protected long countFilesChanged(Collection entries) {
        if (entries == null) {
            return 0L;
        }
        if (entries.isEmpty()) {
            return 0L;
        }
        HashMap<String, LinkedList> fileList = new HashMap<String, LinkedList>();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ChangeSet entry = (ChangeSet)i.next();
            List files = entry.getFiles();
            Iterator fileIterator = files.iterator();
            while (fileIterator.hasNext()) {
                LinkedList list;
                ChangeFile file = (ChangeFile)fileIterator.next();
                String name = file.getName();
                if (fileList.containsKey(name)) {
                    list = (LinkedList)fileList.get(name);
                    list.add(file);
                    continue;
                }
                list = new LinkedList();
                list.add(file);
                fileList.put(name, list);
            }
        }
        return fileList.size();
    }

    private void doChangedSetTable(Collection entries, ResourceBundle bundle, Sink sink) {
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.timestamp"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.author"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.details"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.initReportUrls();
        ArrayList sortedEntries = new ArrayList(entries);
        Collections.sort(sortedEntries, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ChangeSet changeSet0 = (ChangeSet)arg0;
                ChangeSet changeSet1 = (ChangeSet)arg1;
                return changeSet1.getDate().compareTo(changeSet0.getDate());
            }
        });
        Iterator i = sortedEntries.iterator();
        while (i.hasNext()) {
            ChangeSet entry = (ChangeSet)i.next();
            this.doChangedSetDetail(entry, bundle, sink);
        }
        sink.table_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doChangedSetDetail(ChangeSet entry, ResourceBundle bundle, Sink sink) {
        block16: {
            BufferedReader br;
            StringReader sr;
            block14: {
                sink.tableRow();
                sink.tableCell();
                sink.text(entry.getDateFormatted() + " " + entry.getTimeFormatted());
                sink.tableCell_();
                sink.tableCell();
                sink.text(entry.getAuthor());
                sink.tableCell_();
                sink.tableCell();
                this.doChangedFiles(entry.getFiles(), sink);
                sink.lineBreak();
                sr = new StringReader(entry.getComment());
                br = new BufferedReader(sr);
                String line = br.readLine();
                while (line != null) {
                    sink.text(line);
                    line = br.readLine();
                    if (line == null) continue;
                    sink.lineBreak();
                }
                Object var9_7 = null;
                if (br == null) break block14;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    this.getLog().warn((CharSequence)"Unable to close a reader.");
                }
            }
            if (sr != null) {
                sr.close();
            }
            break block16;
            {
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Unable to read the comment of a ChangeSet as a stream.");
                    Object var9_8 = null;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            this.getLog().warn((CharSequence)"Unable to close a reader.");
                        }
                    }
                    if (sr != null) {
                        sr.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        this.getLog().warn((CharSequence)"Unable to close a reader.");
                    }
                }
                if (sr != null) {
                    sr.close();
                }
                throw throwable;
            }
        }
        sink.tableCell_();
        sink.tableRow_();
    }

    protected void initReportUrls() {
        if (this.scmUrl != null) {
            int idx = this.scmUrl.indexOf(63);
            if (idx > 0) {
                this.rptRepository = this.scmUrl.substring(0, idx);
                if (this.scmUrl.equals(this.displayFileDetailUrl)) {
                    String rptTmpMultiRepoParam = this.scmUrl.substring(this.rptRepository.length());
                    this.rptOneRepoParam = "?" + rptTmpMultiRepoParam.substring(1);
                    this.rptMultiRepoParam = "&" + rptTmpMultiRepoParam.substring(1);
                }
            } else {
                this.rptRepository = this.scmUrl;
                this.rptOneRepoParam = "";
                this.rptMultiRepoParam = "";
            }
        }
    }

    private void doChangedFiles(List files, Sink sink) {
        Iterator i = files.iterator();
        while (i.hasNext()) {
            ChangeFile file = (ChangeFile)i.next();
            this.sinkLogFile(sink, file.getName(), file.getRevision());
        }
    }

    private void sinkLogFile(Sink sink, String name, String revision) {
        try {
            String connection = this.getConnection();
            this.generateLinks(connection, name, revision, sink);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            sink.text(name + " v " + revision);
        }
        sink.lineBreak();
    }

    protected void generateLinks(String connection, String name, Sink sink) {
        this.generateLinks(connection, name, null, sink);
    }

    protected void generateLinks(String connection, String name, String revision, Sink sink) {
        String linkFile = null;
        String linkRev = null;
        if (this.displayFileDetailUrl != null) {
            if (!this.scmUrl.equals(this.displayFileDetailUrl)) {
                linkFile = this.displayFileDetailUrl.indexOf(FILE_TOKEN) > 0 ? this.displayFileDetailUrl.replaceAll(FILE_TOKEN, name) : this.displayFileDetailUrl + name;
            } else if (connection.startsWith("scm:perforce")) {
                String path = this.getAbsolutePath(this.displayFileDetailUrl, name);
                linkFile = path + "?ac=22";
                if (revision != null) {
                    linkRev = path + "?ac=64&rev=" + revision;
                }
            } else if (connection.startsWith("scm:clearcase")) {
                String path = this.getAbsolutePath(this.displayFileDetailUrl, name);
                linkFile = path + this.rptOneRepoParam;
            } else if (connection.indexOf("cvsmonitor.pl") > 0) {
                String module = this.rptOneRepoParam.replaceAll("^.*(&amp;module=.*?(?:&amp;|$)).*$", "$1");
                linkFile = this.displayFileDetailUrl + "?cmd=viewBrowseFile" + module + "&file=" + name;
                if (revision != null) {
                    linkRev = this.rptRepository + "?cmd=viewBrowseVersion" + module + "&file=" + name + "&version=" + revision;
                }
            } else {
                String path = this.getAbsolutePath(this.displayFileDetailUrl, name);
                linkFile = path + this.rptOneRepoParam;
                if (revision != null) {
                    linkRev = path + "?rev=" + revision + "&content-type=text/vnd.viewcvs-markup" + this.rptMultiRepoParam;
                }
            }
        }
        if (linkFile != null) {
            sink.link(linkFile);
            this.sinkFileName(name, sink);
            sink.link_();
        } else {
            this.sinkFileName(name, sink);
        }
        sink.text(" ");
        if (linkRev != null) {
            sink.link(linkRev);
            sink.text("v " + revision);
            sink.link_();
        } else if (revision != null) {
            sink.text("v " + revision);
        }
    }

    private void sinkFileName(String name, Sink sink) {
        String tail;
        String head;
        int pos = (name = name.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (pos < 0) {
            head = "";
            tail = name;
        } else {
            head = name.substring(0, pos) + "/";
            tail = name.substring(pos + 1);
        }
        sink.text(head);
        sink.bold();
        sink.text(tail);
        sink.bold_();
    }

    private String getAbsolutePath(String base, String target) {
        String newTarget;
        String baseToken;
        String absPath = "";
        StringTokenizer baseTokens = new StringTokenizer(base.replaceAll("\\\\", "/"), "/", true);
        StringTokenizer targetTokens = new StringTokenizer(target.replaceAll("\\\\", "/"), "/");
        String targetRoot = targetTokens.nextToken();
        while (baseTokens.hasMoreTokens() && !(baseToken = baseTokens.nextToken()).equals(targetRoot)) {
            absPath = absPath + baseToken;
        }
        if (!absPath.endsWith("/")) {
            absPath = absPath + "/";
        }
        if ((newTarget = target).startsWith("/")) {
            newTarget = newTarget.substring(1);
        }
        return absPath + newTarget;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return "Generated change log report from SCM.";
    }

    public String getName(Locale locale) {
        return "Change Log";
    }

    public String getOutputName() {
        return "changelog";
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scm-activity", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean canGenerateReport() {
        return !this.offline || this.outputXML.exists();
    }
}

