/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleSet;

public class Assembly
implements Serializable {
    private String id;
    private List<String> formats;
    private boolean includeBaseDirectory = true;
    private String baseDirectory;
    private boolean includeSiteDirectory = false;
    private List<ContainerDescriptorHandlerConfig> containerDescriptorHandlers;
    private List<ModuleSet> moduleSets;
    private List<FileSet> fileSets;
    private List<FileItem> files;
    private List<DependencySet> dependencySets;
    private List<String> componentDescriptors;
    private String modelEncoding = "UTF-8";

    public void addComponentDescriptor(String string) {
        this.getComponentDescriptors().add(string);
    }

    public void addContainerDescriptorHandler(ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig) {
        this.getContainerDescriptorHandlers().add(containerDescriptorHandlerConfig);
    }

    public void addDependencySet(DependencySet dependencySet) {
        this.getDependencySets().add(dependencySet);
    }

    public void addFile(FileItem fileItem) {
        this.getFiles().add(fileItem);
    }

    public void addFileSet(FileSet fileSet) {
        this.getFileSets().add(fileSet);
    }

    public void addFormat(String string) {
        this.getFormats().add(string);
    }

    public void addModuleSet(ModuleSet moduleSet) {
        this.getModuleSets().add(moduleSet);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public List<String> getComponentDescriptors() {
        if (this.componentDescriptors == null) {
            this.componentDescriptors = new ArrayList<String>();
        }
        return this.componentDescriptors;
    }

    public List<ContainerDescriptorHandlerConfig> getContainerDescriptorHandlers() {
        if (this.containerDescriptorHandlers == null) {
            this.containerDescriptorHandlers = new ArrayList<ContainerDescriptorHandlerConfig>();
        }
        return this.containerDescriptorHandlers;
    }

    public List<DependencySet> getDependencySets() {
        if (this.dependencySets == null) {
            this.dependencySets = new ArrayList<DependencySet>();
        }
        return this.dependencySets;
    }

    public List<FileSet> getFileSets() {
        if (this.fileSets == null) {
            this.fileSets = new ArrayList<FileSet>();
        }
        return this.fileSets;
    }

    public List<FileItem> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<FileItem>();
        }
        return this.files;
    }

    public List<String> getFormats() {
        if (this.formats == null) {
            this.formats = new ArrayList<String>();
        }
        return this.formats;
    }

    public String getId() {
        return this.id;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public List<ModuleSet> getModuleSets() {
        if (this.moduleSets == null) {
            this.moduleSets = new ArrayList<ModuleSet>();
        }
        return this.moduleSets;
    }

    public boolean isIncludeBaseDirectory() {
        return this.includeBaseDirectory;
    }

    public boolean isIncludeSiteDirectory() {
        return this.includeSiteDirectory;
    }

    public void removeComponentDescriptor(String string) {
        this.getComponentDescriptors().remove(string);
    }

    public void removeContainerDescriptorHandler(ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig) {
        this.getContainerDescriptorHandlers().remove(containerDescriptorHandlerConfig);
    }

    public void removeDependencySet(DependencySet dependencySet) {
        this.getDependencySets().remove(dependencySet);
    }

    public void removeFile(FileItem fileItem) {
        this.getFiles().remove(fileItem);
    }

    public void removeFileSet(FileSet fileSet) {
        this.getFileSets().remove(fileSet);
    }

    public void removeFormat(String string) {
        this.getFormats().remove(string);
    }

    public void removeModuleSet(ModuleSet moduleSet) {
        this.getModuleSets().remove(moduleSet);
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setComponentDescriptors(List<String> componentDescriptors) {
        this.componentDescriptors = componentDescriptors;
    }

    public void setContainerDescriptorHandlers(List<ContainerDescriptorHandlerConfig> containerDescriptorHandlers) {
        this.containerDescriptorHandlers = containerDescriptorHandlers;
    }

    public void setDependencySets(List<DependencySet> dependencySets) {
        this.dependencySets = dependencySets;
    }

    public void setFileSets(List<FileSet> fileSets) {
        this.fileSets = fileSets;
    }

    public void setFiles(List<FileItem> files) {
        this.files = files;
    }

    public void setFormats(List<String> formats) {
        this.formats = formats;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIncludeBaseDirectory(boolean includeBaseDirectory) {
        this.includeBaseDirectory = includeBaseDirectory;
    }

    public void setIncludeSiteDirectory(boolean includeSiteDirectory) {
        this.includeSiteDirectory = includeSiteDirectory;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setModuleSets(List<ModuleSet> moduleSets) {
        this.moduleSets = moduleSets;
    }
}

