/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.LineEndings;
import org.apache.maven.plugin.assembly.utils.LinuxLineFeedInputStream;
import org.apache.maven.plugin.assembly.utils.WindowsLineFeedInputStream;
import org.codehaus.plexus.util.IOUtil;

public final class LineEndingsUtils {
    private LineEndingsUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void convertLineEndings(@Nonnull File source, @Nonnull File dest, LineEndings lineEndings, Boolean atEndOfFile, String encoding) throws IOException {
        eofChars = "";
        if (atEndOfFile == null) {
            raf = null;
            try {
                if (source.length() < 1L) ** GOTO lbl21
                raf = new RandomAccessFile(source, "r");
                raf.seek(source.length() - 1L);
                last = raf.readByte();
                if (last != 10) ** GOTO lbl21
                eofChars = lineEndings.getLineEndingCharacters();
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex) {}
                }
            }
        } else if (atEndOfFile.booleanValue()) {
            eofChars = lineEndings.getLineEndingCharacters();
        }
lbl21:
        // 6 sources

        in = null;
        out = null;
        try {
            if (encoding == null) {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(source)));
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dest)));
            } else {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), encoding));
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), encoding));
            }
            line = in.readLine();
            while (line != null) {
                out.write(line);
                line = in.readLine();
                if (line != null) {
                    out.write(lineEndings.getLineEndingCharacters());
                    continue;
                }
                out.write(eofChars);
            }
            out.flush();
        }
        catch (Throwable var10_13) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw var10_13;
        }
        IOUtil.close((Reader)in);
        IOUtil.close((Writer)out);
    }

    public static InputStream lineEndingConverter(@Nonnull InputStream in, LineEndings lineEndings) throws IOException {
        return lineEndings.isNewLine() ? new LinuxLineFeedInputStream(in, false) : (lineEndings.isCrLF() ? new WindowsLineFeedInputStream(in, false) : in);
    }

    public static LineEndings getLineEnding(@Nullable String lineEnding) throws AssemblyFormattingException {
        LineEndings result = LineEndings.keep;
        if (lineEnding != null) {
            try {
                result = LineEndings.valueOf(lineEnding);
            }
            catch (IllegalArgumentException e) {
                throw new AssemblyFormattingException("Illegal lineEnding specified: '" + lineEnding + "'", e);
            }
        }
        return result;
    }

    @Nullable
    public static String getLineEndingCharacters(@Nullable String lineEnding) throws AssemblyFormattingException {
        String value = lineEnding;
        if (lineEnding != null) {
            try {
                value = LineEndings.valueOf(lineEnding).getLineEndingCharacters();
            }
            catch (IllegalArgumentException e) {
                throw new AssemblyFormattingException("Illegal lineEnding specified: '" + lineEnding + "'", e);
            }
        }
        return value;
    }
}

