/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class FileFormatter {
    private final Logger logger;
    private final AssemblerConfigurationSource configSource;

    public FileFormatter(AssemblerConfigurationSource configSource, Logger logger) {
        this.configSource = configSource;
        this.logger = logger;
    }

    public File format(File source, boolean filter, String lineEnding, String encoding) throws AssemblyFormattingException {
        return this.format(source, filter, lineEnding, this.configSource.getTemporaryRootDirectory(), encoding);
    }

    public File format(File source, boolean filter, String lineEnding, File tempRoot, String encoding) throws AssemblyFormattingException {
        String lineEndingChars;
        AssemblyFileUtils.verifyTempDirectoryAvailability(tempRoot, this.logger);
        File result = source;
        if (StringUtils.isEmpty((String)encoding) && filter) {
            this.logger.warn("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!");
        }
        if (filter) {
            result = this.doFileFilter(source, tempRoot, encoding);
        }
        if ((lineEndingChars = AssemblyFileUtils.getLineEndingCharacters(lineEnding)) != null) {
            result = this.formatLineEndings(lineEndingChars, result, tempRoot);
        }
        return result;
    }

    private File doFileFilter(File source, File tempRoot, String encoding) throws AssemblyFormattingException {
        try {
            File target = FileUtils.createTempFile((String)(source.getName() + "."), (String)".filtered", (File)tempRoot);
            boolean isPropertiesFile = source.getName().toLowerCase(Locale.ENGLISH).endsWith(".properties");
            this.configSource.getMavenFileFilter().copyFile(source, target, true, this.configSource.getProject(), this.configSource.getFilters(), isPropertiesFile, encoding, this.configSource.getMavenSession());
            return target;
        }
        catch (MavenFilteringException e) {
            throw new AssemblyFormattingException("Error filtering file '" + source + "': " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File formatLineEndings(String lineEndingChars, File source, File tempRoot) throws AssemblyFormattingException {
        File file;
        FileReader contentReader = null;
        try {
            contentReader = new FileReader(source);
            File target = FileUtils.createTempFile((String)(source.getName() + "."), (String)".formatted", (File)tempRoot);
            AssemblyFileUtils.convertLineEndings(contentReader, target, lineEndingChars);
            file = target;
        }
        catch (FileNotFoundException e) {
            try {
                throw new AssemblyFormattingException("File to filter not found: " + e.getMessage(), e);
                catch (IOException e2) {
                    throw new AssemblyFormattingException("Error line formatting file '" + source + "': " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(contentReader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)contentReader);
        return file;
    }
}

