/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.EnhancedParameterWrapper;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.javadoc.JavadocLinkGenerator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.CachingOutputStream;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginXdocGenerator
implements Generator {
    private static final Pattern HTML_LINK_PATTERN = Pattern.compile("<a href=\\\"([^\\\"]*)\\\">(.*?)</a>");
    private static final Logger LOG = LoggerFactory.getLogger(PluginXdocGenerator.class);
    private final Locale locale;
    private final MavenProject project;
    private final File reportOutputDirectory;
    private final boolean disableInternalJavadocLinkValidation;

    public PluginXdocGenerator() {
        this(null);
    }

    public PluginXdocGenerator(MavenProject project) {
        this(project, Locale.ENGLISH, new File("").getAbsoluteFile(), false);
    }

    public PluginXdocGenerator(MavenProject project, Locale locale, File reportOutputDirectory, boolean disableInternalJavadocLinkValidation) {
        this.project = project;
        this.locale = locale == null ? Locale.ENGLISH : locale;
        this.reportOutputDirectory = reportOutputDirectory;
        this.disableInternalJavadocLinkValidation = disableInternalJavadocLinkValidation;
    }

    @Override
    public void execute(File destinationDirectory, PluginToolsRequest request) throws GeneratorException {
        try {
            if (request.getPluginDescriptor().getMojos() != null) {
                List mojos = request.getPluginDescriptor().getMojos();
                for (MojoDescriptor descriptor : mojos) {
                    this.processMojoDescriptor(descriptor, destinationDirectory);
                }
            }
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, File destinationDirectory) throws IOException {
        File outputFile = new File(destinationDirectory, this.getMojoFilename(mojoDescriptor, "xml"));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new CachingOutputStream(outputFile), StandardCharsets.UTF_8);){
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter(new PrintWriter(writer), StandardCharsets.UTF_8.name(), null);
            this.writeBody(mojoDescriptor, (XMLWriter)w);
            ((Writer)writer).flush();
        }
    }

    private String getMojoFilename(MojoDescriptor mojo, String ext) {
        return mojo.getGoal() + "-mojo." + ext;
    }

    private void writeBody(MojoDescriptor mojoDescriptor, XMLWriter w) {
        w.startElement("document");
        w.addAttribute("xmlns", "http://maven.apache.org/XDOC/2.0");
        w.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        w.addAttribute("xsi:schemaLocation", "http://maven.apache.org/XDOC/2.0 http://maven.apache.org/xsd/xdoc-2.0.xsd");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(mojoDescriptor.getFullGoalName());
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", mojoDescriptor.getFullGoalName());
        this.writeReportNotice(mojoDescriptor, w);
        w.startElement("p");
        w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.fullname"));
        w.endElement();
        w.startElement("p");
        w.writeMarkup(mojoDescriptor.getPluginDescriptor().getGroupId() + ":" + mojoDescriptor.getPluginDescriptor().getArtifactId() + ":" + mojoDescriptor.getPluginDescriptor().getVersion() + ":" + mojoDescriptor.getGoal());
        w.endElement();
        String context = "goal " + mojoDescriptor.getGoal();
        if (StringUtils.isNotEmpty((String)mojoDescriptor.getDeprecated())) {
            w.startElement("p");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.deprecated"));
            w.endElement();
            w.startElement("div");
            w.writeMarkup(this.getXhtmlWithValidatedLinks(mojoDescriptor.getDeprecated(), context));
            w.endElement();
        }
        w.startElement("p");
        w.writeMarkup(this.getString("pluginxdoc.description"));
        w.endElement();
        w.startElement("div");
        if (StringUtils.isNotEmpty((String)mojoDescriptor.getDescription())) {
            w.writeMarkup(this.getXhtmlWithValidatedLinks(mojoDescriptor.getDescription(), context));
        } else {
            w.writeText(this.getString("pluginxdoc.nodescription"));
        }
        w.endElement();
        this.writeGoalAttributes(mojoDescriptor, w);
        this.writeGoalParameterTable(mojoDescriptor, w);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeReportNotice(MojoDescriptor mojoDescriptor, XMLWriter w) {
        if (GeneratorUtils.isMavenReport(mojoDescriptor.getImplementation(), this.project)) {
            w.startElement("p");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.notice.note"));
            w.writeText(this.getString("pluginxdoc.mojodescriptor.notice.isMavenReport"));
            w.endElement();
        }
    }

    private void writeGoalAttributes(MojoDescriptor mojoDescriptor, XMLWriter w) {
        ExtendedMojoDescriptor extendedMojoDescriptor;
        String value;
        w.startElement("p");
        w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.attributes"));
        w.endElement();
        boolean addedUl = false;
        if (mojoDescriptor.isProjectRequired()) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.projectRequired"));
            w.endElement();
        }
        if (mojoDescriptor.isRequiresReports()) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.reportingMojo"));
            w.endElement();
        }
        if (mojoDescriptor.isAggregator()) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.aggregator"));
            w.endElement();
        }
        if (mojoDescriptor.isDirectInvocationOnly()) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.directInvocationOnly"));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.isDependencyResolutionRequired()))) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.dependencyResolutionRequired", value));
            w.endElement();
        }
        if (mojoDescriptor instanceof ExtendedMojoDescriptor && StringUtils.isNotEmpty((String)(value = (extendedMojoDescriptor = (ExtendedMojoDescriptor)mojoDescriptor).getDependencyCollectionRequired()))) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.dependencyCollectionRequired", value));
            w.endElement();
        }
        addedUl = this.addUl(w, addedUl);
        w.startElement("li");
        w.writeMarkup(this.getString(mojoDescriptor.isThreadSafe() ? "pluginxdoc.mojodescriptor.threadSafe" : "pluginxdoc.mojodescriptor.notThreadSafe"));
        w.endElement();
        value = mojoDescriptor.getSince();
        if (StringUtils.isNotEmpty((String)value)) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.since", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getPhase()))) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.phase", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecutePhase()))) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.executePhase", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteGoal()))) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.executeGoal", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteLifecycle()))) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.executeLifecycle", value));
            w.endElement();
        }
        if (mojoDescriptor.isOnlineRequired()) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.onlineRequired"));
            w.endElement();
        }
        if (!mojoDescriptor.isInheritedByDefault()) {
            addedUl = this.addUl(w, addedUl);
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.inheritedByDefault"));
            w.endElement();
        }
        if (addedUl) {
            w.endElement();
        }
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, XMLWriter w) {
        List parameterList = mojoDescriptor.getParameters();
        List<Parameter> list = this.filterParameters(parameterList);
        if (!list.isEmpty()) {
            this.writeParameterSummary(list, w, mojoDescriptor.getGoal());
            this.writeParameterDetails(list, w, mojoDescriptor.getGoal());
        } else {
            w.startElement("subsection");
            w.addAttribute("name", this.getString("pluginxdoc.mojodescriptor.parameters"));
            w.startElement("p");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.noParameter"));
            w.endElement();
            w.endElement();
        }
    }

    private List<Parameter> filterParameters(List<Parameter> parameterList) {
        ArrayList<Parameter> filtered = new ArrayList<Parameter>();
        if (parameterList != null) {
            for (Parameter parameter : parameterList) {
                String expression;
                if (!parameter.isEditable() || (expression = parameter.getExpression()) != null && expression.startsWith("${component.")) continue;
                filtered.add(parameter);
            }
        }
        return filtered;
    }

    private void writeParameterDetails(List<Parameter> parameterList, XMLWriter w, String goal) {
        w.startElement("subsection");
        w.addAttribute("name", this.getString("pluginxdoc.mojodescriptor.parameter.details"));
        Iterator<Parameter> parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = parameters.next();
            w.startElement("h4");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.name_internal", parameter.getName()));
            w.endElement();
            String context = "Parameter " + parameter.getName() + " in goal " + goal;
            if (StringUtils.isNotEmpty((String)parameter.getDeprecated())) {
                w.startElement("div");
                String deprecated = this.getXhtmlWithValidatedLinks(parameter.getDeprecated(), context);
                w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.deprecated", deprecated));
                w.endElement();
            }
            w.startElement("div");
            if (StringUtils.isNotEmpty((String)parameter.getDescription())) {
                w.writeMarkup(this.getXhtmlWithValidatedLinks(parameter.getDescription(), context));
            } else {
                w.writeMarkup(this.getString("pluginxdoc.nodescription"));
            }
            w.endElement();
            boolean addedUl = false;
            addedUl = this.addUl(w, addedUl, parameter.getType());
            String typeValue = this.getLinkedType(parameter, false);
            this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.type"), typeValue, w);
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                addedUl = this.addUl(w, addedUl);
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.since"), parameter.getSince(), w);
            }
            if (parameter.isRequired()) {
                addedUl = this.addUl(w, addedUl);
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.required"), this.getString("pluginxdoc.yes"), w);
            } else {
                addedUl = this.addUl(w, addedUl);
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.required"), this.getString("pluginxdoc.no"), w);
            }
            String expression = parameter.getExpression();
            addedUl = this.addUl(w, addedUl, expression);
            String property = this.getPropertyFromExpression(expression);
            if (property == null) {
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.expression"), expression, w);
            } else {
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.property"), property, w);
            }
            addedUl = this.addUl(w, addedUl, parameter.getDefaultValue());
            this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.default"), this.escapeXml(parameter.getDefaultValue()), w);
            addedUl = this.addUl(w, addedUl, parameter.getAlias());
            this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.alias"), this.escapeXml(parameter.getAlias()), w);
            if (addedUl) {
                w.endElement();
            }
            if (!parameters.hasNext()) continue;
            w.writeMarkup("<hr/>");
        }
        w.endElement();
    }

    static String getShortType(String type) {
        int startTypeArguments = type.indexOf(60);
        if (startTypeArguments == -1) {
            return PluginXdocGenerator.getShortTypeOfSimpleType(type);
        }
        StringBuilder shortType = new StringBuilder();
        shortType.append(PluginXdocGenerator.getShortTypeOfSimpleType(type.substring(0, startTypeArguments)));
        shortType.append("<").append(PluginXdocGenerator.getShortTypeOfTypeArgument(type.substring(startTypeArguments + 1, type.lastIndexOf(">")))).append(">");
        return shortType.toString();
    }

    private static String getShortTypeOfTypeArgument(String type) {
        String[] typeArguments = type.split(",\\s*");
        StringBuilder shortType = new StringBuilder();
        for (int i = 0; i < typeArguments.length; ++i) {
            String typeArgument = typeArguments[i];
            if (typeArgument.contains("<")) {
                return "...";
            }
            shortType.append(PluginXdocGenerator.getShortTypeOfSimpleType(typeArgument));
            if (i >= typeArguments.length - 1) continue;
            shortType.append(",");
        }
        return shortType.toString();
    }

    private static String getShortTypeOfSimpleType(String type) {
        int index = type.lastIndexOf(46);
        return type.substring(index + 1);
    }

    private String getLinkedType(Parameter parameter, boolean isShortType) {
        URI javadocUrl;
        EnhancedParameterWrapper enhancedParameter;
        String typeValue = isShortType ? PluginXdocGenerator.getShortType(parameter.getType()) : parameter.getType();
        if (parameter instanceof EnhancedParameterWrapper && (enhancedParameter = (EnhancedParameterWrapper)parameter).getTypeJavadocUrl() != null && ((javadocUrl = enhancedParameter.getTypeJavadocUrl()).isAbsolute() || this.disableInternalJavadocLinkValidation || JavadocLinkGenerator.isLinkValid((URI)javadocUrl, (Path)this.reportOutputDirectory.toPath()))) {
            return this.format("pluginxdoc.mojodescriptor.parameter.type_link", new Object[]{this.escapeXml(typeValue), enhancedParameter.getTypeJavadocUrl()});
        }
        return this.escapeXml(typeValue);
    }

    private boolean addUl(XMLWriter w, boolean addedUl, String content) {
        if (StringUtils.isNotEmpty((String)content)) {
            return this.addUl(w, addedUl);
        }
        return addedUl;
    }

    private boolean addUl(XMLWriter w, boolean addedUl) {
        if (!addedUl) {
            w.startElement("ul");
            addedUl = true;
        }
        return addedUl;
    }

    private String getPropertyFromExpression(String expression) {
        if (StringUtils.isNotEmpty((String)expression) && expression.startsWith("${") && expression.endsWith("}") && !expression.substring(2).contains("${")) {
            return expression.substring(2, expression.length() - 1);
        }
        return null;
    }

    private void writeDetail(String param, String value, XMLWriter w) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.detail", new String[]{param, value}));
            w.endElement();
        }
    }

    private void writeParameterSummary(List<Parameter> parameterList, XMLWriter w, String goal) {
        List<Parameter> optionalParams;
        List<Parameter> requiredParams = this.getParametersByRequired(true, parameterList);
        if (!requiredParams.isEmpty()) {
            this.writeParameterList(this.getString("pluginxdoc.mojodescriptor.requiredParameters"), requiredParams, w, goal);
        }
        if (!(optionalParams = this.getParametersByRequired(false, parameterList)).isEmpty()) {
            this.writeParameterList(this.getString("pluginxdoc.mojodescriptor.optionalParameters"), optionalParams, w, goal);
        }
    }

    private void writeParameterList(String title, List<Parameter> parameterList, XMLWriter w, String goal) {
        w.startElement("subsection");
        w.addAttribute("name", title);
        w.startElement("table");
        w.addAttribute("border", "0");
        w.startElement("tr");
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.name"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.type"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.since"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.description"));
        w.endElement();
        w.endElement();
        for (Parameter parameter : parameterList) {
            String property;
            String description;
            w.startElement("tr");
            w.startElement("td");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.name_link", parameter.getName()));
            w.endElement();
            w.startElement("td");
            w.writeMarkup("<code>" + this.getLinkedType(parameter, true) + "</code>");
            w.endElement();
            w.startElement("td");
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                w.writeMarkup("<code>" + parameter.getSince() + "</code>");
            } else {
                w.writeMarkup("<code>-</code>");
            }
            w.endElement();
            w.startElement("td");
            String context = "Parameter " + parameter.getName() + " in goal " + goal;
            if (StringUtils.isNotEmpty((String)parameter.getDeprecated())) {
                String deprecated = this.getXhtmlWithValidatedLinks(parameter.getDescription(), context);
                description = this.format("pluginxdoc.mojodescriptor.parameter.deprecated", deprecated);
            } else {
                description = StringUtils.isNotEmpty((String)parameter.getDescription()) ? this.getXhtmlWithValidatedLinks(parameter.getDescription(), context) : this.getString("pluginxdoc.nodescription");
            }
            w.writeMarkup(description + "<br/>");
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.defaultValue", this.escapeXml(parameter.getDefaultValue())));
                w.writeMarkup("<br/>");
            }
            if ((property = this.getPropertyFromExpression(parameter.getExpression())) != null) {
                w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.property.description", property));
                w.writeMarkup("<br/>");
            }
            if (StringUtils.isNotEmpty((String)parameter.getAlias())) {
                w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.alias.description", this.escapeXml(parameter.getAlias())));
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
        w.endElement();
    }

    private List<Parameter> getParametersByRequired(boolean required, List<Parameter> parameterList) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter parameter : parameterList) {
            if (parameter.isRequired() != required) continue;
            list.add(parameter);
        }
        return list;
    }

    private ResourceBundle getBundle() {
        return ResourceBundle.getBundle("pluginxdoc", this.locale, this.getClass().getClassLoader());
    }

    private String getString(String key) {
        return this.getBundle().getString(key);
    }

    private String format(String key, Object arg1) {
        return this.format(key, new Object[]{arg1});
    }

    private String format(String key, Object[] args) {
        String pattern = this.getString(key);
        pattern = StringUtils.replace((String)pattern, (String)"'", (String)"''");
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.locale);
        messageFormat.applyPattern(pattern);
        return messageFormat.format(args);
    }

    private String escapeXml(String text) {
        if (text != null) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("\"", "&quot;");
            text = text.replace("'", "&apos;");
        }
        return text;
    }

    String getXhtmlWithValidatedLinks(String xhtmlText, String context) {
        if (this.disableInternalJavadocLinkValidation) {
            return xhtmlText;
        }
        StringBuffer sanitizedXhtmlText = new StringBuffer();
        Matcher matcher = HTML_LINK_PATTERN.matcher(xhtmlText);
        while (matcher.find()) {
            try {
                URI link = new URI(matcher.group(1));
                if (!link.isAbsolute() && !JavadocLinkGenerator.isLinkValid((URI)link, (Path)this.reportOutputDirectory.toPath())) {
                    matcher.appendReplacement(sanitizedXhtmlText, matcher.group(2));
                    LOG.debug("Removed invalid link {} in {}", (Object)link, (Object)context);
                    continue;
                }
                matcher.appendReplacement(sanitizedXhtmlText, matcher.group(0));
            }
            catch (URISyntaxException e) {
                LOG.warn("Invalid URI {} found in {}. Cannot validate, leave untouched", (Object)matcher.group(1), (Object)context);
                matcher.appendReplacement(sanitizedXhtmlText, matcher.group(0));
            }
        }
        matcher.appendTail(sanitizedXhtmlText);
        return sanitizedXhtmlText.toString();
    }
}

