/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.descriptor.DuplicateMojoDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.Requirement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;

public class PluginDescriptorGenerator
implements Generator {
    public void execute(File destinationDirectory, PluginToolsRequest request) throws GeneratorException {
        String helpMojoImplementation;
        Properties properties;
        String helpPackageName;
        File tmpPropertiesFile = new File(request.getProject().getBuild().getDirectory(), "maven-plugin-help.properties");
        if (tmpPropertiesFile.exists() && StringUtils.isEmpty((String)(helpPackageName = (properties = PropertyUtils.loadProperties((File)tmpPropertiesFile)).getProperty("helpPackageName"))) && (helpMojoImplementation = this.rewriteHelpClassToMojoPackage(request)) != null) {
            this.rewriteDescriptor(request.getPluginDescriptor(), helpMojoImplementation);
        }
        try {
            File f = new File(destinationDirectory, "plugin.xml");
            this.writeDescriptor(f, request, false);
            MavenProject mavenProject = request.getProject();
            String pluginHelpFilePath = "META-INF/maven/" + mavenProject.getGroupId() + "/" + mavenProject.getArtifactId() + "/plugin-help.xml";
            f = new File(request.getProject().getBuild().getOutputDirectory(), pluginHelpFilePath);
            this.writeDescriptor(f, request, true);
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
        catch (DuplicateMojoDescriptorException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    private String getVersion() {
        Package p = this.getClass().getPackage();
        String version = p == null ? null : p.getSpecificationVersion();
        return version == null ? "SNAPSHOT" : version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDescriptor(File destinationFile, PluginToolsRequest request, boolean helpDescriptor) throws IOException, DuplicateMojoDescriptorException {
        PluginDescriptor pluginDescriptor = request.getPluginDescriptor();
        if (destinationFile.exists()) {
            destinationFile.delete();
        } else if (!destinationFile.getParentFile().exists()) {
            destinationFile.getParentFile().mkdirs();
        }
        String encoding = "UTF-8";
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(destinationFile), encoding);
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer, encoding, null);
            w.writeMarkup("\n<!-- Generated by maven-plugin-tools " + this.getVersion() + " on " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + " -->\n\n");
            w.startElement("plugin");
            GeneratorUtils.element((XMLWriter)w, "name", pluginDescriptor.getName());
            GeneratorUtils.element((XMLWriter)w, "description", pluginDescriptor.getDescription(), helpDescriptor);
            GeneratorUtils.element((XMLWriter)w, "groupId", pluginDescriptor.getGroupId());
            GeneratorUtils.element((XMLWriter)w, "artifactId", pluginDescriptor.getArtifactId());
            GeneratorUtils.element((XMLWriter)w, "version", pluginDescriptor.getVersion());
            GeneratorUtils.element((XMLWriter)w, "goalPrefix", pluginDescriptor.getGoalPrefix());
            if (!helpDescriptor) {
                GeneratorUtils.element((XMLWriter)w, "isolatedRealm", String.valueOf(pluginDescriptor.isIsolatedRealm()));
                GeneratorUtils.element((XMLWriter)w, "inheritedByDefault", String.valueOf(pluginDescriptor.isInheritedByDefault()));
            }
            w.startElement("mojos");
            if (pluginDescriptor.getMojos() != null) {
                List descriptors = pluginDescriptor.getMojos();
                if (helpDescriptor) {
                    PluginUtils.sortMojos((List)descriptors);
                }
                for (MojoDescriptor descriptor : descriptors) {
                    this.processMojoDescriptor(descriptor, (XMLWriter)w, helpDescriptor);
                }
            }
            w.endElement();
            if (!helpDescriptor) {
                GeneratorUtils.writeDependencies((XMLWriter)w, pluginDescriptor);
            }
            w.endElement();
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w) {
        this.processMojoDescriptor(mojoDescriptor, w, false);
    }

    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w, boolean helpDescriptor) {
        w.startElement("mojo");
        w.startElement("goal");
        w.writeText(mojoDescriptor.getGoal());
        w.endElement();
        String description = mojoDescriptor.getDescription();
        if (description != null) {
            w.startElement("description");
            if (helpDescriptor) {
                w.writeText(GeneratorUtils.toText(mojoDescriptor.getDescription()));
            } else {
                w.writeText(mojoDescriptor.getDescription());
            }
            w.endElement();
        }
        if (mojoDescriptor.isDependencyResolutionRequired() != null) {
            GeneratorUtils.element(w, "requiresDependencyResolution", mojoDescriptor.isDependencyResolutionRequired());
        }
        GeneratorUtils.element(w, "requiresDirectInvocation", String.valueOf(mojoDescriptor.isDirectInvocationOnly()));
        GeneratorUtils.element(w, "requiresProject", String.valueOf(mojoDescriptor.isProjectRequired()));
        GeneratorUtils.element(w, "requiresReports", String.valueOf(mojoDescriptor.isRequiresReports()));
        GeneratorUtils.element(w, "aggregator", String.valueOf(mojoDescriptor.isAggregator()));
        GeneratorUtils.element(w, "requiresOnline", String.valueOf(mojoDescriptor.isOnlineRequired()));
        GeneratorUtils.element(w, "inheritedByDefault", String.valueOf(mojoDescriptor.isInheritedByDefault()));
        if (mojoDescriptor.getPhase() != null) {
            GeneratorUtils.element(w, "phase", mojoDescriptor.getPhase());
        }
        if (mojoDescriptor.getExecutePhase() != null) {
            GeneratorUtils.element(w, "executePhase", mojoDescriptor.getExecutePhase());
        }
        if (mojoDescriptor.getExecuteGoal() != null) {
            GeneratorUtils.element(w, "executeGoal", mojoDescriptor.getExecuteGoal());
        }
        if (mojoDescriptor.getExecuteLifecycle() != null) {
            GeneratorUtils.element(w, "executeLifecycle", mojoDescriptor.getExecuteLifecycle());
        }
        w.startElement("implementation");
        w.writeText(mojoDescriptor.getImplementation());
        w.endElement();
        w.startElement("language");
        w.writeText(mojoDescriptor.getLanguage());
        w.endElement();
        if (mojoDescriptor.getComponentConfigurator() != null) {
            w.startElement("configurator");
            w.writeText(mojoDescriptor.getComponentConfigurator());
            w.endElement();
        }
        if (mojoDescriptor.getComponentComposer() != null) {
            w.startElement("composer");
            w.writeText(mojoDescriptor.getComponentComposer());
            w.endElement();
        }
        w.startElement("instantiationStrategy");
        w.writeText(mojoDescriptor.getInstantiationStrategy());
        w.endElement();
        w.startElement("executionStrategy");
        w.writeText(mojoDescriptor.getExecutionStrategy());
        w.endElement();
        if (mojoDescriptor.getSince() != null) {
            w.startElement("since");
            if (StringUtils.isEmpty((String)mojoDescriptor.getSince())) {
                w.writeText("No version given");
            } else {
                w.writeText(mojoDescriptor.getSince());
            }
            w.endElement();
        }
        if (mojoDescriptor.getDeprecated() != null) {
            w.startElement("deprecated");
            if (StringUtils.isEmpty((String)mojoDescriptor.getDeprecated())) {
                w.writeText("No reason given");
            } else {
                w.writeText(mojoDescriptor.getDeprecated());
            }
            w.endElement();
        }
        if (mojoDescriptor instanceof ExtendedMojoDescriptor) {
            ExtendedMojoDescriptor extendedMojoDescriptor = (ExtendedMojoDescriptor)mojoDescriptor;
            if (extendedMojoDescriptor.getDependencyCollectionRequired() != null) {
                GeneratorUtils.element(w, "requiresDependencyCollection", extendedMojoDescriptor.getDependencyCollectionRequired());
            }
            GeneratorUtils.element(w, "threadSafe", String.valueOf(extendedMojoDescriptor.isThreadSafe()));
        }
        List parameters = mojoDescriptor.getParameters();
        w.startElement("parameters");
        LinkedHashMap<String, Requirement> requirements = new LinkedHashMap<String, Requirement>();
        LinkedHashSet<Parameter> configuration = new LinkedHashSet<Parameter>();
        if (parameters != null) {
            if (helpDescriptor) {
                PluginUtils.sortMojoParameters((List)parameters);
            }
            for (Parameter parameter : parameters) {
                String expression = this.getExpression(parameter);
                if (StringUtils.isNotEmpty((String)expression) && expression.startsWith("${component.")) {
                    String role = expression.substring("${component.".length(), expression.length() - 1);
                    String roleHint = null;
                    int posRoleHintSeparator = role.indexOf("#");
                    if (posRoleHintSeparator > 0) {
                        roleHint = role.substring(posRoleHintSeparator + 1);
                        role = role.substring(0, posRoleHintSeparator);
                    }
                    requirements.put(parameter.getName(), new Requirement(role, roleHint));
                    continue;
                }
                if (parameter.getRequirement() != null) {
                    requirements.put(parameter.getName(), parameter.getRequirement());
                    continue;
                }
                if (helpDescriptor && !parameter.isEditable()) continue;
                w.startElement("parameter");
                GeneratorUtils.element(w, "name", parameter.getName());
                if (parameter.getAlias() != null) {
                    GeneratorUtils.element(w, "alias", parameter.getAlias());
                }
                GeneratorUtils.element(w, "type", parameter.getType());
                if (parameter.getSince() != null) {
                    w.startElement("since");
                    if (StringUtils.isEmpty((String)parameter.getSince())) {
                        w.writeText("No version given");
                    } else {
                        w.writeText(parameter.getSince());
                    }
                    w.endElement();
                }
                if (parameter.getDeprecated() != null) {
                    if (StringUtils.isEmpty((String)parameter.getDeprecated())) {
                        GeneratorUtils.element(w, "deprecated", "No reason given");
                    } else {
                        GeneratorUtils.element(w, "deprecated", parameter.getDeprecated());
                    }
                }
                if (parameter.getImplementation() != null) {
                    GeneratorUtils.element(w, "implementation", parameter.getImplementation());
                }
                GeneratorUtils.element(w, "required", Boolean.toString(parameter.isRequired()));
                GeneratorUtils.element(w, "editable", Boolean.toString(parameter.isEditable()));
                GeneratorUtils.element(w, "description", parameter.getDescription(), helpDescriptor);
                if (StringUtils.isNotEmpty((String)parameter.getDefaultValue()) || StringUtils.isNotEmpty((String)parameter.getExpression())) {
                    configuration.add(parameter);
                }
                w.endElement();
            }
        }
        w.endElement();
        if (!configuration.isEmpty()) {
            w.startElement("configuration");
            for (Parameter parameter : configuration) {
                if (helpDescriptor && !parameter.isEditable()) continue;
                w.startElement(parameter.getName());
                String type = parameter.getType();
                if (type != null) {
                    w.addAttribute("implementation", type);
                }
                if (parameter.getDefaultValue() != null) {
                    w.addAttribute("default-value", parameter.getDefaultValue());
                }
                if (parameter.getExpression() != null) {
                    w.writeText(parameter.getExpression());
                }
                w.endElement();
            }
            w.endElement();
        }
        if (!requirements.isEmpty() && !helpDescriptor) {
            w.startElement("requirements");
            for (Map.Entry entry : requirements.entrySet()) {
                String key = (String)entry.getKey();
                Requirement requirement = (Requirement)entry.getValue();
                w.startElement("requirement");
                GeneratorUtils.element(w, "role", requirement.getRole());
                if (requirement.getRoleHint() != null) {
                    GeneratorUtils.element(w, "role-hint", requirement.getRoleHint());
                }
                GeneratorUtils.element(w, "field-name", key);
                w.endElement();
            }
            w.endElement();
        }
        w.endElement();
    }

    private String getExpression(Parameter parameter) {
        String expression = parameter.getExpression();
        if (StringUtils.isNotBlank((String)expression) && !expression.contains("${")) {
            expression = "${" + expression.trim() + "}";
            parameter.setExpression(expression);
        }
        return expression;
    }

    protected String rewriteHelpClassToMojoPackage(PluginToolsRequest request) throws GeneratorException {
        String destinationPackage = GeneratorUtils.discoverPackageName(request.getPluginDescriptor());
        if (StringUtils.isEmpty((String)destinationPackage)) {
            return null;
        }
        File helpClassFile = new File(request.getProject().getBuild().getOutputDirectory(), "HelpMojo.class");
        if (!helpClassFile.exists()) {
            return null;
        }
        File rewriteHelpClassFile = new File(request.getProject().getBuild().getOutputDirectory() + "/" + StringUtils.replace((String)destinationPackage, (String)".", (String)"/"), "HelpMojo.class");
        if (!rewriteHelpClassFile.getParentFile().exists()) {
            rewriteHelpClassFile.getParentFile().mkdirs();
        }
        ClassReader cr = null;
        try {
            cr = new ClassReader((InputStream)new FileInputStream(helpClassFile));
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
        ClassWriter cw = new ClassWriter(0);
        RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)new SimpleRemapper("HelpMojo", StringUtils.replace((String)destinationPackage, (String)".", (String)"/") + "/HelpMojo"));
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable e) {
            throw new GeneratorException("ASM issue processing classFile " + helpClassFile.getPath(), e);
        }
        byte[] renamedClass = cw.toByteArray();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(rewriteHelpClassFile);
            fos.write(renamedClass);
        }
        catch (IOException e) {
            try {
                throw new GeneratorException("Error rewriting help class: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)fos);
        helpClassFile.delete();
        return destinationPackage + ".HelpMojo";
    }

    private void rewriteDescriptor(PluginDescriptor pluginDescriptor, String helpMojoImplementation) {
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo("help");
        if (mojoDescriptor != null) {
            mojoDescriptor.setImplementation(helpMojoImplementation);
        }
    }
}

