/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.AbstractScriptedMojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MojoDescriptorExtractor.class, hint="bsh")
public class BeanshellMojoDescriptorExtractor
extends AbstractScriptedMojoDescriptorExtractor
implements MojoDescriptorExtractor {
    protected String getScriptFileExtension(PluginToolsRequest request) {
        return ".bsh";
    }

    protected List<MojoDescriptor> extractMojoDescriptors(Map<String, Set<File>> scriptFilesKeyedByBasedir, PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        for (Map.Entry<String, Set<File>> entry : scriptFilesKeyedByBasedir.entrySet()) {
            String basedir = entry.getKey();
            Set<File> metadataFiles = entry.getValue();
            for (File scriptFile : metadataFiles) {
                String relativePath = null;
                if (basedir.endsWith("/")) {
                    basedir = basedir.substring(0, basedir.length() - 2);
                }
                relativePath = scriptFile.getPath().substring(basedir.length());
                relativePath = relativePath.replace('\\', '/');
                MojoDescriptor mojoDescriptor = this.createMojoDescriptor(basedir, relativePath, request);
                descriptors.add(mojoDescriptor);
            }
        }
        return descriptors;
    }

    private MojoDescriptor createMojoDescriptor(String basedir, String resource, PluginToolsRequest request) throws InvalidPluginDescriptorException {
        MojoDescriptor mojoDescriptor = new MojoDescriptor();
        mojoDescriptor.setPluginDescriptor(request.getPluginDescriptor());
        mojoDescriptor.setLanguage("bsh");
        mojoDescriptor.setComponentConfigurator("bsh");
        mojoDescriptor.setImplementation(resource);
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("file", (Object)new File(basedir, resource));
            interpreter.set("mojoDescriptor", (Object)mojoDescriptor);
            interpreter.set("encoding", (Object)"UTF-8");
            interpreter.eval((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/extractor.bsh"), StandardCharsets.UTF_8));
        }
        catch (EvalError evalError) {
            throw new InvalidPluginDescriptorException("Error scanning beanshell script", (Throwable)evalError);
        }
        return mojoDescriptor;
    }
}

