/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.project.builder.profile.ActiveProfileMatcher;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMatcher
implements ActiveProfileMatcher {
    @Override
    public boolean isMatch(ModelContainer modelContainer, List<InterpolatorProperty> properties) {
        if (modelContainer == null) {
            throw new IllegalArgumentException("modelContainer: null");
        }
        ArrayList<String> exists = new ArrayList<String>();
        ArrayList<String> missings = new ArrayList<String>();
        for (ModelProperty mp : modelContainer.getProperties()) {
            if (mp.getUri().equals(ProjectUri.Profiles.Profile.Activation.File.exists)) {
                exists.add(mp.getValue());
                continue;
            }
            if (!mp.getUri().equals(ProjectUri.Profiles.Profile.Activation.File.missing)) continue;
            missings.add(mp.getValue());
        }
        if (exists.isEmpty() && missings.isEmpty()) {
            return false;
        }
        for (String exist : exists) {
            if (new File(exist).exists()) continue;
            return false;
        }
        for (String missing : missings) {
            if (!new File(missing).exists()) continue;
            return false;
        }
        return true;
    }
}

