/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.linkcheck.validation;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.apache.maven.doxia.linkcheck.validation.Anchors;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationItem;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationResult;
import org.apache.maven.doxia.linkcheck.validation.LinkValidator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public final class FileLinkValidator
implements LinkValidator {
    private String encoding;

    public FileLinkValidator(String encoding) {
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        this.encoding = encoding;
    }

    public LinkValidationResult validateLink(LinkValidationItem lvi) {
        File f = this.getFile(lvi);
        if (f.exists()) {
            return new LinkValidationResult(3, false, "");
        }
        return new LinkValidationResult(1, false, "doesn't exist.");
    }

    public Object getResourceKey(LinkValidationItem lvi) {
        String link = lvi.getLink();
        if (link.toLowerCase(Locale.ENGLISH).startsWith("http://") || link.toLowerCase(Locale.ENGLISH).startsWith("https://") || link.indexOf(64) != -1 || link.startsWith("/")) {
            return null;
        }
        return this.getFile(lvi).getAbsolutePath();
    }

    private File getFile(LinkValidationItem lvi) {
        String link = lvi.getLink();
        if (link.indexOf(35) != -1) {
            String anchor = link.substring(link.indexOf(35) + 1);
            if ((link = link.substring(0, link.indexOf(35))).trim().length() == 0) {
                String content = FileLinkValidator.read(lvi.getSource(), this.encoding);
                if (Anchors.matchesAnchor(content, anchor)) {
                    return lvi.getSource();
                }
                return new File(lvi.getLink());
            }
            String content = FileLinkValidator.read(new File(lvi.getSource().getParentFile(), link), this.encoding);
            if (Anchors.matchesAnchor(content, anchor)) {
                return new File(lvi.getSource().getParentFile(), link);
            }
            return new File(lvi.getLink());
        }
        if (link.indexOf(63) != -1 && (link = link.substring(0, link.indexOf(63))).trim().length() == 0) {
            return lvi.getSource();
        }
        return new File(lvi.getSource().getParentFile(), link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(File f, String encoding) {
        Reader reader = null;
        try {
            reader = ReaderFactory.newReader((File)f, (String)encoding);
            String string = IOUtil.toString((Reader)reader);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return null;
    }
}

