/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PriorityQueue;

public abstract class Lookup
implements Accountable {
    public static final Comparator<CharSequence> CHARSEQUENCE_COMPARATOR = new CharSequenceComparator();

    public void build(Dictionary dict) throws IOException {
        this.build(dict.getEntryIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream input) throws IOException {
        boolean bl;
        InputStreamDataInput dataIn = new InputStreamDataInput(input);
        try {
            bl = this.load((DataInput)dataIn);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{input});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{input});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(OutputStream output) throws IOException {
        boolean bl;
        OutputStreamDataOutput dataOut = new OutputStreamDataOutput(output);
        try {
            bl = this.store((DataOutput)dataOut);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{output});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{output});
        return bl;
    }

    public abstract long getCount() throws IOException;

    public abstract void build(InputIterator var1) throws IOException;

    public List<LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) throws IOException {
        return this.lookup(key, null, onlyMorePopular, num);
    }

    public abstract List<LookupResult> lookup(CharSequence var1, Set<BytesRef> var2, boolean var3, int var4) throws IOException;

    public abstract boolean store(DataOutput var1) throws IOException;

    public abstract boolean load(DataInput var1) throws IOException;

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public static final class LookupPriorityQueue
    extends PriorityQueue<LookupResult> {
        public LookupPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(LookupResult a, LookupResult b) {
            return a.value < b.value;
        }

        public LookupResult[] getResults() {
            int size = this.size();
            LookupResult[] res = new LookupResult[size];
            for (int i = size - 1; i >= 0; --i) {
                res[i] = (LookupResult)this.pop();
            }
            return res;
        }
    }

    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int l1 = o1.length();
            int l2 = o2.length();
            int aStop = Math.min(l1, l2);
            for (int i = 0; i < aStop; ++i) {
                int diff = o1.charAt(i) - o2.charAt(i);
                if (diff == 0) continue;
                return diff;
            }
            return l1 - l2;
        }
    }

    public static final class LookupResult
    implements Comparable<LookupResult> {
        public final CharSequence key;
        public final Object highlightKey;
        public final long value;
        public final BytesRef payload;
        public final Set<BytesRef> contexts;

        public LookupResult(CharSequence key, long value) {
            this(key, null, value, null, null);
        }

        public LookupResult(CharSequence key, long value, BytesRef payload) {
            this(key, null, value, payload, null);
        }

        public LookupResult(CharSequence key, Object highlightKey, long value, BytesRef payload) {
            this(key, highlightKey, value, payload, null);
        }

        public LookupResult(CharSequence key, long value, BytesRef payload, Set<BytesRef> contexts) {
            this(key, null, value, payload, contexts);
        }

        public LookupResult(CharSequence key, long value, Set<BytesRef> contexts) {
            this(key, null, value, null, contexts);
        }

        public LookupResult(CharSequence key, Object highlightKey, long value, BytesRef payload, Set<BytesRef> contexts) {
            this.key = key;
            this.highlightKey = highlightKey;
            this.value = value;
            this.payload = payload;
            this.contexts = contexts;
        }

        public String toString() {
            return this.key + "/" + this.value;
        }

        @Override
        public int compareTo(LookupResult o) {
            return CHARSEQUENCE_COMPARATOR.compare(this.key, o.key);
        }
    }
}

