/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import java.util.List;
import org.apache.lucene.queryParser.core.nodes.FieldableNode;
import org.apache.lucene.queryParser.core.nodes.ParametricQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

public class ParametricRangeQueryNode
extends QueryNodeImpl
implements FieldableNode {
    private static final long serialVersionUID = 7120958816535573935L;

    public ParametricRangeQueryNode(ParametricQueryNode lowerBound, ParametricQueryNode upperBound) {
        if (upperBound.getOperator() != ParametricQueryNode.CompareOperator.LE && upperBound.getOperator() != ParametricQueryNode.CompareOperator.LT) {
            throw new IllegalArgumentException("upper bound should have " + (Object)((Object)ParametricQueryNode.CompareOperator.LE) + " or " + (Object)((Object)ParametricQueryNode.CompareOperator.LT));
        }
        if (lowerBound.getOperator() != ParametricQueryNode.CompareOperator.GE && lowerBound.getOperator() != ParametricQueryNode.CompareOperator.GT) {
            throw new IllegalArgumentException("lower bound should have " + (Object)((Object)ParametricQueryNode.CompareOperator.GE) + " or " + (Object)((Object)ParametricQueryNode.CompareOperator.GT));
        }
        if (upperBound.getField() != lowerBound.getField() || upperBound.getField() != null && !upperBound.getField().equals(lowerBound.getField())) {
            throw new IllegalArgumentException("lower and upper bounds should have the same field name!");
        }
        this.allocate();
        this.setLeaf(false);
        this.add(lowerBound);
        this.add(upperBound);
    }

    public ParametricQueryNode getUpperBound() {
        return (ParametricQueryNode)this.getChildren().get(1);
    }

    public ParametricQueryNode getLowerBound() {
        return (ParametricQueryNode)this.getChildren().get(0);
    }

    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        return this.getLowerBound().toQueryString(escapeSyntaxParser) + " AND " + this.getUpperBound().toQueryString(escapeSyntaxParser);
    }

    public CharSequence getField() {
        return this.getLowerBound().getField();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<parametricRange>\n\t");
        sb.append(this.getUpperBound()).append("\n\t");
        sb.append(this.getLowerBound()).append("\n");
        sb.append("</parametricRange>\n");
        return sb.toString();
    }

    public ParametricRangeQueryNode cloneTree() throws CloneNotSupportedException {
        ParametricRangeQueryNode clone = (ParametricRangeQueryNode)super.cloneTree();
        return clone;
    }

    public void setField(CharSequence fieldName) {
        List<QueryNode> children = this.getChildren();
        if (children != null) {
            for (QueryNode child : this.getChildren()) {
                if (!(child instanceof FieldableNode)) continue;
                ((FieldableNode)child).setField(fieldName);
            }
        }
    }
}

