/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ASCIIFoldingFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "asciiFolding";
    private static final String PRESERVE_ORIGINAL = "preserveOriginal";
    private final boolean preserveOriginal;

    public ASCIIFoldingFilterFactory(Map<String, String> args) {
        super(args);
        this.preserveOriginal = this.getBoolean(args, PRESERVE_ORIGINAL, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ASCIIFoldingFilter(input, this.preserveOriginal);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return new ASCIIFoldingFilter(input, false);
    }
}

