/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;

public class LogServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final String LABEL = "logs";
    private static final String TITLE = "%logs.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/logs.css"};
    private static final int MAX_LOGS = 200;
    private final String TEMPLATE = this.readTemplateFile("/templates/logs.html");
    private static final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private static final PrintStream printStream = new PrintStream(baos);
    static /* synthetic */ Class class$org$osgi$service$log$LogReaderService;

    public LogServlet() {
        super(LABEL, TITLE, "OSGi", CSS);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int minLevel = WebConsoleUtil.getParameterInt(req, "minLevel", 4);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        this.renderJSON(resp.getWriter(), minLevel, LogServlet.trasesEnabled(req));
    }

    private static boolean trasesEnabled(HttpServletRequest req) {
        String traces = req.getParameter("traces");
        return null == traces ? false : Boolean.valueOf(traces);
    }

    private final void renderJSON(PrintWriter pw, int minLogLevel, boolean traces) throws IOException {
        LogReaderService logReaderService = (LogReaderService)this.getService((class$org$osgi$service$log$LogReaderService == null ? (class$org$osgi$service$log$LogReaderService = LogServlet.class$("org.osgi.service.log.LogReaderService")) : class$org$osgi$service$log$LogReaderService).getName());
        JSONWriter jw = new JSONWriter(pw);
        try {
            jw.object();
            jw.key("status");
            jw.value(logReaderService == null ? Boolean.FALSE : Boolean.TRUE);
            jw.key("data");
            jw.array();
            if (logReaderService != null) {
                int index = 0;
                Enumeration logEntries = logReaderService.getLog();
                while (logEntries.hasMoreElements() && index < 200) {
                    LogEntry nextLog = (LogEntry)logEntries.nextElement();
                    if (nextLog.getLevel() > minLogLevel) continue;
                    LogServlet.logJson(jw, nextLog, index++, traces);
                }
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int minLevel = WebConsoleUtil.getParameterInt(request, "minLevel", 4);
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            this.renderJSON(pw, minLevel, LogServlet.trasesEnabled(request));
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getWriter().print(this.TEMPLATE);
    }

    private static final void logJson(JSONWriter jw, LogEntry info, int index, boolean traces) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value(String.valueOf(index));
        jw.key("received");
        jw.value(info.getTime());
        jw.key("level");
        jw.value(LogServlet.logLevel(info.getLevel()));
        jw.key("raw_level");
        jw.value(info.getLevel());
        jw.key("message");
        jw.value(info.getMessage());
        jw.key("service");
        jw.value(LogServlet.serviceDescription(info.getServiceReference()));
        jw.key("exception");
        jw.value(LogServlet.exceptionMessage(info.getException(), traces));
        Bundle bundle = info.getBundle();
        if (null != bundle) {
            jw.key("bundleId");
            jw.value(bundle.getBundleId());
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            if (null == name) {
                name = bundle.getSymbolicName();
            }
            if (null == name) {
                name = bundle.getLocation();
            }
            jw.key("bundleName");
            jw.value(name);
        }
        jw.endObject();
    }

    private static final String serviceDescription(ServiceReference serviceReference) {
        if (serviceReference == null) {
            return "";
        }
        return serviceReference.toString();
    }

    private static final String logLevel(int level) {
        switch (level) {
            case 3: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "DEBUG";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String exceptionMessage(Throwable e, boolean traces) {
        if (e == null) {
            return "";
        }
        if (traces) {
            String ret = null;
            PrintStream printStream = LogServlet.printStream;
            synchronized (printStream) {
                try {
                    e.printStackTrace(LogServlet.printStream);
                    ret = baos.toString();
                }
                finally {
                    baos.reset();
                }
            }
            return ret;
        }
        return e.getClass().getName() + ": " + e.getMessage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

