/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class TaskMetrics {
    private static final String AVG_LATENCY_DESCRIPTION = "The average latency of ";
    private static final String MAX_LATENCY_DESCRIPTION = "The maximum latency of ";
    private static final String RATE_DESCRIPTION_PREFIX = "The average number of ";
    private static final String RATE_DESCRIPTION_SUFFIX = " per second";
    private static final String ACTIVE_TASK_PREFIX = "active-";
    private static final String COMMIT = "commit";
    private static final String COMMIT_DESCRIPTION = "calls to commit";
    private static final String COMMIT_TOTAL_DESCRIPTION = "The total number of calls to commit";
    private static final String COMMIT_RATE_DESCRIPTION = "The average number of calls to commit per second";
    private static final String PUNCTUATE = "punctuate";
    private static final String PUNCTUATE_DESCRIPTION = "calls to punctuate";
    private static final String PUNCTUATE_TOTAL_DESCRIPTION = "The total number of calls to punctuate";
    private static final String PUNCTUATE_RATE_DESCRIPTION = "The average number of calls to punctuate per second";
    private static final String PUNCTUATE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to punctuate";
    private static final String PUNCTUATE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to punctuate";
    private static final String RESTORE = "restore";
    private static final String RESTORE_DESCRIPTION = "records restored";
    private static final String RESTORE_TOTAL_DESCRIPTION = "The total number of records restored";
    private static final String RESTORE_RATE_DESCRIPTION = "The average number of records restored per second";
    private static final String UPDATE = "update";
    private static final String UPDATE_DESCRIPTION = "records updated";
    private static final String UPDATE_TOTAL_DESCRIPTION = "The total number of records updated";
    private static final String UPDATE_RATE_DESCRIPTION = "The average number of records updated per second";
    private static final String REMAINING_RECORDS = "-remaining-records";
    private static final String REMAINING_RECORDS_DESCRIPTION = "The total number of records remaining to be restored";
    private static final String ENFORCED_PROCESSING = "enforced-processing";
    private static final String ENFORCED_PROCESSING_TOTAL_DESCRIPTION = "The total number of occurrences of enforced-processing operations";
    private static final String ENFORCED_PROCESSING_RATE_DESCRIPTION = "The average number of occurrences of enforced-processing operations per second";
    private static final String RECORD_LATENESS = "record-lateness";
    private static final String RECORD_LATENESS_MAX_DESCRIPTION = "The observed maximum lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
    private static final String RECORD_LATENESS_AVG_DESCRIPTION = "The observed average lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
    private static final String DROPPED_RECORDS = "dropped-records";
    private static final String DROPPED_RECORDS_DESCRIPTION = "dropped records";
    private static final String DROPPED_RECORDS_TOTAL_DESCRIPTION = "The total number of dropped records";
    private static final String DROPPED_RECORDS_RATE_DESCRIPTION = "The average number of dropped records per second";
    private static final String PROCESS = "process";
    private static final String PROCESS_LATENCY = "process-latency";
    private static final String PROCESS_DESCRIPTION = "calls to process";
    private static final String PROCESS_AVG_LATENCY_DESCRIPTION = "The average latency of calls to process";
    private static final String PROCESS_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to process";
    private static final String PROCESS_RATIO_DESCRIPTION = "The fraction of time the thread spent on processing this task among all assigned active tasks";
    private static final String BUFFER_COUNT = "buffer-count";
    private static final String NUM_BUFFERED_RECORDS_DESCRIPTION = "The count of buffered records that are polled from consumer and not yet processed for this active task";
    private static final String CACHE_SIZE_BYTES_TOTAL = "cache-size-bytes-total";
    private static final String CACHE_SIZE_BYTES_TOTAL_DESCRIPTION = "The total size in bytes of this task's cache.";

    private TaskMetrics() {
    }

    public static Sensor processLatencySensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        return TaskMetrics.avgAndMaxSensor(threadId, taskId, PROCESS_LATENCY, PROCESS_AVG_LATENCY_DESCRIPTION, PROCESS_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor totalCacheSizeBytesSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        String name = CACHE_SIZE_BYTES_TOTAL;
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, CACHE_SIZE_BYTES_TOTAL, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-task-metrics", streamsMetrics.taskLevelTagMap(threadId, taskId), CACHE_SIZE_BYTES_TOTAL, CACHE_SIZE_BYTES_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor restoreRemainingRecordsSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        String name = "restore-remaining-records-total";
        Map<String, String> tags = streamsMetrics.taskLevelTagMap(threadId, taskId);
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, "restore-remaining-records-total", Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addSumMetricToSensor(sensor, "stream-task-metrics", tags, "restore-remaining-records-total", false, REMAINING_RECORDS_DESCRIPTION);
        return sensor;
    }

    public static Sensor activeProcessRatioSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        String name = "active-process-ratio";
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, "active-process-ratio", Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-task-metrics", streamsMetrics.taskLevelTagMap(threadId, taskId), "active-process-ratio", PROCESS_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor activeBufferedRecordsSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        String name = "active-buffer-count";
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, "active-buffer-count", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-task-metrics", streamsMetrics.taskLevelTagMap(threadId, taskId), "active-buffer-count", NUM_BUFFERED_RECORDS_DESCRIPTION);
        return sensor;
    }

    public static Sensor punctuateSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        return TaskMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, taskId, PUNCTUATE, PUNCTUATE_RATE_DESCRIPTION, PUNCTUATE_TOTAL_DESCRIPTION, PUNCTUATE_AVG_LATENCY_DESCRIPTION, PUNCTUATE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor commitSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensor) {
        return TaskMetrics.invocationRateAndCountSensor(threadId, taskId, COMMIT, COMMIT_RATE_DESCRIPTION, COMMIT_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor restoreSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensor) {
        return TaskMetrics.invocationRateAndTotalSensor(threadId, taskId, RESTORE, RESTORE_RATE_DESCRIPTION, RESTORE_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor updateSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensor) {
        return TaskMetrics.invocationRateAndTotalSensor(threadId, taskId, UPDATE, UPDATE_RATE_DESCRIPTION, UPDATE_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor enforcedProcessingSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        return TaskMetrics.invocationRateAndCountSensor(threadId, taskId, ENFORCED_PROCESSING, ENFORCED_PROCESSING_RATE_DESCRIPTION, ENFORCED_PROCESSING_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensors);
    }

    public static Sensor recordLatenessSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        return TaskMetrics.avgAndMaxSensor(threadId, taskId, RECORD_LATENESS, RECORD_LATENESS_AVG_DESCRIPTION, RECORD_LATENESS_MAX_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor droppedRecordsSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        return TaskMetrics.invocationRateAndTotalSensor(threadId, taskId, DROPPED_RECORDS, DROPPED_RECORDS_RATE_DESCRIPTION, DROPPED_RECORDS_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics, new Sensor[0]);
    }

    private static Sensor invocationRateAndCountSensor(String threadId, String taskId, String operation, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, operation, recordingLevel, parentSensors);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-task-metrics", streamsMetrics.taskLevelTagMap(threadId, taskId), operation, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor invocationRateAndTotalSensor(String threadId, String taskId, String operation, String descriptionOfRate, String descriptionOfTotal, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, operation, recordingLevel, parentSensors);
        Map<String, String> tags = streamsMetrics.taskLevelTagMap(threadId, taskId);
        StreamsMetricsImpl.addInvocationRateToSensor(sensor, "stream-task-metrics", tags, operation, descriptionOfRate);
        StreamsMetricsImpl.addSumMetricToSensor(sensor, "stream-task-metrics", tags, operation, true, descriptionOfTotal);
        return sensor;
    }

    private static Sensor avgAndMaxSensor(String threadId, String taskId, String gaugeName, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, gaugeName, recordingLevel, parentSensors);
        Map<String, String> tagMap = streamsMetrics.taskLevelTagMap(threadId, taskId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-task-metrics", tagMap, gaugeName, descriptionOfAvg, descriptionOfMax);
        return sensor;
    }

    private static Sensor invocationRateAndCountAndAvgAndMaxLatencySensor(String threadId, String taskId, String operation, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, operation, recordingLevel, parentSensors);
        Map<String, String> tagMap = streamsMetrics.taskLevelTagMap(threadId, taskId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-task-metrics", tagMap, operation + "-latency", descriptionOfAvg, descriptionOfMax);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-task-metrics", tagMap, operation, descriptionOfRate, descriptionOfCount);
        return sensor;
    }
}

