/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteBufferOutputStreamTest {
    @Test
    public void testExpandByteBufferOnPositionIncrease() throws Exception {
        this.testExpandByteBufferOnPositionIncrease(ByteBuffer.allocate(16));
    }

    @Test
    public void testExpandDirectByteBufferOnPositionIncrease() throws Exception {
        this.testExpandByteBufferOnPositionIncrease(ByteBuffer.allocateDirect(16));
    }

    private void testExpandByteBufferOnPositionIncrease(ByteBuffer initialBuffer) throws Exception {
        ByteBufferOutputStream output = new ByteBufferOutputStream(initialBuffer);
        output.write("hello".getBytes());
        output.position(32);
        Assertions.assertEquals((int)32, (int)output.position());
        Assertions.assertEquals((int)0, (int)initialBuffer.position());
        ByteBuffer buffer = output.buffer();
        Assertions.assertEquals((int)32, (int)buffer.limit());
        buffer.position(0);
        buffer.limit(5);
        byte[] bytes = new byte[5];
        buffer.get(bytes);
        Assertions.assertArrayEquals((byte[])"hello".getBytes(), (byte[])bytes);
        output.close();
    }

    @Test
    public void testExpandByteBufferOnWrite() throws Exception {
        this.testExpandByteBufferOnWrite(ByteBuffer.allocate(16));
    }

    @Test
    public void testExpandDirectByteBufferOnWrite() throws Exception {
        this.testExpandByteBufferOnWrite(ByteBuffer.allocateDirect(16));
    }

    private void testExpandByteBufferOnWrite(ByteBuffer initialBuffer) throws Exception {
        ByteBufferOutputStream output = new ByteBufferOutputStream(initialBuffer);
        output.write("hello".getBytes());
        output.write(new byte[27]);
        Assertions.assertEquals((int)32, (int)output.position());
        Assertions.assertEquals((int)0, (int)initialBuffer.position());
        ByteBuffer buffer = output.buffer();
        Assertions.assertEquals((int)32, (int)buffer.limit());
        buffer.position(0);
        buffer.limit(5);
        byte[] bytes = new byte[5];
        buffer.get(bytes);
        Assertions.assertArrayEquals((byte[])"hello".getBytes(), (byte[])bytes);
        output.close();
    }

    @Test
    public void testWriteByteBuffer() throws IOException {
        this.testWriteByteBuffer(ByteBuffer.allocate(16));
    }

    @Test
    public void testWriteDirectByteBuffer() throws IOException {
        this.testWriteByteBuffer(ByteBuffer.allocateDirect(16));
    }

    private void testWriteByteBuffer(ByteBuffer input) throws IOException {
        long value = 234239230L;
        input.putLong(value);
        input.flip();
        ByteBufferOutputStream output = new ByteBufferOutputStream(ByteBuffer.allocate(32));
        output.write(input);
        Assertions.assertEquals((int)8, (int)input.position());
        Assertions.assertEquals((int)8, (int)output.position());
        Assertions.assertEquals((long)value, (long)output.buffer().getLong(0));
        output.close();
    }
}

