/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.db.SimpleDbPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyPersistenceManager
extends SimpleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(DerbyPersistenceManager.class);
    protected boolean shutdownOnClose;

    public DerbyPersistenceManager() {
        this.schema = "derby";
        this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.schemaObjectPrefix = "";
        this.shutdownOnClose = true;
    }

    public boolean getShutdownOnClose() {
        return this.shutdownOnClose;
    }

    public void setShutdownOnClose(boolean shutdownOnClose) {
        this.shutdownOnClose = shutdownOnClose;
    }

    protected void closeConnection(Connection connection) throws SQLException {
        String url;
        try {
            url = connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            log.debug("failed to retrieve connection url: embedded db probably already shut down", e);
            return;
        }
        int pos = url.lastIndexOf(59);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        url = url + ";shutdown=true";
        connection.setAutoCommit(true);
        connection.close();
        if (this.shutdownOnClose) {
            try {
                DriverManager.getConnection(url);
            }
            catch (SQLException e) {
                log.info(e.getMessage());
            }
        }
    }
}

