/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.util;

import java.util.TimerTask;

public class Timer {
    private java.util.Timer delegatee;
    private final boolean runAsDeamon;
    private int numScheduledTasks = 0;

    public Timer(boolean isDeamon) {
        this.runAsDeamon = isDeamon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        Timer timer = this;
        synchronized (timer) {
            if (this.delegatee == null) {
                this.delegatee = new java.util.Timer(this.runAsDeamon);
            }
            this.delegatee.schedule((TimerTask)task, delay, period);
            task.setTimer(this);
            ++this.numScheduledTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Timer timer = this;
        synchronized (timer) {
            if (this.delegatee != null) {
                this.delegatee.cancel();
                this.numScheduledTasks = 0;
                this.delegatee = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskCanceled() {
        Timer timer = this;
        synchronized (timer) {
            if (--this.numScheduledTasks == 0) {
                this.delegatee.cancel();
                this.delegatee = null;
            }
        }
    }

    public static abstract class Task
    extends TimerTask {
        private Timer timer;

        private void setTimer(Timer timer) {
            this.timer = timer;
        }

        public final boolean cancel() {
            if (this.timer != null) {
                this.timer.taskCanceled();
                this.timer = null;
            }
            return super.cancel();
        }
    }
}

