/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.hadoop.hdfs.server.namenode.ha.StandbyCheckpointer;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.util.ajax.JSON;

@Metrics(context="dfs")
@InterfaceAudience.Private
public class FSNamesystem
implements Namesystem,
FSClusterStats,
FSNamesystemMBean,
NameNodeMXBean {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private static final ThreadLocal<StringBuilder> auditBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    static final int DEFAULT_MAX_CORRUPT_FILEBLOCKS_RETURNED = 100;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private final boolean isPermissionEnabled;
    private final boolean persistBlocks;
    private final UserGroupInformation fsOwner;
    private final String fsOwnerShortUserName;
    private final String supergroup;
    private final boolean standbyShouldCheckpoint;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    final DelegationTokenSecretManager dtSecretManager;
    private final boolean alwaysUseDelegationTokensForTests;
    private final boolean isDefaultAuditLogger;
    private final List<AuditLogger> auditLoggers;
    FSDirectory dir;
    private final BlockManager blockManager;
    private final DatanodeStatistics datanodeStatistics;
    private String blockPoolId;
    final LeaseManager leaseManager = new LeaseManager(this);
    Daemon smmthread = null;
    Daemon nnrmthread = null;
    private volatile boolean hasResourcesAvailable = false;
    private volatile boolean fsRunning = true;
    private final long startTime = Time.now();
    private final long resourceRecheckInterval;
    NameNodeResourceChecker nnResourceChecker;
    private final FsServerDefaults serverDefaults;
    private final boolean supportAppends;
    private final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    private volatile SafeModeInfo safeMode;
    private final long maxFsObjects;
    private final GenerationStamp generationStamp = new GenerationStamp();
    private final long accessTimePrecision;
    private ReentrantReadWriteLock fsLock = new ReentrantReadWriteLock(true);
    private EditLogTailer editLogTailer = null;
    private StandbyCheckpointer standbyCheckpointer;
    private HAContext haContext;
    private final boolean haEnabled;
    private ObjectName mbeanName;

    private boolean isAuditEnabled() {
        return !this.isDefaultAuditLogger || auditLog.isInfoEnabled();
    }

    private HdfsFileStatus getAuditFileInfo(String path, boolean resolveSymlink) throws IOException {
        return this.isAuditEnabled() && this.isExternalInvocation() ? this.dir.getFileInfo(path, resolveSymlink) : null;
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src) throws IOException {
        this.logAuditEvent(succeeded, cmd, src, null, null);
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        if (this.isAuditEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(succeeded, FSNamesystem.getRemoteUser(), FSNamesystem.getRemoteIp(), cmd, src, dst, stat);
        }
    }

    private void logAuditEvent(boolean succeeded, UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) {
        FileStatus status = null;
        if (stat != null) {
            Path symlink = stat.isSymlink() ? new Path(stat.getSymlink()) : null;
            Path path = dst != null ? new Path(dst) : new Path(src);
            status = new FileStatus(stat.getLen(), stat.isDir(), (int)stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), symlink, path);
        }
        for (AuditLogger logger : this.auditLoggers) {
            logger.logAuditEvent(succeeded, ugi.toString(), addr, cmd, src, dst, status);
        }
    }

    void clear() {
        this.dir.reset();
        this.dtSecretManager.reset();
        this.generationStamp.setStamp(1000L);
        this.leaseManager.removeAllLeases();
    }

    @VisibleForTesting
    LeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    private static void checkConfiguration(Configuration conf) throws IOException {
        Collection<URI> namespaceDirs = FSNamesystem.getNamespaceDirs(conf);
        List<URI> editsDirs = FSNamesystem.getNamespaceEditsDirs(conf);
        Collection<URI> requiredEditsDirs = FSNamesystem.getRequiredNamespaceEditsDirs(conf);
        List<URI> sharedEditsDirs = FSNamesystem.getSharedEditsDirs(conf);
        for (URI u : requiredEditsDirs) {
            if (u.toString().compareTo("file:///tmp/hadoop/dfs/name") == 0 || editsDirs.contains(u) || sharedEditsDirs.contains(u)) continue;
            throw new IllegalArgumentException("Required edits directory " + u.toString() + " not present in " + "dfs.namenode.edits.dir" + ". " + "dfs.namenode.edits.dir" + "=" + editsDirs.toString() + "; " + "dfs.namenode.edits.dir.required" + "=" + requiredEditsDirs.toString() + ". " + "dfs.namenode.shared.edits.dir" + "=" + sharedEditsDirs.toString() + ".");
        }
        if (namespaceDirs.size() == 1) {
            LOG.warn((Object)"Only one image storage directory (dfs.namenode.name.dir) configured. Beware of dataloss due to lack of redundant storage directories!");
        }
        if (editsDirs.size() == 1) {
            LOG.warn((Object)"Only one namespace edits storage directory (dfs.namenode.edits.dir) configured. Beware of dataloss due to lack of redundant storage directories!");
        }
    }

    public static FSNamesystem loadFromDisk(Configuration conf) throws IOException {
        FSNamesystem.checkConfiguration(conf);
        FSImage fsImage = new FSImage(conf, FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf));
        FSNamesystem namesystem = new FSNamesystem(conf, fsImage);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
            namesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        }
        long loadStart = Time.now();
        String nameserviceId = DFSUtil.getNamenodeNameServiceId(conf);
        namesystem.loadFSImage(startOpt, fsImage, HAUtil.isHAEnabled(conf, nameserviceId));
        long timeTakenToLoadFSImage = Time.now() - loadStart;
        LOG.info((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs"));
        NameNodeMetrics nnMetrics = NameNode.getNameNodeMetrics();
        if (nnMetrics != null) {
            nnMetrics.setFsImageLoadTime((int)timeTakenToLoadFSImage);
        }
        return namesystem;
    }

    FSNamesystem(Configuration conf, FSImage fsImage) throws IOException {
        try {
            DataChecksum.Type checksumType;
            this.resourceRecheckInterval = conf.getLong("dfs.namenode.resource.check.interval", 5000L);
            this.blockManager = new BlockManager(this, this, conf);
            this.datanodeStatistics = this.blockManager.getDatanodeManager().getDatanodeStatistics();
            this.fsOwner = UserGroupInformation.getCurrentUser();
            this.fsOwnerShortUserName = this.fsOwner.getShortUserName();
            this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
            this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
            LOG.info((Object)("fsOwner             = " + this.fsOwner));
            LOG.info((Object)("supergroup          = " + this.supergroup));
            LOG.info((Object)("isPermissionEnabled = " + this.isPermissionEnabled));
            boolean persistBlocks = conf.getBoolean("dfs.persist.blocks", false);
            String nameserviceId = DFSUtil.getNamenodeNameServiceId(conf);
            this.haEnabled = HAUtil.isHAEnabled(conf, nameserviceId);
            boolean bl = this.persistBlocks = persistBlocks || this.haEnabled && HAUtil.usesSharedEditsDir(conf);
            if (nameserviceId != null) {
                LOG.info((Object)("Determined nameservice ID: " + nameserviceId));
            }
            LOG.info((Object)("HA Enabled: " + this.haEnabled));
            if (!this.haEnabled && HAUtil.usesSharedEditsDir(conf)) {
                LOG.warn((Object)("Configured NNs:\n" + DFSUtil.nnAddressesAsString(conf)));
                throw new IOException("Invalid configuration: a shared edits dir must not be specified if HA is not enabled.");
            }
            String checksumTypeStr = conf.get("dfs.checksum.type", "CRC32C");
            try {
                checksumType = DataChecksum.Type.valueOf((String)checksumTypeStr);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid checksum type in dfs.checksum.type: " + checksumTypeStr);
            }
            this.serverDefaults = new FsServerDefaults(conf.getLongBytes("dfs.blocksize", 0x4000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096), conf.getBoolean("dfs.encrypt.data.transfer", false), conf.getLong("fs.trash.interval", 0L), checksumType);
            this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
            this.accessTimePrecision = conf.getLong("dfs.namenode.accesstime.precision", 0L);
            this.supportAppends = conf.getBoolean("dfs.support.append", true);
            LOG.info((Object)("Append Enabled: " + this.supportAppends));
            this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
            this.standbyShouldCheckpoint = conf.getBoolean("dfs.ha.standby.checkpoints", true);
            this.alwaysUseDelegationTokensForTests = conf.getBoolean("dfs.namenode.delegation.token.always-use", false);
            this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
            this.dir = new FSDirectory(fsImage, this, conf);
            this.safeMode = new SafeModeInfo(conf);
            this.auditLoggers = this.initAuditLoggers(conf);
            this.isDefaultAuditLogger = this.auditLoggers.size() == 1 && this.auditLoggers.get(0) instanceof DefaultAuditLogger;
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
        catch (RuntimeException re) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)re);
            this.close();
            throw re;
        }
    }

    private List<AuditLogger> initAuditLoggers(Configuration conf) {
        Collection alClasses = conf.getStringCollection("dfs.namenode.audit.loggers");
        ArrayList auditLoggers = Lists.newArrayList();
        if (alClasses != null && !alClasses.isEmpty()) {
            for (String className : alClasses) {
                try {
                    AuditLogger logger = "default".equals(className) ? new DefaultAuditLogger() : (AuditLogger)Class.forName(className).newInstance();
                    logger.initialize(conf);
                    auditLoggers.add(logger);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (auditLoggers.isEmpty()) {
            auditLoggers.add(new DefaultAuditLogger());
        }
        return auditLoggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFSImage(HdfsServerConstants.StartupOption startOpt, FSImage fsImage, boolean haEnabled) throws IOException {
        if (startOpt == HdfsServerConstants.StartupOption.FORMAT) {
            fsImage.format(this, fsImage.getStorage().determineClusterId());
            startOpt = HdfsServerConstants.StartupOption.REGULAR;
        }
        boolean success = false;
        this.writeLock();
        try {
            MetaRecoveryContext recovery = startOpt.createRecoveryContext();
            if (fsImage.recoverTransitionRead(startOpt, this, recovery) && !haEnabled) {
                fsImage.saveNamespace(this);
            }
            if (!haEnabled) {
                fsImage.openEditLogForWrite();
            }
            success = true;
        }
        finally {
            if (!success) {
                fsImage.close();
            }
            this.writeUnlock();
        }
        this.dir.imageLoadComplete();
    }

    private void startSecretManager() {
        if (this.dtSecretManager != null) {
            try {
                this.dtSecretManager.startThreads();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void startSecretManagerIfNecessary() {
        boolean shouldRun = this.shouldUseDelegationTokens() && !this.isInSafeMode() && this.getEditLog().isOpenForWrite();
        boolean running = this.dtSecretManager.isRunning();
        if (shouldRun && !running) {
            this.startSecretManager();
        }
    }

    private void stopSecretManager() {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCommonServices(Configuration conf, HAContext haContext) throws IOException {
        this.registerMBean();
        this.writeLock();
        this.haContext = haContext;
        try {
            this.nnResourceChecker = new NameNodeResourceChecker(conf);
            this.checkAvailableResources();
            assert (this.safeMode != null && !this.safeMode.isPopulatingReplQueues());
            this.setBlockTotal();
            this.blockManager.activate(conf);
        }
        finally {
            this.writeUnlock();
        }
        this.registerMXBean();
        DefaultMetricsSystem.instance().register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopCommonServices() {
        this.writeLock();
        try {
            if (this.blockManager != null) {
                this.blockManager.close();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startActiveServices() throws IOException {
        LOG.info((Object)"Starting services required for active state");
        this.writeLock();
        try {
            FSEditLog editLog = this.dir.fsImage.getEditLog();
            if (!editLog.isOpenForWrite()) {
                editLog.initJournalsForWrite();
                editLog.recoverUnclosedStreams();
                LOG.info((Object)"Catching up to latest edits from old active before taking over writer role in edits logs");
                this.editLogTailer.catchupDuringFailover();
                this.blockManager.setPostponeBlocksFromFuture(false);
                this.blockManager.getDatanodeManager().markAllDatanodesStale();
                this.blockManager.clearQueues();
                this.blockManager.processAllPendingDNMessages();
                if (!this.isInSafeMode() || this.isInSafeMode() && this.safeMode.isPopulatingReplQueues()) {
                    LOG.info((Object)"Reprocessing replication and invalidation queues");
                    this.blockManager.processMisReplicatedBlocks();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("NameNode metadata after re-processing replication and invalidation queues during failover:\n" + this.metaSaveAsString()));
                }
                long nextTxId = this.dir.fsImage.getLastAppliedTxId() + 1L;
                LOG.info((Object)("Will take over writing edit logs at txnid " + nextTxId));
                editLog.setNextTxId(nextTxId);
                this.dir.fsImage.editLog.openForWrite();
            }
            if (this.haEnabled) {
                this.leaseManager.renewAllLeases();
            }
            this.leaseManager.startMonitor();
            this.startSecretManagerIfNecessary();
            this.nnrmthread = new Daemon((Runnable)new NameNodeResourceMonitor());
            this.nnrmthread.start();
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean shouldUseDelegationTokens() {
        return UserGroupInformation.isSecurityEnabled() || this.alwaysUseDelegationTokensForTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopActiveServices() {
        LOG.info((Object)"Stopping services started for active state");
        this.writeLock();
        try {
            this.stopSecretManager();
            if (this.leaseManager != null) {
                this.leaseManager.stopMonitor();
            }
            if (this.nnrmthread != null) {
                ((NameNodeResourceMonitor)this.nnrmthread.getRunnable()).stopMonitor();
                this.nnrmthread.interrupt();
            }
            if (this.dir != null && this.dir.fsImage != null) {
                if (this.dir.fsImage.editLog != null) {
                    this.dir.fsImage.editLog.close();
                }
                this.dir.fsImage.updateLastAppliedTxIdFromWritten();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void startStandbyServices(Configuration conf) throws IOException {
        LOG.info((Object)"Starting services required for standby state");
        if (!this.dir.fsImage.editLog.isOpenForRead()) {
            this.dir.fsImage.editLog.initSharedJournalsForRead();
        }
        this.blockManager.setPostponeBlocksFromFuture(true);
        this.editLogTailer = new EditLogTailer(this, conf);
        this.editLogTailer.start();
        if (this.standbyShouldCheckpoint) {
            this.standbyCheckpointer = new StandbyCheckpointer(conf, this);
            this.standbyCheckpointer.start();
        }
    }

    void prepareToStopStandbyServices() throws ServiceFailedException {
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.cancelAndPreventCheckpoints("About to leave standby state");
        }
    }

    void stopStandbyServices() throws IOException {
        LOG.info((Object)"Stopping services started for standby state");
        if (this.standbyCheckpointer != null) {
            this.standbyCheckpointer.stop();
        }
        if (this.editLogTailer != null) {
            this.editLogTailer.stop();
        }
        if (this.dir != null && this.dir.fsImage != null && this.dir.fsImage.editLog != null) {
            this.dir.fsImage.editLog.close();
        }
    }

    public void checkOperation(NameNode.OperationCategory op) throws StandbyException {
        if (this.haContext != null) {
            this.haContext.checkOperation(op);
        }
    }

    public static Collection<URI> getNamespaceDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.name.dir");
    }

    public static Collection<URI> getRequiredNamespaceEditsDirs(Configuration conf) {
        HashSet<URI> ret = new HashSet<URI>();
        ret.addAll(FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir.required"));
        ret.addAll(FSNamesystem.getSharedEditsDirs(conf));
        return ret;
    }

    private static Collection<URI> getStorageDirs(Configuration conf, String propertyName) {
        List<String> dirNames = conf.getTrimmedStringCollection(propertyName);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.IMPORT) {
            HdfsConfiguration cE = new HdfsConfiguration(false);
            cE.addResource("core-default.xml");
            cE.addResource("core-site.xml");
            cE.addResource("hdfs-default.xml");
            Collection dirNames2 = cE.getTrimmedStringCollection(propertyName);
            dirNames.removeAll(dirNames2);
            if (dirNames.isEmpty()) {
                LOG.warn((Object)("!!! WARNING !!!\n\tThe NameNode currently runs without persistent storage.\n\tAny changes to the file system meta-data may be lost.\n\tRecommended actions:\n\t\t- shutdown and restart NameNode with configured \"" + propertyName + "\" in hdfs-site.xml;" + "\n\t\t- use Backup Node as a persistent and up-to-date storage " + "of the file system meta-data."));
            }
        } else if (dirNames.isEmpty()) {
            dirNames = Collections.singletonList("file:///tmp/hadoop/dfs/name");
        }
        return Util.stringCollectionAsURIs((Collection<String>)dirNames);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf) throws IOException {
        return FSNamesystem.getNamespaceEditsDirs(conf, true);
    }

    public static List<URI> getNamespaceEditsDirs(Configuration conf, boolean includeShared) throws IOException {
        LinkedHashSet<URI> editsDirs = new LinkedHashSet<URI>();
        if (includeShared) {
            List<URI> sharedDirs = FSNamesystem.getSharedEditsDirs(conf);
            if (sharedDirs.size() > 1) {
                throw new IOException("Multiple shared edits directories are not yet supported");
            }
            for (URI dir : sharedDirs) {
                if (editsDirs.add(dir)) continue;
                LOG.warn((Object)("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + ". Ignoring duplicates."));
            }
        }
        for (URI dir : FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir")) {
            if (editsDirs.add(dir)) continue;
            LOG.warn((Object)("Edits URI " + dir + " listed multiple times in " + "dfs.namenode.shared.edits.dir" + " and " + "dfs.namenode.edits.dir" + ". Ignoring duplicates."));
        }
        if (editsDirs.isEmpty()) {
            return Lists.newArrayList(FSNamesystem.getNamespaceDirs(conf));
        }
        return Lists.newArrayList(editsDirs);
    }

    public static List<URI> getSharedEditsDirs(Configuration conf) {
        Collection dirNames = conf.getTrimmedStringCollection("dfs.namenode.shared.edits.dir");
        return Util.stringCollectionAsURIs(dirNames);
    }

    @Override
    public void readLock() {
        this.fsLock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.fsLock.readLock().unlock();
    }

    @Override
    public void writeLock() {
        this.fsLock.writeLock().lock();
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException {
        this.fsLock.writeLock().lockInterruptibly();
    }

    @Override
    public void writeUnlock() {
        this.fsLock.writeLock().unlock();
    }

    @Override
    public boolean hasWriteLock() {
        return this.fsLock.isWriteLockedByCurrentThread();
    }

    @Override
    public boolean hasReadLock() {
        return this.fsLock.getReadHoldCount() > 0;
    }

    @Override
    public boolean hasReadOrWriteLock() {
        return this.hasReadLock() || this.hasWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = this.unprotectedGetNamespaceInfo();
            return namespaceInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    NamespaceInfo unprotectedGetNamespaceInfo() {
        return new NamespaceInfo(this.dir.fsImage.getStorage().getNamespaceID(), this.getClusterId(), this.getBlockPoolId(), this.dir.fsImage.getStorage().getCTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        block8: {
            this.fsRunning = false;
            try {
                this.stopCommonServices();
                if (this.smmthread == null) break block8;
                this.smmthread.interrupt();
            }
            catch (Throwable throwable) {
                try {
                    this.stopActiveServices();
                    this.stopStandbyServices();
                    if (this.dir != null) {
                        this.dir.close();
                    }
                }
                catch (IOException ie) {
                    LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
                }
                throw throwable;
            }
        }
        try {
            this.stopActiveServices();
            this.stopStandbyServices();
            if (this.dir != null) {
                this.dir.close();
            }
        }
        catch (IOException ie) {
            LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
        }
    }

    @Override
    public boolean isRunning() {
        return this.fsRunning;
    }

    @Override
    public boolean isInStandbyState() {
        if (this.haContext == null || this.haContext.getState() == null) {
            return this.haEnabled;
        }
        return HAServiceProtocol.HAServiceState.STANDBY == this.haContext.getState().getServiceState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            File file = new File(System.getProperty("hadoop.log.dir"), filename);
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), Charsets.UTF_8)));
            this.metaSave(out);
            out.flush();
            out.close();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void metaSave(PrintWriter out) {
        assert (this.hasWriteLock());
        long totalInodes = this.dir.totalInodes();
        long totalBlocks = this.getBlocksTotal();
        out.println(totalInodes + " files and directories, " + totalBlocks + " blocks = " + (totalInodes + totalBlocks) + " total");
        this.blockManager.metaSave(out);
    }

    private String metaSaveAsString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.metaSave(pw);
        pw.flush();
        return sw.toString();
    }

    long getDefaultBlockSize() {
        return this.serverDefaults.getBlockSize();
    }

    FsServerDefaults getServerDefaults() throws StandbyException {
        this.checkOperation(NameNode.OperationCategory.READ);
        return this.serverDefaults;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            this.setPermissionInt(src, permission);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setPermission", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPermissionInt(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set permission for " + src, this.safeMode);
            }
            this.checkOwner(pc, src);
            this.dir.setPermission(src, permission);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setPermission", src, null, resultingStat);
    }

    void setOwner(String src, String username, String group) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            this.setOwnerInt(src, username, group);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setOwner", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOwnerInt(String src, String username, String group) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set owner for " + src, this.safeMode);
            }
            this.checkOwner(pc, src);
            if (!pc.isSuperUser()) {
                if (username != null && !pc.getUser().equals(username)) {
                    throw new AccessControlException("Non-super user cannot change owner");
                }
                if (group != null && !pc.containsGroup(group)) {
                    throw new AccessControlException("User does not belong to " + group);
                }
            }
            this.dir.setOwner(src, username, group);
            resultingStat = this.getAuditFileInfo(src, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "setOwner", src, null, resultingStat);
    }

    LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        LocatedBlocks blocks = this.getBlockLocations(src, offset, length, true, true, true);
        if (blocks != null) {
            this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, blocks.getLocatedBlocks());
            LocatedBlock lastBlock = blocks.getLastLocatedBlock();
            if (lastBlock != null) {
                ArrayList<LocatedBlock> lastBlockList = new ArrayList<LocatedBlock>();
                lastBlockList.add(lastBlock);
                this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, lastBlockList);
            }
        }
        return blocks;
    }

    LocatedBlocks getBlockLocations(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken, boolean checkSafeMode) throws FileNotFoundException, UnresolvedLinkException, IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        try {
            return this.getBlockLocationsInt(pc, src, offset, length, doAccessTime, needBlockToken, checkSafeMode);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "open", src);
            throw e;
        }
    }

    private LocatedBlocks getBlockLocationsInt(FSPermissionChecker pc, String src, long offset, long length, boolean doAccessTime, boolean needBlockToken, boolean checkSafeMode) throws FileNotFoundException, UnresolvedLinkException, IOException {
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, src, FsAction.READ);
        }
        if (offset < 0L) {
            throw new HadoopIllegalArgumentException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new HadoopIllegalArgumentException("Negative length is not supported. File: " + src);
        }
        LocatedBlocks ret = this.getBlockLocationsUpdateTimes(src, offset, length, doAccessTime, needBlockToken);
        this.logAuditEvent(true, "open", src);
        if (checkSafeMode && this.isInSafeMode()) {
            for (LocatedBlock b : ret.getLocatedBlocks()) {
                if (b.getLocations() != null && b.getLocations().length != 0) continue;
                throw new SafeModeException("Zero blocklocations for " + src, this.safeMode);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlocks getBlockLocationsUpdateTimes(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws FileNotFoundException, UnresolvedLinkException, IOException {
        for (int attempt = 0; attempt < 2; ++attempt) {
            if (attempt == 0) {
                this.readLock();
            } else {
                this.writeLock();
            }
            try {
                this.checkOperation(NameNode.OperationCategory.READ);
                if (this.isInSafeMode()) {
                    doAccessTime = false;
                }
                long now = Time.now();
                INodeFile inode = INodeFile.valueOf(this.dir.getINode(src), src);
                if (doAccessTime && this.isAccessTimeSupported()) {
                    if (now <= inode.getAccessTime() + this.getAccessTimePrecision() && attempt == 0) continue;
                    this.dir.setTimes(src, inode, -1L, now, false);
                }
                LocatedBlocks locatedBlocks = this.blockManager.createLocatedBlocks(inode.getBlocks(), inode.computeFileSize(false), inode.isUnderConstruction(), offset, length, needBlockToken);
                return locatedBlocks;
            }
            finally {
                if (attempt == 0) {
                    this.readUnlock();
                } else {
                    this.writeUnlock();
                }
            }
        }
        return null;
    }

    void concat(String target, String[] srcs) throws IOException, UnresolvedLinkException {
        try {
            this.concatInt(target, srcs);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "concat", Arrays.toString(srcs), target, null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatInt(String target, String[] srcs) throws IOException, UnresolvedLinkException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat " + Arrays.toString(srcs) + " to " + target));
        }
        if (target.isEmpty()) {
            throw new IllegalArgumentException("Target file name is empty");
        }
        if (srcs == null || srcs.length == 0) {
            throw new IllegalArgumentException("No sources given");
        }
        String trgParent = target.substring(0, target.lastIndexOf(47));
        for (String s : srcs) {
            String srcParent = s.substring(0, s.lastIndexOf(47));
            if (srcParent.equals(trgParent)) continue;
            throw new IllegalArgumentException("Sources and target are not in the same directory");
        }
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot concat " + target, this.safeMode);
            }
            this.concatInternal(pc, target, srcs);
            resultingStat = this.getAuditFileInfo(target, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "concat", Arrays.toString(srcs), target, resultingStat);
    }

    private void concatInternal(FSPermissionChecker pc, String target, String[] srcs) throws IOException, UnresolvedLinkException {
        BlockInfo last;
        assert (this.hasWriteLock());
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, target, FsAction.WRITE);
            for (String aSrc : srcs) {
                this.checkPathAccess(pc, aSrc, FsAction.READ);
                this.checkParentAccess(pc, aSrc, FsAction.WRITE);
            }
        }
        HashSet<INodeFile> si = new HashSet<INodeFile>();
        INodeFile trgInode = INodeFile.valueOf(this.dir.getINode(target), target);
        if (trgInode.isUnderConstruction()) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is under construction");
        }
        if (trgInode.numBlocks() == 0) {
            throw new HadoopIllegalArgumentException("concat: target file " + target + " is empty");
        }
        long blockSize = trgInode.getPreferredBlockSize();
        if (blockSize != (last = trgInode.getLastBlock()).getNumBytes()) {
            throw new HadoopIllegalArgumentException("The last block in " + target + " is not full; last block size = " + last.getNumBytes() + " but file block size = " + blockSize);
        }
        si.add(trgInode);
        short repl = trgInode.getBlockReplication();
        boolean endSrc = false;
        for (int i = 0; i < srcs.length; ++i) {
            String src = srcs[i];
            if (i == srcs.length - 1) {
                endSrc = true;
            }
            INodeFile srcInode = INodeFile.valueOf(this.dir.getINode(src), src);
            if (src.isEmpty() || srcInode.isUnderConstruction() || srcInode.numBlocks() == 0) {
                throw new HadoopIllegalArgumentException("concat: source file " + src + " is invalid or empty or underConstruction");
            }
            if (repl != srcInode.getBlockReplication()) {
                throw new HadoopIllegalArgumentException("concat: the soruce file " + src + " and the target file " + target + " should have the same replication: source replication is " + srcInode.getBlockReplication() + " but target replication is " + repl);
            }
            BlockInfo[] srcBlocks = srcInode.getBlocks();
            int idx = srcBlocks.length - 1;
            if (endSrc) {
                idx = srcBlocks.length - 2;
            }
            if (idx >= 0 && srcBlocks[idx].getNumBytes() != blockSize) {
                throw new HadoopIllegalArgumentException("concat: the soruce file " + src + " and the target file " + target + " should have the same blocks sizes: target block size is " + blockSize + " but the size of source block " + idx + " is " + srcBlocks[idx].getNumBytes());
            }
            si.add(srcInode);
        }
        if (si.size() < srcs.length + 1) {
            throw new HadoopIllegalArgumentException("concat: at least two of the source files are the same");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target));
        }
        this.dir.concat(target, srcs);
    }

    void setTimes(String src, long mtime, long atime) throws IOException, UnresolvedLinkException {
        try {
            this.setTimesInt(src, mtime, atime);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setTimes", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimesInt(String src, long mtime, long atime) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat;
        block6: {
            if (!this.isAccessTimeSupported() && atime != -1L) {
                throw new IOException("Access time for hdfs is not configured.  Please set dfs.namenode.accesstime.precision configuration parameter.");
            }
            resultingStat = null;
            FSPermissionChecker pc = this.getPermissionChecker();
            this.writeLock();
            try {
                INode inode;
                this.checkOperation(NameNode.OperationCategory.WRITE);
                if (this.isPermissionEnabled) {
                    this.checkPathAccess(pc, src, FsAction.WRITE);
                }
                if ((inode = this.dir.getINode(src)) != null) {
                    this.dir.setTimes(src, inode, mtime, atime, true);
                    resultingStat = this.getAuditFileInfo(src, false);
                    break block6;
                }
                throw new FileNotFoundException("File/Directory " + src + " does not exist.");
            }
            finally {
                this.writeUnlock();
            }
        }
        this.logAuditEvent(true, "setTimes", src, null, resultingStat);
    }

    void createSymlink(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        try {
            this.createSymlinkInt(target, link, dirPerms, createParent);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createSymlink", link, target, null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSymlinkInt(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (!createParent) {
                this.verifyParentDir(link);
            }
            this.createSymlinkInternal(pc, target, link, dirPerms, createParent);
            resultingStat = this.getAuditFileInfo(link, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.logAuditEvent(true, "createSymlink", link, target, resultingStat);
    }

    private void createSymlinkInternal(FSPermissionChecker pc, String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.createSymlink: target=" + target + " link=" + link));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create symlink " + link, this.safeMode);
        }
        if (!DFSUtil.isValidName(link)) {
            throw new InvalidPathException("Invalid file name: " + link);
        }
        if (!this.dir.isValidToCreate(link)) {
            throw new IOException("failed to create link " + link + " either because the filename is invalid or the file exists");
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(pc, link, FsAction.WRITE);
        }
        this.checkFsObjectLimit();
        this.dir.addSymlink(link, target, dirPerms, createParent);
    }

    boolean setReplication(String src, short replication) throws IOException {
        try {
            return this.setReplicationInt(src, replication);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setReplication", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setReplicationInt(String src, short replication) throws IOException {
        boolean isFile;
        this.blockManager.verifyReplication(src, replication, null);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            short[] oldReplication;
            Block[] blocks;
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set replication for " + src, this.safeMode);
            }
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            boolean bl = isFile = (blocks = this.dir.setReplication(src, replication, oldReplication = new short[1])) != null;
            if (isFile) {
                this.blockManager.setReplication(oldReplication[0], replication, src, blocks);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (isFile) {
            this.logAuditEvent(true, "setReplication", src);
        }
        return isFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, filename);
            }
            long l = this.dir.getPreferredBlockSize(filename);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    private void verifyParentDir(String src) throws FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException {
        assert (this.hasReadOrWriteLock());
        Path parent = new Path(src).getParent();
        if (parent != null) {
            INode[] pathINodes = this.dir.getExistingPathINodes(parent.toString());
            INode parentNode = pathINodes[pathINodes.length - 1];
            if (parentNode == null) {
                throw new FileNotFoundException("Parent directory doesn't exist: " + parent.toString());
            }
            if (!parentNode.isDirectory() && !parentNode.isSymlink()) {
                throw new ParentNotDirectoryException("Parent path is not a directory: " + parent.toString());
            }
        }
    }

    void startFile(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, SafeModeException, FileAlreadyExistsException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        try {
            this.startFileInt(src, permissions, holder, clientMachine, flag, createParent, replication, blockSize);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "create", src);
            throw e;
        }
    }

    private void startFileInt(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, SafeModeException, FileAlreadyExistsException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        boolean skipSync = false;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.startFileInternal(pc, src, permissions, holder, clientMachine, flag, createParent, replication, blockSize);
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock();
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
        HdfsFileStatus stat = this.getAuditFileInfo(src, false);
        this.logAuditEvent(true, "create", src, null, stat);
    }

    private LocatedBlock startFileInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws SafeModeException, FileAlreadyExistsException, AccessControlException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine + ", createParent=" + createParent + ", replication=" + replication + ", createFlag=" + flag.toString()));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create file" + src, this.safeMode);
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        boolean pathExists = this.dir.exists(src);
        if (pathExists && this.dir.isDir(src)) {
            throw new FileAlreadyExistsException("Cannot create file " + src + "; already exists as a directory.");
        }
        boolean overwrite = flag.contains(CreateFlag.OVERWRITE);
        boolean append = flag.contains(CreateFlag.APPEND);
        if (this.isPermissionEnabled) {
            if (append || overwrite && pathExists) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            } else {
                this.checkAncestorAccess(pc, src, FsAction.WRITE);
            }
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        try {
            this.blockManager.verifyReplication(src, replication, clientMachine);
            boolean create = flag.contains(CreateFlag.CREATE);
            INode myFile = this.dir.getINode(src);
            if (myFile == null) {
                if (!create) {
                    throw new FileNotFoundException("failed to overwrite or append to non-existent file " + src + " on client " + clientMachine);
                }
            } else if (overwrite) {
                this.delete(src, true);
            } else {
                this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
                if (!append) {
                    throw new FileAlreadyExistsException("failed to create file " + src + " on client " + clientMachine + " because the file exists");
                }
            }
            DatanodeDescriptor clientNode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
            if (append && myFile != null) {
                INodeFile f = INodeFile.valueOf(myFile, src);
                return this.prepareFileForWrite(src, f, holder, clientMachine, clientNode, true);
            }
            this.checkFsObjectLimit();
            long genstamp = this.nextGenerationStamp();
            INodeFileUnderConstruction newNode = this.dir.addFile(src, permissions, replication, blockSize, holder, clientMachine, clientNode, genstamp);
            if (newNode == null) {
                throw new IOException("DIR* NameSystem.startFile: Unable to add file to namespace.");
            }
            this.leaseManager.addLease(newNode.getClientName(), src);
            this.getEditLog().logOpenFile(src, newNode);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: add " + src + " to namespace for " + holder));
            }
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.startFile: " + ie.getMessage()));
            throw ie;
        }
        return null;
    }

    LocatedBlock prepareFileForWrite(String src, INodeFile file, String leaseHolder, String clientMachine, DatanodeDescriptor clientNode, boolean writeToEditLog) throws IOException {
        INodeFileUnderConstruction cons = new INodeFileUnderConstruction(file.getLocalNameBytes(), file.getBlockReplication(), file.getModificationTime(), file.getPreferredBlockSize(), file.getBlocks(), file.getPermissionStatus(), leaseHolder, clientMachine, clientNode);
        this.dir.replaceNode(src, file, cons);
        this.leaseManager.addLease(cons.getClientName(), src);
        LocatedBlock ret = this.blockManager.convertLastBlockToUnderConstruction(cons);
        if (writeToEditLog) {
            this.getEditLog().logOpenFile(src, cons);
        }
        return ret;
    }

    boolean recoverLease(String src, String holder, String clientMachine) throws IOException {
        boolean skipSync = false;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot recover the lease of " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(src)) {
                throw new IOException("Invalid file name: " + src);
            }
            INodeFile inode = INodeFile.valueOf(this.dir.getINode(src), src);
            if (!inode.isUnderConstruction()) {
                boolean bl = true;
                return bl;
            }
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            this.recoverLeaseInternal(inode, src, holder, clientMachine, true);
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock();
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
        return false;
    }

    private void recoverLeaseInternal(INode fileInode, String src, String holder, String clientMachine, boolean force) throws IOException {
        assert (this.hasWriteLock());
        if (fileInode != null && fileInode.isUnderConstruction()) {
            LeaseManager.Lease leaseFile;
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)fileInode;
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && ((leaseFile = this.leaseManager.getLeaseByPath(src)) != null && leaseFile.equals(lease) || lease.getHolder().equals(holder))) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because current leaseholder is trying to recreate file.");
            }
            lease = this.leaseManager.getLease(pendingFile.getClientName());
            if (lease == null) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because pendingCreates is non-null but no leases found.");
            }
            if (force) {
                LOG.info((Object)("recoverLease: " + lease + ", src=" + src + " from client " + pendingFile.getClientName()));
                this.internalReleaseLease(lease, src, holder);
            } else {
                assert (lease.getHolder().equals(pendingFile.getClientName())) : "Current lease holder " + lease.getHolder() + " does not match file creator " + pendingFile.getClientName();
                if (lease.expiredSoftLimit()) {
                    LOG.info((Object)("startFile: recover " + lease + ", src=" + src + " client " + pendingFile.getClientName()));
                    boolean isClosed = this.internalReleaseLease(lease, src, null);
                    if (!isClosed) {
                        throw new RecoveryInProgressException("Failed to close file " + src + ". Lease recovery is in progress. Try again later.");
                    }
                } else {
                    BlockInfo lastBlock = pendingFile.getLastBlock();
                    if (lastBlock != null && lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY) {
                        throw new RecoveryInProgressException("Recovery in progress, file [" + src + "], " + "lease owner [" + lease.getHolder() + "]");
                    }
                    throw new AlreadyBeingCreatedException("Failed to create file [" + src + "] for [" + holder + "] on client [" + clientMachine + "], because this file is already being created by [" + pendingFile.getClientName() + "] on [" + pendingFile.getClientMachine() + "]");
                }
            }
        }
    }

    LocatedBlock appendFile(String src, String holder, String clientMachine) throws AccessControlException, SafeModeException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        try {
            return this.appendFileInt(src, holder, clientMachine);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "append", src);
            throw e;
        }
    }

    private LocatedBlock appendFileInt(String src, String holder, String clientMachine) throws AccessControlException, SafeModeException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        boolean skipSync = false;
        if (!this.supportAppends) {
            throw new UnsupportedOperationException("Append is not enabled on this NameNode. Use the dfs.support.append configuration option to enable it.");
        }
        LocatedBlock lb = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            lb = this.startFileInternal(pc, src, null, holder, clientMachine, EnumSet.of(CreateFlag.APPEND), false, this.blockManager.maxReplication, 0L);
        }
        catch (StandbyException se) {
            skipSync = true;
            throw se;
        }
        finally {
            this.writeUnlock();
            if (!skipSync) {
                this.getEditLog().logSync();
            }
        }
        if (lb != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: file " + src + " for " + holder + " at " + clientMachine + " block " + lb.getBlock() + " block size " + lb.getBlock().getNumBytes()));
        }
        this.logAuditEvent(true, "append", src);
        return lb;
    }

    ExtendedBlock getExtendedBlock(Block blk) {
        return new ExtendedBlock(this.blockPoolId, blk);
    }

    void setBlockPoolId(String bpid) {
        this.blockPoolId = bpid;
        this.blockManager.setBlockPoolId(this.blockPoolId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalBlock(String src, String clientName, ExtendedBlock previous, HashMap<Node, Node> excludedNodes) throws LeaseExpiredException, NotReplicatedYetException, QuotaExceededException, SafeModeException, UnresolvedLinkException, IOException {
        long offset;
        short replication;
        long blockSize;
        DatanodeDescriptor clientNode = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.getAdditionalBlock: file " + src + " for " + clientName));
        }
        this.readLock();
        try {
            LocatedBlock[] onRetryBlock = new LocatedBlock[1];
            INode[] inodes = this.analyzeFileState(src, clientName, previous, onRetryBlock);
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)inodes[inodes.length - 1];
            if (onRetryBlock[0] != null) {
                LocatedBlock locatedBlock = onRetryBlock[0];
                return locatedBlock;
            }
            blockSize = pendingFile.getPreferredBlockSize();
            clientNode = pendingFile.getClientNode();
            replication = pendingFile.getBlockReplication();
        }
        finally {
            this.readUnlock();
        }
        DatanodeInfo[] targets = this.getBlockManager().chooseTarget(src, replication, clientNode, excludedNodes, blockSize);
        Block newBlock = null;
        this.writeLock();
        try {
            LocatedBlock[] onRetryBlock = new LocatedBlock[1];
            INode[] inodes = this.analyzeFileState(src, clientName, previous, onRetryBlock);
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)inodes[inodes.length - 1];
            if (onRetryBlock[0] != null) {
                LocatedBlock locatedBlock = onRetryBlock[0];
                return locatedBlock;
            }
            this.commitOrCompleteLastBlock(pendingFile, ExtendedBlock.getLocalBlock(previous));
            newBlock = this.createNewBlock();
            this.saveAllocatedBlock(src, inodes, newBlock, (DatanodeDescriptor[])targets);
            this.dir.persistBlocks(src, pendingFile);
            offset = pendingFile.computeFileSize(true);
        }
        finally {
            this.writeUnlock();
        }
        if (this.persistBlocks) {
            this.getEditLog().logSync();
        }
        return this.makeLocatedBlock(newBlock, targets, offset);
    }

    INode[] analyzeFileState(String src, String clientName, ExtendedBlock previous, LocatedBlock[] onRetryBlock) throws IOException {
        assert (this.hasReadOrWriteLock());
        this.checkBlock(previous);
        onRetryBlock[0] = null;
        this.checkOperation(NameNode.OperationCategory.WRITE);
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot add block to " + src, this.safeMode);
        }
        this.checkFsObjectLimit();
        Block previousBlock = ExtendedBlock.getLocalBlock(previous);
        INode[] inodes = this.dir.rootDir.getExistingPathINodes(src, true);
        INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName, inodes[inodes.length - 1]);
        BlockInfo lastBlockInFile = pendingFile.getLastBlock();
        if (!Block.matchingIdAndGenStamp(previousBlock, lastBlockInFile)) {
            BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
            if (previous == null && lastBlockInFile != null && lastBlockInFile.getNumBytes() == pendingFile.getPreferredBlockSize() && lastBlockInFile.isComplete()) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.allocateBlock: handling block allocation writing to a file with a complete previous block: src=" + src + " lastBlock=" + lastBlockInFile));
                }
            } else {
                if (Block.matchingIdAndGenStamp(penultimateBlock, previousBlock)) {
                    if (lastBlockInFile.getNumBytes() != 0L) {
                        throw new IOException("Request looked like a retry to allocate block " + lastBlockInFile + " but it already contains " + lastBlockInFile.getNumBytes() + " bytes");
                    }
                    NameNode.stateChangeLog.info((Object)("BLOCK* allocateBlock: caught retry for allocation of a new block in " + src + ". Returning previously allocated block " + lastBlockInFile));
                    long offset = pendingFile.computeFileSize(true);
                    onRetryBlock[0] = this.makeLocatedBlock(lastBlockInFile, ((BlockInfoUnderConstruction)lastBlockInFile).getExpectedLocations(), offset);
                    return inodes;
                }
                throw new IOException("Cannot allocate block in " + src + ": " + "passed 'previous' block " + previous + " does not match actual " + "last block in file " + lastBlockInFile);
            }
        }
        if (!this.checkFileProgress(pendingFile, false)) {
            throw new NotReplicatedYetException("Not replicated yet: " + src);
        }
        return inodes;
    }

    LocatedBlock makeLocatedBlock(Block blk, DatanodeInfo[] locs, long offset) throws IOException {
        LocatedBlock lBlk = new LocatedBlock(this.getExtendedBlock(blk), locs, offset);
        this.getBlockManager().setBlockToken(lBlk, BlockTokenSecretManager.AccessMode.WRITE);
        return lBlk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock getAdditionalDatanode(String src, ExtendedBlock blk, DatanodeInfo[] existings, HashMap<Node, Node> excludes, int numAdditionalNodes, String clientName) throws IOException {
        ArrayList<DatanodeDescriptor> chosen;
        long preferredblocksize;
        DatanodeDescriptor clientnode;
        this.dtpReplaceDatanodeOnFailure.checkEnabled();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add datanode; src=" + src + ", blk=" + blk, this.safeMode);
            }
            INodeFileUnderConstruction file = this.checkLease(src, clientName);
            clientnode = file.getClientNode();
            preferredblocksize = file.getPreferredBlockSize();
            chosen = new ArrayList<DatanodeDescriptor>();
            for (DatanodeInfo d : existings) {
                DatanodeDescriptor descriptor = this.blockManager.getDatanodeManager().getDatanode(d);
                if (descriptor == null) continue;
                chosen.add(descriptor);
            }
        }
        finally {
            this.readUnlock();
        }
        DatanodeInfo[] targets = this.blockManager.getBlockPlacementPolicy().chooseTarget(src, numAdditionalNodes, clientnode, chosen, true, excludes, preferredblocksize);
        LocatedBlock lb = new LocatedBlock(blk, targets);
        this.blockManager.setBlockToken(lb, BlockTokenSecretManager.AccessMode.COPY);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean abandonBlock(ExtendedBlock b, String src, String holder) throws LeaseExpiredException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + "of file " + src));
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot abandon block " + b + " for fle" + src, this.safeMode);
            }
            INodeFileUnderConstruction file = this.checkLease(src, holder);
            this.dir.removeBlock(src, file, ExtendedBlock.getLocalBlock(b));
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + " is removed from pendingCreates"));
            }
            this.dir.persistBlocks(src, file);
        }
        finally {
            this.writeUnlock();
        }
        if (this.persistBlocks) {
            this.getEditLog().logSync();
        }
        return true;
    }

    private INodeFileUnderConstruction checkLease(String src, String holder) throws LeaseExpiredException, UnresolvedLinkException {
        assert (this.hasReadOrWriteLock());
        return this.checkLease(src, holder, this.dir.getINode(src));
    }

    private INodeFileUnderConstruction checkLease(String src, String holder, INode file) throws LeaseExpiredException {
        assert (this.hasReadOrWriteLock());
        if (file == null || !(file instanceof INodeFile)) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + ": File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        if (!file.isUnderConstruction()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + ": File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (holder != null && !pendingFile.getClientName().equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + pendingFile.getClientName() + " but is accessed by " + holder);
        }
        return pendingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean completeFile(String src, String holder, ExtendedBlock last) throws SafeModeException, UnresolvedLinkException, IOException {
        this.checkBlock(last);
        boolean success = false;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            success = this.completeFileInternal(src, holder, ExtendedBlock.getLocalBlock(last));
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return success;
    }

    private boolean completeFileInternal(String src, String holder, Block last) throws SafeModeException, UnresolvedLinkException, IOException {
        INodeFileUnderConstruction pendingFile;
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " for " + holder));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot complete file " + src, this.safeMode);
        }
        try {
            pendingFile = this.checkLease(src, holder);
        }
        catch (LeaseExpiredException lee) {
            BlockInfo realLastBlock;
            INode inode = this.dir.getINode(src);
            if (inode != null && inode instanceof INodeFile && !inode.isUnderConstruction() && Block.matchingIdAndGenStamp(last, realLastBlock = ((INodeFile)inode).getLastBlock())) {
                NameNode.stateChangeLog.info((Object)("DIR* completeFile: request from " + holder + " to complete " + src + " which is already closed. But, it appears to be an RPC " + "retry. Returning success"));
                return true;
            }
            throw lee;
        }
        this.commitOrCompleteLastBlock(pendingFile, last);
        if (!this.checkFileProgress(pendingFile, true)) {
            return false;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        NameNode.stateChangeLog.info((Object)("DIR* completeFile: " + src + " is closed by " + holder));
        return true;
    }

    BlockInfo saveAllocatedBlock(String src, INode[] inodes, Block newBlock, DatanodeDescriptor[] targets) throws IOException {
        assert (this.hasWriteLock());
        BlockInfo b = this.dir.addBlock(src, inodes, newBlock, targets);
        NameNode.stateChangeLog.info((Object)("BLOCK* allocateBlock: " + src + ". " + this.getBlockPoolId() + " " + b));
        for (DatanodeDescriptor dn : targets) {
            dn.incBlocksScheduled();
        }
        return b;
    }

    Block createNewBlock() throws IOException {
        assert (this.hasWriteLock());
        Block b = new Block(this.getFSImage().getUniqueBlockId(), 0L, 0L);
        this.nextGenerationStamp();
        b.setGenerationStamp(this.getGenerationStamp());
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileProgress(INodeFile v, boolean checkall) {
        this.readLock();
        try {
            if (checkall) {
                for (BlockInfo block : v.getBlocks()) {
                    if (block.isComplete()) continue;
                    LOG.info((Object)("BLOCK* checkFileProgress: " + block + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            } else {
                BlockInfo b = v.getPenultimateBlock();
                if (b != null && !b.isComplete()) {
                    LOG.info((Object)("BLOCK* checkFileProgress: " + b + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Deprecated
    boolean renameTo(String src, String dst) throws IOException, UnresolvedLinkException {
        try {
            return this.renameToInt(src, dst);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename", src, dst, null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameToInt(String src, String dst) throws IOException, UnresolvedLinkException {
        boolean status = false;
        HdfsFileStatus resultingStat = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: " + src + " to " + dst));
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            status = this.renameToInternal(pc, src, dst);
            if (status) {
                resultingStat = this.getAuditFileInfo(dst, false);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (status) {
            this.logAuditEvent(true, "rename", src, dst, resultingStat);
        }
        return status;
    }

    @Deprecated
    private boolean renameToInternal(FSPermissionChecker pc, String src, String dst) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot rename " + src, this.safeMode);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new IOException("Invalid name: " + dst);
        }
        if (this.isPermissionEnabled) {
            String actualdst = this.dir.isDir(dst) ? dst + "/" + new Path(src).getName() : dst;
            this.checkParentAccess(pc, src, FsAction.WRITE);
            this.checkAncestorAccess(pc, actualdst, FsAction.WRITE);
        }
        return this.dir.renameTo(src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameTo(String src, String dst, Options.Rename ... options) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: with options - " + src + " to " + dst));
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.renameToInternal(pc, src, dst, options);
            resultingStat = this.getAuditFileInfo(dst, false);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (resultingStat != null) {
            StringBuilder cmd = new StringBuilder("rename options=");
            for (Options.Rename option : options) {
                cmd.append(option.value()).append(" ");
            }
            this.logAuditEvent(true, cmd.toString(), src, dst, resultingStat);
        }
    }

    private void renameToInternal(FSPermissionChecker pc, String src, String dst, Options.Rename ... options) throws IOException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot rename " + src, this.safeMode);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new InvalidPathException("Invalid name: " + dst);
        }
        if (this.isPermissionEnabled) {
            this.checkParentAccess(pc, src, FsAction.WRITE);
            this.checkAncestorAccess(pc, dst, FsAction.WRITE);
        }
        this.dir.renameTo(src, dst, options);
    }

    boolean delete(String src, boolean recursive) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        try {
            return this.deleteInt(src, recursive);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "delete", src);
            throw e;
        }
    }

    private boolean deleteInt(String src, boolean recursive) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        boolean status;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.delete: " + src));
        }
        if (status = this.deleteInternal(src, recursive, true)) {
            this.logAuditEvent(true, "delete", src);
        }
        return status;
    }

    private FSPermissionChecker getPermissionChecker() throws AccessControlException {
        return new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteInternal(String src, boolean recursive, boolean enforcePermission) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        ArrayList<Block> collectedBlocks = new ArrayList<Block>();
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot delete " + src, this.safeMode);
            }
            if (!recursive && this.dir.isNonEmptyDirectory(src)) {
                throw new IOException(src + " is non empty");
            }
            if (enforcePermission && this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, FsAction.WRITE, null, FsAction.ALL);
            }
            if (!this.dir.delete(src, collectedBlocks)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        this.removeBlocks(collectedBlocks);
        collectedBlocks.clear();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* Namesystem.delete: " + src + " is removed"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlocks(List<Block> blocks) {
        int start = 0;
        int end = 0;
        while (start < blocks.size()) {
            end = BLOCK_DELETION_INCREMENT + start;
            end = end > blocks.size() ? blocks.size() : end;
            this.writeLock();
            try {
                for (int i = start; i < end; ++i) {
                    this.blockManager.removeBlock(blocks.get(i));
                }
            }
            finally {
                this.writeUnlock();
            }
            start = end;
        }
    }

    void removePathAndBlocks(String src, List<Block> blocks) {
        assert (this.hasWriteLock());
        this.leaseManager.removeLeaseWithPrefixPath(src);
        if (blocks == null) {
            return;
        }
        boolean trackBlockCounts = this.isSafeModeTrackingBlocks();
        int numRemovedComplete = 0;
        int numRemovedSafe = 0;
        for (Block b : blocks) {
            BlockInfo bi;
            if (trackBlockCounts && (bi = this.blockManager.getStoredBlock(b)).isComplete()) {
                ++numRemovedComplete;
                if (bi.numNodes() >= this.blockManager.minReplication) {
                    ++numRemovedSafe;
                }
            }
            this.blockManager.removeBlock(b);
        }
        if (trackBlockCounts) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adjusting safe-mode totals for deletion of " + src + ":" + "decreasing safeBlocks by " + numRemovedSafe + ", totalBlocks by " + numRemovedComplete));
            }
            this.adjustSafeModeBlockTotals(-numRemovedSafe, -numRemovedComplete);
        }
    }

    private boolean isSafeModeTrackingBlocks() {
        if (!this.haEnabled) {
            return false;
        }
        SafeModeInfo sm = this.safeMode;
        return sm != null && sm.shouldIncrementallyTrackBlocks();
    }

    HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws AccessControlException, UnresolvedLinkException, StandbyException, IOException {
        HdfsFileStatus stat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (!DFSUtil.isValidName(src)) {
                throw new InvalidPathException("Invalid file name: " + src);
            }
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, src);
            }
            stat = this.dir.getFileInfo(src, resolveLink);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "getfileinfo", src);
            throw e;
        }
        finally {
            this.readUnlock();
        }
        this.logAuditEvent(true, "getfileinfo", src);
        return stat;
    }

    boolean mkdirs(String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        try {
            return this.mkdirsInt(src, permissions, createParent);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "mkdirs", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mkdirsInt(String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        HdfsFileStatus resultingStat = null;
        boolean status = false;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.mkdirs: " + src));
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            status = this.mkdirsInternal(pc, src, permissions, createParent);
            if (status) {
                resultingStat = this.dir.getFileInfo(src, false);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (status) {
            this.logAuditEvent(true, "mkdirs", src, null, resultingStat);
        }
        return status;
    }

    private boolean mkdirsInternal(FSPermissionChecker pc, String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create directory " + src, this.safeMode);
        }
        if (this.isPermissionEnabled) {
            this.checkTraverse(pc, src);
        }
        if (this.dir.isDir(src)) {
            return true;
        }
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(pc, src, FsAction.WRITE);
        }
        if (!createParent) {
            this.verifyParentDir(src);
        }
        this.checkFsObjectLimit();
        if (!this.dir.mkdirs(src, permissions, false, Time.now())) {
            throw new IOException("Failed to create directory: " + src);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, StandbyException {
        FSPermissionChecker pc = new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup);
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, null, null, FsAction.READ_EXECUTE);
            }
            ContentSummary contentSummary = this.dir.getContentSummary(src);
            return contentSummary;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String path, long nsQuota, long dsQuota) throws IOException, UnresolvedLinkException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set quota on " + path, this.safeMode);
            }
            this.dir.setQuota(path, nsQuota, dsQuota);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, String clientName, long lastBlockLength) throws IOException, UnresolvedLinkException {
        NameNode.stateChangeLog.info((Object)("BLOCK* fsync: " + src + " for " + clientName));
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot fsync file " + src, this.safeMode);
            }
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            if (lastBlockLength > 0L) {
                pendingFile.updateLengthOfLastBlock(lastBlockLength);
            }
            this.dir.persistBlocks(src, pendingFile);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    boolean internalReleaseLease(LeaseManager.Lease lease, String src, String recoveryLeaseHolder) throws AlreadyBeingCreatedException, IOException, UnresolvedLinkException {
        boolean penultimateBlockMinReplication;
        HdfsServerConstants.BlockUCState penultimateBlockState;
        int nrCompleteBlocks;
        LOG.info((Object)("Recovering " + lease + ", src=" + src));
        assert (!this.isInSafeMode());
        assert (this.hasWriteLock());
        INodeFileUnderConstruction pendingFile = INodeFileUnderConstruction.valueOf(this.dir.getINode(src), src);
        int nrBlocks = pendingFile.numBlocks();
        BlockInfo[] blocks = pendingFile.getBlocks();
        BlockInfo curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.checkMinReplication(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile);
            NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock != null && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        BlockInfo lastBlock = pendingFile.getLastBlock();
        HdfsServerConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
        if (penultimateBlock == null) {
            penultimateBlockState = HdfsServerConstants.BlockUCState.COMPLETE;
            penultimateBlockMinReplication = true;
        } else {
            penultimateBlockState = HdfsServerConstants.BlockUCState.COMMITTED;
            penultimateBlockMinReplication = this.blockManager.checkMinReplication(penultimateBlock);
        }
        assert (penultimateBlockState == HdfsServerConstants.BlockUCState.COMPLETE || penultimateBlockState == HdfsServerConstants.BlockUCState.COMMITTED) : "Unexpected state of penultimate block in " + src;
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinReplication && this.blockManager.checkMinReplication(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile);
                    NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated." + " Try again later.";
                NameNode.stateChangeLog.warn((Object)message);
                throw new AlreadyBeingCreatedException(message);
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                BlockInfoUnderConstruction uc = (BlockInfoUnderConstruction)lastBlock;
                if (uc.getNumExpectedLocations() == 0) {
                    uc.setExpectedLocations(this.blockManager.getNodes(lastBlock));
                }
                long blockRecoveryId = this.nextGenerationStamp();
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                uc.initializeBlockRecovery(blockRecoveryId);
                this.leaseManager.renewLease(lease);
                NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed." + " Lease recovery is in progress. " + "RecoveryId = " + blockRecoveryId + " for block " + lastBlock));
            }
        }
        return false;
    }

    private LeaseManager.Lease reassignLease(LeaseManager.Lease lease, String src, String newHolder, INodeFileUnderConstruction pendingFile) {
        assert (this.hasWriteLock());
        if (newHolder == null) {
            return lease;
        }
        this.logReassignLease(lease.getHolder(), src, newHolder);
        return this.reassignLeaseInternal(lease, src, newHolder, pendingFile);
    }

    LeaseManager.Lease reassignLeaseInternal(LeaseManager.Lease lease, String src, String newHolder, INodeFileUnderConstruction pendingFile) {
        assert (this.hasWriteLock());
        pendingFile.setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, src, newHolder);
    }

    private void commitOrCompleteLastBlock(INodeFileUnderConstruction fileINode, Block commitBlock) throws IOException {
        assert (this.hasWriteLock());
        if (!this.blockManager.commitOrCompleteLastBlock(fileINode, commitBlock)) {
            return;
        }
        long diff = fileINode.getPreferredBlockSize() - commitBlock.getNumBytes();
        if (diff > 0L) {
            try {
                String path = this.leaseManager.findPath(fileINode);
                this.dir.updateSpaceConsumed(path, 0L, -diff * (long)fileINode.getBlockReplication());
            }
            catch (IOException e) {
                LOG.warn((Object)"Unexpected exception while updating disk space.", (Throwable)e);
            }
        }
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFileUnderConstruction pendingFile) throws IOException, UnresolvedLinkException {
        assert (this.hasWriteLock());
        this.leaseManager.removeLease(pendingFile.getClientName(), src);
        INodeFile newFile = pendingFile.convertToInodeFile();
        this.dir.replaceNode(src, pendingFile, newFile);
        this.dir.closeFile(src, newFile);
        this.blockManager.checkReplication(newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitBlockSynchronization(ExtendedBlock lastblock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException, UnresolvedLinkException {
        String src = "";
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot commitBlockSynchronization while in safe mode", this.safeMode);
            }
            LOG.info((Object)("commitBlockSynchronization(lastblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteblock + ")"));
            BlockInfo storedBlock = this.blockManager.getStoredBlock(ExtendedBlock.getLocalBlock(lastblock));
            if (storedBlock == null) {
                throw new IOException("Block (=" + lastblock + ") not found");
            }
            INodeFile iFile = (INodeFile)storedBlock.getBlockCollection();
            if (!iFile.isUnderConstruction() || storedBlock.isComplete()) {
                throw new IOException("Unexpected block (=" + lastblock + ") since the file (=" + iFile.getLocalName() + ") is not under construction");
            }
            long recoveryId = ((BlockInfoUnderConstruction)storedBlock).getBlockRecoveryId();
            if (recoveryId != newgenerationstamp) {
                throw new IOException("The recovery id " + newgenerationstamp + " does not match current recovery id " + recoveryId + " for block " + lastblock);
            }
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)iFile;
            if (deleteblock) {
                pendingFile.removeLastBlock(ExtendedBlock.getLocalBlock(lastblock));
                this.blockManager.removeBlockFromMap(storedBlock);
            } else {
                int i;
                storedBlock.setGenerationStamp(newgenerationstamp);
                storedBlock.setNumBytes(newlength);
                DatanodeDescriptor[] descriptors = null;
                if (newtargets.length > 0) {
                    descriptors = new DatanodeDescriptor[newtargets.length];
                    for (i = 0; i < newtargets.length; ++i) {
                        descriptors[i] = this.blockManager.getDatanodeManager().getDatanode(newtargets[i]);
                    }
                }
                if (closeFile && descriptors != null) {
                    for (i = 0; i < descriptors.length; ++i) {
                        descriptors[i].addBlock(storedBlock);
                    }
                }
                pendingFile.setLastBlock(storedBlock, descriptors);
            }
            src = this.leaseManager.findPath(pendingFile);
            if (closeFile) {
                this.commitOrCompleteLastBlock(pendingFile, storedBlock);
                this.finalizeINodeFileUnderConstruction(src, pendingFile);
            } else {
                this.dir.persistBlocks(src, pendingFile);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (closeFile) {
            LOG.info((Object)("commitBlockSynchronization(newblock=" + lastblock + ", file=" + src + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful"));
        } else {
            LOG.info((Object)("commitBlockSynchronization(" + lastblock + ") successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewLease(String holder) throws IOException {
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot renew lease for " + holder, this.safeMode);
            }
            this.leaseManager.renewLease(holder);
        }
        finally {
            this.writeUnlock();
        }
    }

    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, UnresolvedLinkException, IOException {
        try {
            return this.getListingInt(src, startAfter, needLocation);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listStatus", src);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryListing getListingInt(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, UnresolvedLinkException, IOException {
        DirectoryListing dl;
        FSPermissionChecker pc = this.getPermissionChecker();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (this.isPermissionEnabled) {
                if (this.dir.isDir(src)) {
                    this.checkPathAccess(pc, src, FsAction.READ_EXECUTE);
                } else {
                    this.checkTraverse(pc, src);
                }
            }
            this.logAuditEvent(true, "listStatus", src);
            dl = this.dir.getListing(src, startAfter, needLocation);
        }
        finally {
            this.readUnlock();
        }
        return dl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.writeLock();
        try {
            this.getBlockManager().getDatanodeManager().registerDatanode(nodeReg);
            this.checkSafeMode();
        }
        finally {
            this.writeUnlock();
        }
    }

    String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage.getStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeartbeatResponse handleHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, long blockPoolUsed, int xceiverCount, int xmitsInProgress, int failedVolumes) throws IOException {
        this.readLock();
        try {
            int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
            DatanodeCommand[] cmds = this.blockManager.getDatanodeManager().handleHeartbeat(nodeReg, this.blockPoolId, capacity, dfsUsed, remaining, blockPoolUsed, xceiverCount, maxTransfer, failedVolumes);
            HeartbeatResponse heartbeatResponse = new HeartbeatResponse(cmds, this.createHaStatusHeartbeat());
            return heartbeatResponse;
        }
        finally {
            this.readUnlock();
        }
    }

    private NNHAStatusHeartbeat createHaStatusHeartbeat() {
        HAState state = this.haContext.getState();
        return new NNHAStatusHeartbeat(state.getServiceState(), this.getFSImage().getLastAppliedOrWrittenTxId());
    }

    boolean nameNodeHasResourcesAvailable() {
        return this.hasResourcesAvailable;
    }

    void checkAvailableResources() {
        Preconditions.checkState((this.nnResourceChecker != null ? 1 : 0) != 0, (Object)"nnResourceChecker not initialized");
        this.hasResourcesAvailable = this.nnResourceChecker.hasAvailableDiskSpace();
    }

    public FSImage getFSImage() {
        return this.dir.fsImage;
    }

    public FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    private void checkBlock(ExtendedBlock block) throws IOException {
        if (block != null && !this.blockPoolId.equals(block.getBlockPoolId())) {
            throw new IOException("Unexpected BlockPoolId " + block.getBlockPoolId() + " - expected " + this.blockPoolId);
        }
    }

    @Metric(value={"MissingBlocks", "Number of missing blocks"})
    public long getMissingBlocksCount() {
        return this.blockManager.getMissingBlocksCount();
    }

    @Metric(value={"ExpiredHeartbeats", "Number of expired heartbeats"})
    public int getExpiredHeartbeats() {
        return this.datanodeStatistics.getExpiredHeartbeats();
    }

    @Metric(value={"TransactionsSinceLastCheckpoint", "Number of transactions since last checkpoint"})
    public long getTransactionsSinceLastCheckpoint() {
        return this.getEditLog().getLastWrittenTxId() - this.getFSImage().getStorage().getMostRecentCheckpointTxId();
    }

    @Metric(value={"TransactionsSinceLastLogRoll", "Number of transactions since last edit log roll"})
    public long getTransactionsSinceLastLogRoll() {
        if (this.isInStandbyState() || !this.getEditLog().isSegmentOpen()) {
            return 0L;
        }
        return this.getEditLog().getLastWrittenTxId() - this.getEditLog().getCurSegmentTxId() + 1L;
    }

    @Metric(value={"LastWrittenTransactionId", "Transaction ID written to the edit log"})
    public long getLastWrittenTransactionId() {
        return this.getEditLog().getLastWrittenTxId();
    }

    @Metric(value={"LastCheckpointTime", "Time in milliseconds since the epoch of the last checkpoint"})
    public long getLastCheckpointTime() {
        return this.getFSImage().getStorage().getMostRecentCheckpointTime();
    }

    long[] getStats() {
        long[] stats = this.datanodeStatistics.getStats();
        stats[3] = this.getUnderReplicatedBlocks();
        stats[4] = this.getCorruptReplicaBlocks();
        stats[5] = this.getMissingBlocksCount();
        return stats;
    }

    @Override
    @Metric(value={"CapacityTotal", "Total raw capacity of data nodes in bytes"})
    public long getCapacityTotal() {
        return this.datanodeStatistics.getCapacityTotal();
    }

    @Metric(value={"CapacityTotalGB", "Total raw capacity of data nodes in GB"})
    public float getCapacityTotalGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityTotal());
    }

    @Override
    @Metric(value={"CapacityUsed", "Total used capacity across all data nodes in bytes"})
    public long getCapacityUsed() {
        return this.datanodeStatistics.getCapacityUsed();
    }

    @Metric(value={"CapacityUsedGB", "Total used capacity across all data nodes in GB"})
    public float getCapacityUsedGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityUsed());
    }

    @Override
    @Metric(value={"CapacityRemaining", "Remaining capacity in bytes"})
    public long getCapacityRemaining() {
        return this.datanodeStatistics.getCapacityRemaining();
    }

    @Metric(value={"CapacityRemainingGB", "Remaining capacity in GB"})
    public float getCapacityRemainingGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityRemaining());
    }

    @Metric(value={"CapacityUsedNonDFS", "Total space used by data nodes for non DFS purposes in bytes"})
    public long getCapacityUsedNonDFS() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    @Metric
    public int getTotalLoad() {
        return this.datanodeStatistics.getXceiverCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfDatanodes(HdfsConstants.DatanodeReportType type) {
        this.readLock();
        try {
            int n = this.getBlockManager().getDatanodeManager().getDatanodeListForReport(type).size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws AccessControlException {
        this.checkSuperuserPrivilege();
        this.readLock();
        try {
            DatanodeManager dm = this.getBlockManager().getDatanodeManager();
            List<DatanodeDescriptor> results = dm.getDatanodeListForReport(type);
            DatanodeInfo[] arr = new DatanodeInfo[results.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new DatanodeInfo(results.get(i));
            }
            DatanodeInfo[] datanodeInfoArray = arr;
            return datanodeInfoArray;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNamespace() throws AccessControlException, IOException {
        this.checkSuperuserPrivilege();
        this.readLock();
        try {
            if (!this.isInSafeMode()) {
                throw new IOException("Safe mode should be turned ON in order to create namespace image.");
            }
            this.getFSImage().saveNamespace(this);
            LOG.info((Object)"New namespace image has been created");
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restoreFailedStorage(String arg) throws AccessControlException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            if (arg.equals("check")) {
                boolean bl = this.getFSImage().getStorage().getRestoreFailedStorage();
                return bl;
            }
            boolean val = arg.equals("true");
            this.getFSImage().getStorage().setRestoreFailedStorage(val);
            boolean bl = val;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    Date getStartTime() {
        return new Date(this.startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.getFSImage().finalizeUpgrade();
        }
        finally {
            this.writeUnlock();
        }
    }

    void refreshNodes() throws IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().refreshNodes(new HdfsConfiguration());
    }

    void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
    }

    boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        if (action != HdfsConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode();
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode(false);
                    break;
                }
                default: {
                    LOG.error((Object)"Unexpected safe mode action");
                }
            }
        }
        return this.isInSafeMode();
    }

    @Override
    public void checkSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode != null) {
            safeMode.checkMode();
        }
    }

    @Override
    public boolean isInSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return safeMode.isOn();
    }

    @Override
    public boolean isInStartupSafeMode() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && safeMode.isOn();
    }

    @Override
    public boolean isPopulatingReplQueues() {
        if (!this.shouldPopulateReplQueues()) {
            return false;
        }
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return true;
        }
        return safeMode.isPopulatingReplQueues();
    }

    private boolean shouldPopulateReplQueues() {
        if (this.haContext == null || this.haContext.getState() == null) {
            return false;
        }
        return this.haContext.getState().shouldPopulateReplQueues();
    }

    @Override
    public void incrementSafeBlockCount(int replication) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.incrementSafeBlockCount((short)replication);
    }

    @Override
    public void decrementSafeBlockCount(Block b) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        BlockInfo storedBlock = this.blockManager.getStoredBlock(b);
        if (storedBlock.isComplete()) {
            safeMode.decrementSafeBlockCount((short)this.blockManager.countNodes(b).liveReplicas());
        }
    }

    @Override
    public void adjustSafeModeBlockTotals(int deltaSafe, int deltaTotal) {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.adjustBlockTotals(deltaSafe, deltaTotal);
    }

    public void setBlockTotal() {
        SafeModeInfo safeMode = this.safeMode;
        if (safeMode == null) {
            return;
        }
        safeMode.setBlockTotal((int)this.getCompleteBlocksTotal());
    }

    @Override
    @Metric
    public long getBlocksTotal() {
        return this.blockManager.getTotalBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCompleteBlocksTotal() {
        long numUCBlocks = 0L;
        this.readLock();
        try {
            for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
                for (String path : lease.getPaths()) {
                    INodeFileUnderConstruction cons;
                    try {
                        cons = INodeFileUnderConstruction.valueOf(this.dir.getINode(path), path);
                    }
                    catch (UnresolvedLinkException e) {
                        throw new AssertionError((Object)"Lease files should reside on this FS");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    BlockInfo[] blocks = cons.getBlocks();
                    if (blocks == null) continue;
                    for (BlockInfo b : blocks) {
                        if (b.isComplete()) continue;
                        ++numUCBlocks;
                    }
                }
            }
            LOG.info((Object)("Number of blocks under construction: " + numUCBlocks));
            long l = this.getBlocksTotal() - numUCBlocks;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterSafeMode(boolean resourcesLow) throws IOException {
        this.writeLock();
        try {
            this.stopSecretManager();
            boolean isEditlogOpenForWrite = this.getEditLog().isOpenForWrite();
            if (isEditlogOpenForWrite) {
                this.getEditLog().logSyncAll();
            }
            if (!this.isInSafeMode()) {
                this.safeMode = new SafeModeInfo(resourcesLow);
                return;
            }
            if (resourcesLow) {
                this.safeMode.setResourcesLow();
            }
            this.safeMode.setManual();
            if (isEditlogOpenForWrite) {
                this.getEditLog().logSyncAll();
            }
            NameNode.stateChangeLog.info((Object)("STATE* Safe mode is ON" + this.safeMode.getTurnOffTip()));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveSafeMode() {
        this.writeLock();
        try {
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already OFF");
                return;
            }
            this.safeMode.leave();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSafeModeTip() {
        this.readLock();
        try {
            if (!this.isInSafeMode()) {
                String string = "";
                return string;
            }
            String string = this.safeMode.getTurnOffTip();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CheckpointSignature rollEditLog() throws IOException {
        this.checkSuperuserPrivilege();
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.JOURNAL);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Log not rolled", this.safeMode);
            }
            LOG.info((Object)("Roll Edit Log from " + Server.getRemoteAddress()));
            CheckpointSignature checkpointSignature = this.getFSImage().rollEditLog();
            return checkpointSignature;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamenodeCommand startCheckpoint(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Checkpoint not started", this.safeMode);
            }
            LOG.info((Object)("Start checkpoint for " + bnReg.getAddress()));
            NamenodeCommand cmd = this.getFSImage().startCheckpoint(bnReg, nnReg);
            this.getEditLog().logSync();
            NamenodeCommand namenodeCommand = cmd;
            return namenodeCommand;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.CHECKPOINT);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Checkpoint not ended", this.safeMode);
            }
            LOG.info((Object)("End checkpoint for " + registration.getAddress()));
            this.getFSImage().endCheckpoint(sig);
        }
        finally {
            this.readUnlock();
        }
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.supergroup, permission);
    }

    private void checkOwner(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, true, null, null, null, null);
    }

    private void checkPathAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, access, null);
    }

    private void checkParentAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, access, null, null);
    }

    private void checkAncestorAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, access, null, null, null);
    }

    private void checkTraverse(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, null, null);
    }

    @Override
    public void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException, UnresolvedLinkException {
        if (!pc.isSuperUser()) {
            this.dir.waitForReady();
            this.readLock();
            try {
                pc.checkPermission(path, this.dir.rootDir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    long getMaxObjects() {
        return this.maxFsObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Metric
    public long getFilesTotal() {
        this.readLock();
        try {
            long l = this.dir.totalInodes();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    @Metric
    public long getPendingReplicationBlocks() {
        return this.blockManager.getPendingReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getUnderReplicatedBlocks() {
        return this.blockManager.getUnderReplicatedBlocksCount();
    }

    @Metric(value={"CorruptBlocks", "Number of blocks with corrupt replicas"})
    public long getCorruptReplicaBlocks() {
        return this.blockManager.getCorruptReplicaBlocksCount();
    }

    @Override
    @Metric
    public long getScheduledReplicationBlocks() {
        return this.blockManager.getScheduledReplicationBlocksCount();
    }

    @Metric
    public long getPendingDeletionBlocks() {
        return this.blockManager.getPendingDeletionBlocksCount();
    }

    @Metric
    public long getExcessBlocks() {
        return this.blockManager.getExcessBlocksCount();
    }

    @Metric
    public long getPostponedMisreplicatedBlocks() {
        return this.blockManager.getPostponedMisreplicatedBlocksCount();
    }

    @Metric
    public int getPendingDataNodeMessageCount() {
        return this.blockManager.getPendingDataNodeMessageCount();
    }

    @Metric
    public String getHAState() {
        return this.haContext.getState().toString();
    }

    @Metric
    public long getMillisSinceLastLoadedEdits() {
        if (this.isInStandbyState() && this.editLogTailer != null) {
            return Time.now() - this.editLogTailer.getLastLoadTimestamp();
        }
        return 0L;
    }

    @Metric
    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    private void registerMBean() {
        try {
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad MBean setup", e);
        }
        LOG.info((Object)"Registered FSNamesystemState MBean");
    }

    void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
        }
    }

    @Override
    public int getNumLiveDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumLiveDataNodes();
    }

    @Override
    public int getNumDeadDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumDeadDataNodes();
    }

    @Override
    @Metric(value={"StaleDataNodes", "Number of datanodes marked stale due to delayed heartbeat"})
    public int getNumStaleDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumStaleNodes();
    }

    void setGenerationStamp(long stamp) {
        this.generationStamp.setStamp(stamp);
    }

    long getGenerationStamp() {
        return this.generationStamp.getStamp();
    }

    private long nextGenerationStamp() throws SafeModeException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot get next generation stamp", this.safeMode);
        }
        long gs = this.generationStamp.nextStamp();
        this.getEditLog().logGenerationStamp(gs);
        return gs;
    }

    private INodeFileUnderConstruction checkUCBlock(ExtendedBlock block, String clientName) throws IOException {
        assert (this.hasWriteLock());
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot get a new generation stamp and an access token for block " + block, this.safeMode);
        }
        BlockInfo storedBlock = this.blockManager.getStoredBlock(ExtendedBlock.getLocalBlock(block));
        if (storedBlock == null || storedBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException(block + " does not exist or is not under Construction" + storedBlock);
        }
        INodeFile file = (INodeFile)storedBlock.getBlockCollection();
        if (file == null || !file.isUnderConstruction()) {
            throw new IOException("The file " + storedBlock + " belonged to does not exist or it is not under construction.");
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (clientName == null || !clientName.equals(pendingFile.getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return pendingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            NameNode.stateChangeLog.info((Object)"*DIR* reportBadBlocks");
            for (int i = 0; i < blocks.length; ++i) {
                ExtendedBlock blk = blocks[i].getBlock();
                DatanodeInfo[] nodes = blocks[i].getLocations();
                for (int j = 0; j < nodes.length; ++j) {
                    DatanodeInfo dn = nodes[j];
                    this.blockManager.findAndMarkBlockAsCorrupt(blk, dn, "client machine reported it");
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        LocatedBlock locatedBlock;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            this.checkUCBlock(block, clientName);
            block.setGenerationStamp(this.nextGenerationStamp());
            locatedBlock = new LocatedBlock(block, new DatanodeInfo[0]);
            this.blockManager.setBlockToken(locatedBlock, BlockTokenSecretManager.AccessMode.WRITE);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return locatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes) throws IOException {
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Pipeline not updated", this.safeMode);
            }
            assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
            LOG.info((Object)("updatePipeline(block=" + oldBlock + ", newGenerationStamp=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", clientName=" + clientName + ")"));
            this.updatePipelineInternal(clientName, oldBlock, newBlock, newNodes);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        LOG.info((Object)("updatePipeline(" + oldBlock + ") successfully to " + newBlock));
    }

    private void updatePipelineInternal(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes) throws IOException {
        assert (this.hasWriteLock());
        INodeFileUnderConstruction pendingFile = this.checkUCBlock(oldBlock, clientName);
        BlockInfoUnderConstruction blockinfo = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
        if (newBlock.getGenerationStamp() <= blockinfo.getGenerationStamp() || newBlock.getNumBytes() < blockinfo.getNumBytes()) {
            String msg = "Update " + oldBlock + " (len = " + blockinfo.getNumBytes() + ") to an older state: " + newBlock + " (len = " + newBlock.getNumBytes() + ")";
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        blockinfo.setGenerationStamp(newBlock.getGenerationStamp());
        blockinfo.setNumBytes(newBlock.getNumBytes());
        DatanodeManager dm = this.getBlockManager().getDatanodeManager();
        DatanodeDescriptor[] descriptors = null;
        if (newNodes.length > 0) {
            descriptors = new DatanodeDescriptor[newNodes.length];
            for (int i = 0; i < newNodes.length; ++i) {
                descriptors[i] = dm.getDatanode(newNodes[i]);
            }
        }
        blockinfo.setExpectedLocations(descriptors);
        String src = this.leaseManager.findPath(pendingFile);
        this.dir.persistBlocks(src, pendingFile);
    }

    void unprotectedChangeLease(String src, String dst) {
        assert (this.hasWriteLock());
        this.leaseManager.changeLease(src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFilesUnderConstruction(DataOutputStream out) throws IOException {
        LeaseManager leaseManager = this.leaseManager;
        synchronized (leaseManager) {
            Map<String, INodeFileUnderConstruction> nodes = this.leaseManager.getINodesUnderConstruction();
            out.writeInt(nodes.size());
            for (Map.Entry<String, INodeFileUnderConstruction> entry : nodes.entrySet()) {
                FSImageSerialization.writeINodeUnderConstruction(out, entry.getValue(), entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerBackupNode(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getStorage().getNamespaceID() != bnReg.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)bnReg.getRole()) + " node namespaceID = " + bnReg.getNamespaceID());
            }
            if (bnReg.getRole() == HdfsServerConstants.NamenodeRole.BACKUP) {
                this.getFSImage().getEditLog().registerBackupNode(bnReg, nnReg);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBackupNode(NamenodeRegistration registration) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getStorage().getNamespaceID() != registration.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getStorage().getNamespaceID() + "; " + (Object)((Object)registration.getRole()) + " node namespaceID = " + registration.getNamespaceID());
            }
            this.getEditLog().releaseBackupStream(registration);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(String path, String[] cookieTab) throws IOException {
        this.checkSuperuserPrivilege();
        this.readLock();
        try {
            this.checkOperation(NameNode.OperationCategory.READ);
            if (!this.isPopulatingReplQueues()) {
                throw new IOException("Cannot run listCorruptFileBlocks because replication queues have not been initialized.");
            }
            int count = 0;
            ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
            Iterator<Block> blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
            if (cookieTab == null) {
                cookieTab = new String[]{null};
            }
            int skip = FSNamesystem.getIntCookie(cookieTab[0]);
            for (int i = 0; i < skip && blkIterator.hasNext(); ++i) {
                blkIterator.next();
            }
            while (blkIterator.hasNext()) {
                String src;
                Block blk = blkIterator.next();
                INodeFile inode = (INodeFile)this.blockManager.getBlockCollection(blk);
                ++skip;
                if (inode == null || this.blockManager.countNodes(blk).liveReplicas() != 0 || !(src = FSDirectory.getFullPathName(inode)).startsWith(path)) continue;
                corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                if (++count < 100) continue;
                break;
            }
            cookieTab[0] = String.valueOf(skip);
            LOG.info((Object)("list corrupt file blocks returned: " + count));
            ArrayList<CorruptFileBlockInfo> arrayList = corruptFiles;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private static int getIntCookie(String cookie) {
        int c;
        if (cookie == null) {
            c = 0;
        } else {
            try {
                c = Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                c = 0;
            }
        }
        c = Math.max(0, c);
        return c;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, this);
    }

    DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token token;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot issue delegation token", this.safeMode);
            }
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
            }
            if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
                LOG.warn((Object)"trying to get DT with no secret manager running");
                Token<DelegationTokenIdentifier> token2 = null;
                return token2;
            }
            UserGroupInformation ugi = FSNamesystem.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
            token = new Token((TokenIdentifier)dtId, (SecretManager)this.dtSecretManager);
            long expiryTime = this.dtSecretManager.getTokenExpiryTime(dtId);
            this.getEditLog().logGetDelegationToken(dtId, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        long expiryTime;
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot renew delegation token", this.safeMode);
            }
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
            }
            String renewer = FSNamesystem.getRemoteUser().getShortUserName();
            expiryTime = this.dtSecretManager.renewToken(token, renewer);
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
            DataInputStream in = new DataInputStream(buf);
            id.readFields(in);
            this.getEditLog().logRenewDelegationToken(id, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.writeLock();
        try {
            this.checkOperation(NameNode.OperationCategory.WRITE);
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot cancel delegation token", this.safeMode);
            }
            String canceller = FSNamesystem.getRemoteUser().getUserName();
            DelegationTokenIdentifier id = (DelegationTokenIdentifier)this.dtSecretManager.cancelToken(token, canceller);
            this.getEditLog().logCancelDelegationToken(id);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    void saveSecretManagerState(DataOutputStream out) throws IOException {
        this.dtSecretManager.saveSecretManagerState(out);
    }

    void loadSecretManagerState(DataInputStream in) throws IOException {
        this.dtSecretManager.loadSecretManagerState(in);
    }

    public void logUpdateMasterKey(DelegationKey key) {
        assert (!this.isInSafeMode()) : "this should never be called while in safemode, since we stop the DT manager before entering safemode!";
        this.getEditLog().logUpdateMasterKey(key);
        this.getEditLog().logSync();
    }

    private void logReassignLease(String leaseHolder, String src, String newHolder) {
        assert (this.hasWriteLock());
        this.getEditLog().logReassignLease(leaseHolder, src, newHolder);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = FSNamesystem.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private boolean isExternalInvocation() {
        return Server.isRpcInvocation() || NamenodeWebHdfsMethods.isWebHdfsInvocation();
    }

    private static InetAddress getRemoteIp() {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            return ip;
        }
        return NamenodeWebHdfsMethods.getRemoteIp();
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = null;
        if (Server.isRpcInvocation()) {
            ugi = Server.getRemoteUser();
        }
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (this.isAuditEnabled()) {
            this.logAuditEvent(true, FSNamesystem.getRemoteUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)this);
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON." + this.getSafeModeTip();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.getFSImage().isUpgradeFinalized();
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.datanodeStatistics.getCapacityUsedPercent();
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return this.datanodeStatistics.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.datanodeStatistics.getPercentBlockPoolUsed();
    }

    @Override
    public float getPercentRemaining() {
        return this.datanodeStatistics.getCapacityRemainingPercent();
    }

    @Override
    public long getTotalBlocks() {
        return this.getBlocksTotal();
    }

    @Override
    @Metric
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public long getNumberOfMissingBlocks() {
        return this.getMissingBlocksCount();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        for (DatanodeDescriptor node : live) {
            HashMap<String, Object> innerinfo = new HashMap<String, Object>();
            innerinfo.put("lastContact", this.getLastContact(node));
            innerinfo.put("usedSpace", this.getDfsUsed(node));
            innerinfo.put("adminState", node.getAdminState().toString());
            innerinfo.put("nonDfsUsedSpace", node.getNonDfsUsed());
            innerinfo.put("capacity", node.getCapacity());
            innerinfo.put("numBlocks", node.numBlocks());
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(null, dead, true);
        for (DatanodeDescriptor node : dead) {
            HashMap<String, Constable> innerinfo = new HashMap<String, Constable>();
            innerinfo.put("lastContact", Long.valueOf(this.getLastContact(node)));
            innerinfo.put("decommissioned", Boolean.valueOf(node.isDecommissioned()));
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap info = new HashMap();
        List<DatanodeDescriptor> decomNodeList = this.blockManager.getDatanodeManager().getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            HashMap<String, Integer> innerinfo = new HashMap<String, Integer>();
            innerinfo.put("underReplicatedBlocks", node.decommissioningStatus.getUnderReplicatedBlocks());
            innerinfo.put("decommissionOnlyReplicas", node.decommissioningStatus.getDecommissionOnlyReplicas());
            innerinfo.put("underReplicateInOpenFiles", node.decommissioningStatus.getUnderReplicatedInOpenFiles());
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (Time.now() - alivenode.getLastUpdate()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor alivenode) {
        return alivenode.getDfsUsed();
    }

    @Override
    public String getClusterId() {
        return this.dir.fsImage.getStorage().getClusterID();
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    @Override
    public String getNameDirStatuses() {
        HashMap statusMap = new HashMap();
        HashMap<File, Storage.StorageDirType> activeDirs = new HashMap<File, Storage.StorageDirType>();
        Iterator<Storage.StorageDirectory> it = this.getFSImage().getStorage().dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory st = it.next();
            activeDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("active", activeDirs);
        List<Storage.StorageDirectory> removedStorageDirs = this.getFSImage().getStorage().getRemovedStorageDirs();
        HashMap<File, Storage.StorageDirType> failedDirs = new HashMap<File, Storage.StorageDirType>();
        for (Storage.StorageDirectory st : removedStorageDirs) {
            failedDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("failed", failedDirs);
        return JSON.toString(statusMap);
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public synchronized void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken {
        this.getDelegationTokenSecretManager().verifyToken(identifier, password);
    }

    @Override
    public boolean isGenStampInFuture(long genStamp) {
        return genStamp > this.getGenerationStamp();
    }

    @VisibleForTesting
    public EditLogTailer getEditLogTailer() {
        return this.editLogTailer;
    }

    @VisibleForTesting
    void setFsLockForTests(ReentrantReadWriteLock lock) {
        this.fsLock = lock;
    }

    @VisibleForTesting
    ReentrantReadWriteLock getFsLockForTests() {
        return this.fsLock;
    }

    @VisibleForTesting
    public SafeModeInfo getSafeModeInfoForTests() {
        return this.safeMode;
    }

    @VisibleForTesting
    public void setNNResourceChecker(NameNodeResourceChecker nnResourceChecker) {
        this.nnResourceChecker = nnResourceChecker;
    }

    @Override
    public boolean isAvoidingStaleDataNodesForWrite() {
        return this.blockManager.getDatanodeManager().shouldAvoidStaleDataNodesForWrite();
    }

    private static class DefaultAuditLogger
    implements AuditLogger {
        private DefaultAuditLogger() {
        }

        @Override
        public void initialize(Configuration conf) {
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status) {
            if (auditLog.isInfoEnabled()) {
                StringBuilder sb = (StringBuilder)auditBuffer.get();
                sb.setLength(0);
                sb.append("allowed=").append(succeeded).append("\t");
                sb.append("ugi=").append(userName).append("\t");
                sb.append("ip=").append(addr).append("\t");
                sb.append("cmd=").append(cmd).append("\t");
                sb.append("src=").append(src).append("\t");
                sb.append("dst=").append(dst).append("\t");
                if (null == status) {
                    sb.append("perm=null");
                } else {
                    sb.append("perm=");
                    sb.append(status.getOwner()).append(":");
                    sb.append(status.getGroup()).append(":");
                    sb.append(status.getPermission());
                }
                auditLog.info((Object)sb);
            }
        }
    }

    static class CorruptFileBlockInfo {
        String path;
        Block block;

        public CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && FSNamesystem.this.safeMode != null && !FSNamesystem.this.safeMode.canLeave()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!FSNamesystem.this.fsRunning) {
                LOG.info((Object)"NameNode is being shutdown, exit SafeModeMonitor thread");
            } else {
                FSNamesystem.this.leaveSafeMode();
            }
            FSNamesystem.this.smmthread = null;
        }
    }

    class SafeModeInfo {
        private double threshold;
        private int datanodeThreshold;
        private int extension;
        private int safeReplication;
        private double replQueueThreshold;
        private long reached = -1L;
        int blockTotal;
        int blockSafe;
        private int blockThreshold;
        private int blockReplQueueThreshold;
        private long lastStatusReport = 0L;
        boolean initializedReplQueues = false;
        private boolean resourcesLow = false;
        private boolean shouldIncrementallyTrackBlocks = false;

        private SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.namenode.safemode.threshold-pct", 0.999f);
            if (this.threshold > 1.0) {
                LOG.warn((Object)("The threshold value should't be greater than 1, threshold: " + this.threshold));
            }
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.namenode.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.namenode.replication.min", 1);
            LOG.info((Object)("dfs.namenode.safemode.threshold-pct = " + this.threshold));
            LOG.info((Object)("dfs.namenode.safemode.min.datanodes = " + this.datanodeThreshold));
            LOG.info((Object)("dfs.namenode.safemode.extension     = " + this.extension));
            this.replQueueThreshold = conf.getFloat("dfs.namenode.replqueue.threshold-pct", (float)this.threshold);
            this.blockTotal = 0;
            this.blockSafe = 0;
        }

        private boolean shouldIncrementallyTrackBlocks() {
            return this.shouldIncrementallyTrackBlocks;
        }

        private SafeModeInfo(boolean resourcesLow) {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.replQueueThreshold = 1.5;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.reached = -1L;
            this.resourcesLow = resourcesLow;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        private synchronized boolean isOn() {
            this.doConsistencyCheck();
            return this.reached >= 0L;
        }

        private synchronized boolean isPopulatingReplQueues() {
            return this.initializedReplQueues;
        }

        private void enter() {
            this.reached = 0L;
        }

        private synchronized void leave() {
            if (!this.isPopulatingReplQueues() && FSNamesystem.this.shouldPopulateReplQueues()) {
                this.initializeReplQueues();
            }
            long timeInSafemode = Time.now() - FSNamesystem.this.startTime;
            NameNode.stateChangeLog.info((Object)("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs"));
            NameNode.getNameNodeMetrics().setSafeModeTime((int)timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is OFF");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NetworkTopology nt = FSNamesystem.this.blockManager.getDatanodeManager().getNetworkTopology();
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + nt.getNumOfRacks() + " racks and " + nt.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.blockManager.numOfUnderReplicatedBlocks() + " blocks"));
            FSNamesystem.this.startSecretManagerIfNecessary();
        }

        private synchronized void initializeReplQueues() {
            LOG.info((Object)"initializing replication queues");
            assert (!this.isPopulatingReplQueues()) : "Already initialized repl queues";
            long startTimeMisReplicatedScan = Time.now();
            FSNamesystem.this.blockManager.processMisReplicatedBlocks();
            this.initializedReplQueues = true;
            NameNode.stateChangeLog.info((Object)("STATE* Replication Queue initialization scan for invalid, over- and under-replicated blocks completed in " + (Time.now() - startTimeMisReplicatedScan) + " msec"));
        }

        private synchronized boolean canInitializeReplQueues() {
            return FSNamesystem.this.shouldPopulateReplQueues() && this.blockSafe >= this.blockReplQueueThreshold;
        }

        private synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (Time.now() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return false;
            }
            return !this.needEnter();
        }

        private boolean needEnter() {
            return this.threshold != 0.0 && this.blockSafe < this.blockThreshold || FSNamesystem.this.getNumLiveDataNodes() < this.datanodeThreshold || !FSNamesystem.this.nameNodeHasResourcesAvailable();
        }

        private void checkMode() {
            assert (FSNamesystem.this.hasWriteLock());
            if (this.needEnter()) {
                this.enter();
                if (this.canInitializeReplQueues() && !this.isPopulatingReplQueues()) {
                    this.initializeReplQueues();
                }
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave();
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            this.reached = Time.now();
            FSNamesystem.this.smmthread = new Daemon((Runnable)new SafeModeMonitor());
            FSNamesystem.this.smmthread.start();
            this.reportStatus("STATE* Safe mode extension entered.", true);
            if (this.canInitializeReplQueues() && !this.isPopulatingReplQueues()) {
                this.initializeReplQueues();
            }
        }

        private synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.blockThreshold = (int)((double)this.blockTotal * this.threshold);
            this.blockReplQueueThreshold = (int)((double)this.blockTotal * this.replQueueThreshold);
            if (FSNamesystem.this.haEnabled) {
                this.shouldIncrementallyTrackBlocks = true;
            }
            if (this.blockSafe < 0) {
                this.blockSafe = 0;
            }
            this.checkMode();
        }

        private synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
                this.checkMode();
            }
        }

        private synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
                assert (this.blockSafe >= 0 || this.isManual());
                this.checkMode();
            }
        }

        private boolean isManual() {
            return this.extension == Integer.MAX_VALUE && !this.resourcesLow;
        }

        private synchronized void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        private boolean areResourcesLow() {
            return this.resourcesLow;
        }

        private void setResourcesLow() {
            this.resourcesLow = true;
        }

        String getTurnOffTip() {
            if (this.reached < 0L) {
                return "Safe mode is OFF.";
            }
            String leaveMsg = "";
            leaveMsg = this.areResourcesLow() ? "Resources are low on NN. Please add or free up more resources then turn off safe mode manually.  NOTE:  If you turn off safe mode before adding resources, the NN will immediately return to safe mode." : "Safe mode will be turned off automatically";
            if (this.isManual()) {
                leaveMsg = "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off";
            }
            if (this.blockTotal < 0) {
                return leaveMsg + ".";
            }
            int numLive = FSNamesystem.this.getNumLiveDataNodes();
            String msg = "";
            if (this.reached == 0L) {
                if (this.blockSafe < this.blockThreshold) {
                    msg = msg + String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.", this.blockSafe, this.blockThreshold - this.blockSafe + 1, this.threshold, this.blockTotal);
                }
                if (numLive < this.datanodeThreshold) {
                    if (!"".equals(msg)) {
                        msg = msg + "\n";
                    }
                    msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.", numLive, this.datanodeThreshold - numLive, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            } else {
                msg = String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d.", this.blockSafe, this.threshold, this.blockTotal);
                if (this.datanodeThreshold > 0) {
                    msg = msg + String.format(" The number of live datanodes %d has reached the minimum number %d.", numLive, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            }
            if (this.reached == 0L || this.isManual()) {
                return msg + ".";
            }
            return msg + " in " + Math.abs(this.reached + (long)this.extension - Time.now()) / 1000L + " seconds.";
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = Time.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info((Object)(msg + " \n" + this.getTurnOffTip()));
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe blocks = " + this.blockSafe + ". Target blocks = " + this.blockThreshold + " for threshold = %" + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        private void doConsistencyCheck() {
            boolean assertsOn = false;
            if (!$assertionsDisabled) {
                assertsOn = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (!assertsOn) {
                return;
            }
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return;
            }
            int activeBlocks = FSNamesystem.this.blockManager.getActiveBlockCount();
            if (this.blockTotal != activeBlocks && (this.blockSafe < 0 || this.blockSafe > this.blockTotal)) {
                throw new AssertionError((Object)(" SafeMode: Inconsistent filesystem state: SafeMode data: blockTotal=" + this.blockTotal + " blockSafe=" + this.blockSafe + "; " + "BlockManager data: active=" + activeBlocks));
            }
        }

        private synchronized void adjustBlockTotals(int deltaSafe, int deltaTotal) {
            if (!this.shouldIncrementallyTrackBlocks) {
                return;
            }
            assert (FSNamesystem.this.haEnabled);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adjusting block totals from " + this.blockSafe + "/" + this.blockTotal + " to " + (this.blockSafe + deltaSafe) + "/" + (this.blockTotal + deltaTotal)));
            }
            assert (this.blockSafe + deltaSafe >= 0) : "Can't reduce blockSafe " + this.blockSafe + " by " + deltaSafe + ": would be negative";
            assert (this.blockTotal + deltaTotal >= 0) : "Can't reduce blockTotal " + this.blockTotal + " by " + deltaTotal + ": would be negative";
            this.blockSafe += deltaSafe;
            this.setBlockTotal(this.blockTotal + deltaTotal);
        }
    }

    class NameNodeResourceMonitor
    implements Runnable {
        boolean shouldNNRmRun = true;

        NameNodeResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning && this.shouldNNRmRun) {
                    FSNamesystem.this.checkAvailableResources();
                    if (!FSNamesystem.this.nameNodeHasResourcesAvailable()) {
                        String lowResourcesMsg = "NameNode low on available disk space. ";
                        if (!FSNamesystem.this.isInSafeMode()) {
                            LOG.warn((Object)(lowResourcesMsg + "Entering safe mode."));
                        } else {
                            LOG.warn((Object)(lowResourcesMsg + "Already in safe mode."));
                        }
                        FSNamesystem.this.enterSafeMode(true);
                    }
                    try {
                        Thread.sleep(FSNamesystem.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception in NameNodeResourceMonitor: ", (Throwable)e);
            }
        }

        public void stopMonitor() {
            this.shouldNNRmRun = false;
        }
    }
}

