/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTokenStore
implements TokenStore {
    boolean autoRemove = true;
    Map<String, SecurityToken> tokens = new ConcurrentHashMap<String, SecurityToken>();

    @Override
    public void add(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.tokens.put(token.getId(), token);
        }
    }

    @Override
    public void update(SecurityToken token) {
        if (this.autoRemove && (token.getState() == SecurityToken.State.EXPIRED || token.getState() == SecurityToken.State.CANCELLED)) {
            this.remove(token);
        } else {
            this.add(token);
        }
    }

    @Override
    public void remove(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.tokens.remove(token.getId());
        }
    }

    @Override
    public Collection<SecurityToken> getCancelledTokens() {
        return this.getTokens(SecurityToken.State.CANCELLED);
    }

    @Override
    public Collection<SecurityToken> getExpiredTokens() {
        return this.getTokens(SecurityToken.State.EXPIRED);
    }

    @Override
    public Collection<SecurityToken> getRenewedTokens() {
        return this.getTokens(SecurityToken.State.RENEWED);
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        this.processTokenExpiry();
        return this.tokens.keySet();
    }

    @Override
    public Collection<SecurityToken> getValidTokens() {
        Collection<SecurityToken> toks = this.getTokens(SecurityToken.State.ISSUED);
        toks.addAll(this.getTokens(SecurityToken.State.RENEWED));
        toks.addAll(this.getTokens(SecurityToken.State.UNKNOWN));
        return toks;
    }

    @Override
    public SecurityToken getToken(String id) {
        this.processTokenExpiry();
        SecurityToken token = this.tokens.get(id);
        if (token == null) {
            for (SecurityToken t : this.tokens.values()) {
                if (!id.equals(t.getWsuId())) continue;
                return t;
            }
        }
        return token;
    }

    @Override
    public SecurityToken getTokenByAssociatedHash(int hashCode) {
        this.processTokenExpiry();
        for (String id : this.tokens.keySet()) {
            SecurityToken securityToken = this.tokens.get(id);
            if (hashCode != securityToken.getAssociatedHash()) continue;
            return securityToken;
        }
        return null;
    }

    protected Collection<SecurityToken> getTokens(SecurityToken.State state) {
        this.processTokenExpiry();
        ArrayList<SecurityToken> t = new ArrayList<SecurityToken>();
        for (SecurityToken token : this.tokens.values()) {
            if (token.getState() != state) continue;
            t.add(token);
        }
        return t;
    }

    protected void processTokenExpiry() {
        for (SecurityToken token : this.tokens.values()) {
            if (token.getState() == SecurityToken.State.EXPIRED || token.getState() == SecurityToken.State.CANCELLED) {
                if (!this.autoRemove) continue;
                this.remove(token);
                continue;
            }
            if (token.getExpires() == null) continue;
            Date current = new Date();
            if (!token.getExpires().before(current)) continue;
            token.setState(SecurityToken.State.EXPIRED);
            if (!this.autoRemove) continue;
            this.remove(token);
        }
    }

    @Override
    public void removeCancelledTokens() {
        for (SecurityToken token : this.tokens.values()) {
            if (token.getState() != SecurityToken.State.CANCELLED) continue;
            this.remove(token);
        }
    }

    @Override
    public void removeExpiredTokens() {
        this.processTokenExpiry();
        for (SecurityToken token : this.tokens.values()) {
            if (token.getState() != SecurityToken.State.EXPIRED) continue;
            this.remove(token);
        }
    }

    @Override
    public void setAutoRemoveTokens(boolean auto) {
        this.autoRemove = auto;
    }
}

