/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.web.util.AggregateDefinitionRenderer;
import org.apache.camel.web.util.CatchDefinitionRenderer;
import org.apache.camel.web.util.ChoiceDefinitionRenderer;
import org.apache.camel.web.util.ConvertBodyDefinitionRenderer;
import org.apache.camel.web.util.ExpressionNodeRenderer;
import org.apache.camel.web.util.LoadBalanceDefinitionRenderer;
import org.apache.camel.web.util.OnCompletionDefinitionRenderer;
import org.apache.camel.web.util.OnExceptionDefinitionRenderer;
import org.apache.camel.web.util.OutputDefinitionRenderer;
import org.apache.camel.web.util.ResequenceDefinitionRenderer;
import org.apache.camel.web.util.RoutingSlipDefinitionRenderer;
import org.apache.camel.web.util.SendDefinitionRenderer;
import org.apache.camel.web.util.ThrottleDefinitionRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorDefinitionRenderer {
    private ProcessorDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition<?> processor) {
        OutputDefinition out;
        if (processor instanceof AggregateDefinition) {
            AggregateDefinitionRenderer.render(buffer, processor);
        } else {
            if (processor instanceof CatchDefinition) {
                CatchDefinitionRenderer.render(buffer, processor);
                return;
            }
            if (processor instanceof ChoiceDefinition) {
                ChoiceDefinitionRenderer.render(buffer, processor);
                return;
            }
            if (processor instanceof ConvertBodyDefinition) {
                ConvertBodyDefinitionRenderer.render(buffer, processor);
            } else if (processor instanceof ExpressionNode) {
                ExpressionNodeRenderer.render(buffer, processor);
            } else {
                if (processor instanceof LoadBalanceDefinition) {
                    LoadBalanceDefinitionRenderer.render(buffer, processor);
                    return;
                }
                if (processor instanceof OnCompletionDefinition) {
                    OnCompletionDefinitionRenderer.render(buffer, processor);
                    return;
                }
                if (processor instanceof OnExceptionDefinition) {
                    OnExceptionDefinitionRenderer.render(buffer, processor);
                    return;
                }
                if (processor instanceof OutputDefinition) {
                    OutputDefinitionRenderer.render(buffer, processor);
                } else if (processor instanceof ResequenceDefinition) {
                    ResequenceDefinitionRenderer.render(buffer, processor);
                } else if (processor instanceof RollbackDefinition) {
                    RollbackDefinition rollback = (RollbackDefinition)processor;
                    buffer.append(".").append(processor.getShortName()).append("(\"");
                    buffer.append(rollback.getMessage()).append("\")");
                } else if (processor instanceof RoutingSlipDefinition) {
                    RoutingSlipDefinitionRenderer.render(buffer, processor);
                } else if (processor instanceof SendDefinition) {
                    SendDefinitionRenderer.render(buffer, processor);
                } else if (processor instanceof ThrottleDefinition) {
                    ThrottleDefinitionRenderer.render(buffer, processor);
                } else {
                    buffer.append(".").append(processor.getShortName()).append("()");
                }
            }
        }
        if (processor instanceof OutputDefinition && (out = (OutputDefinition)processor) instanceof FinallyDefinition) {
            return;
        }
        List outputs = processor.getOutputs();
        for (ProcessorDefinition nextProcessor : outputs) {
            ProcessorDefinitionRenderer.render(buffer, nextProcessor);
        }
    }
}

