/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.web.util.SendDefinitionRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnExceptionDefinitionRenderer {
    private OnExceptionDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition<?> processor) {
        boolean notGlobal = buffer.toString().endsWith(")");
        if (notGlobal) {
            buffer.append(".");
        }
        OnExceptionDefinition onException = (OnExceptionDefinition)processor;
        buffer.append(processor.getShortName()).append("(");
        List exceptions = onException.getExceptionClasses();
        for (Class excep : exceptions) {
            buffer.append(excep.getSimpleName()).append(".class");
            if (excep == exceptions.get(exceptions.size() - 1)) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (onException.getHandledPolicy() != null) {
            String handled = onException.getHandledPolicy().toString();
            buffer.append(".handled(").append(handled).append(")");
        }
        List branches = onException.getOutputs();
        for (ProcessorDefinition branch : branches) {
            SendDefinitionRenderer.render(buffer, branch);
        }
    }
}

